/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.recording.ResponseDefinitionBodyMatcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ResponseDefinitionBodyMatcherTest {
    @Test
    public void noThresholds() {
        ResponseDefinitionBodyMatcher matcher = new ResponseDefinitionBodyMatcher(0L, 0L);
        Assertions.assertFalse((boolean)matcher.match(new ResponseDefinition()).isExactMatch());
        Assertions.assertTrue((boolean)matcher.match(ResponseDefinitionBodyMatcherTest.textResponseDefinition("a")).isExactMatch());
        Assertions.assertTrue((boolean)matcher.match(ResponseDefinitionBodyMatcherTest.binaryResponseDefinition(new byte[]{1})).isExactMatch());
    }

    @Test
    public void textBodyMatchingWithThreshold() {
        ResponseDefinitionBodyMatcher matcher = new ResponseDefinitionBodyMatcher(2L, 0L);
        Assertions.assertFalse((boolean)matcher.match(ResponseDefinitionBodyMatcherTest.textResponseDefinition("f")).isExactMatch());
        Assertions.assertFalse((boolean)matcher.match(ResponseDefinitionBodyMatcherTest.textResponseDefinition("fo")).isExactMatch());
        Assertions.assertTrue((boolean)matcher.match(ResponseDefinitionBodyMatcherTest.textResponseDefinition("foo")).isExactMatch());
    }

    @Test
    public void binaryBodyMatchingWithThreshold() {
        ResponseDefinitionBodyMatcher matcher = new ResponseDefinitionBodyMatcher(0L, 2L);
        Assertions.assertFalse((boolean)matcher.match(ResponseDefinitionBodyMatcherTest.binaryResponseDefinition(new byte[]{1})).isExactMatch());
        Assertions.assertFalse((boolean)matcher.match(ResponseDefinitionBodyMatcherTest.binaryResponseDefinition(new byte[]{1, 12})).isExactMatch());
        Assertions.assertTrue((boolean)matcher.match(ResponseDefinitionBodyMatcherTest.binaryResponseDefinition(new byte[]{1, 12, 15})).isExactMatch());
    }

    private static ResponseDefinition textResponseDefinition(String body) {
        return new ResponseDefinitionBuilder().withHeader("Content-Type", new String[]{"text/plain"}).withBody(body).build();
    }

    private static ResponseDefinition binaryResponseDefinition(byte[] body) {
        return new ResponseDefinitionBuilder().withBody(body).build();
    }
}

