/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.http.FormParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.ContainsPattern;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.EqualToJsonPattern;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.EqualToXmlPattern;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.MatchesJsonPathPattern;
import com.github.tomakehurst.wiremock.matching.MatchesXPathPattern;
import com.github.tomakehurst.wiremock.matching.MockRequest;
import com.github.tomakehurst.wiremock.matching.NegativeContainsPattern;
import com.github.tomakehurst.wiremock.matching.NegativeRegexPattern;
import com.github.tomakehurst.wiremock.matching.NotPattern;
import com.github.tomakehurst.wiremock.matching.RegexPattern;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.SingleMatchMultiValuePattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.util.HashMap;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.skyscreamer.jsonassert.JSONAssert;

public class RequestPatternTest {
    static final String URL_PATH_AND_HEADERS_EXAMPLE = "{\t\t\t\t\t\t\t\t\t                \n\t\t\"method\": \"GET\",\t\t\t\t\t\t\n\t\t\"urlPath\": \"/my/url\",             \t\t\n\t\t\"headers\": {\t\t\t\t\t\t\t\t\n\t\t\t\"Accept\": {\t\t\t\t\t\t\t\n\t\t\t\t\"matches\": \"(.*)xml(.*)\"\t\t\n\t\t\t},\t\t\t\t\t\t\t\t\t\t\n\t\t\t\"If-None-Match\": {\t\t\t\t\t\n\t\t\t\t\"matches\": \"([a-z0-9]*)\"\t\t\n\t\t\t}\t\t\t\t\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t    ";
    static final String ALL_BODY_PATTERNS_EXAMPLE = "{                                                      \n    \"url\" : \"/all/body/patterns\",                  \n    \"method\" : \"PUT\",                              \n    \"bodyPatterns\" : [                               \n        { \"equalTo\": \"thing\" },                    \n        { \"equalToJson\": \"{ \\\"thing\\\": 1 }\" }, \n        { \"matchesJsonPath\": \"@.*\" },              \n        { \"equalToXml\": \"<thing />\" },             \n        { \"matchesXPath\": \"//thing\" },             \n        { \"contains\": \"thin\" },                    \n        { \"doesNotContain\": \"stuff\" },            \n        { \"not\": { \"contains\": \"thing\" } },     \n        { \"matches\": \".*thing.*\" },                \n        { \"doesNotMatch\": \"^stuff.+\" }             \n    ]                                                  \n}";

    @Test
    public void matchesExactlyWith0DistanceWhenUrlAndMethodAreExactMatch() {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.PUT, (UrlPattern)WireMock.urlPathEqualTo((String)"/my/url")).build();
        MatchResult matchResult = requestPattern.match((Request)MockRequest.mockRequest().method(RequestMethod.PUT).url("/my/url"));
        MatcherAssert.assertThat((Object)matchResult.getDistance(), (Matcher)Matchers.is((Object)0.0));
        Assertions.assertTrue((boolean)matchResult.isExactMatch());
    }

    @Test
    public void returnsNon0DistanceWhenUrlDoesNotMatch() {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.PUT, (UrlPattern)WireMock.urlPathEqualTo((String)"/my/url")).withUrl("/my/url").build();
        MatchResult matchResult = requestPattern.match((Request)MockRequest.mockRequest().url("/totally/other/url"));
        MatcherAssert.assertThat((Object)matchResult.getDistance(), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(0.0)));
        Assertions.assertFalse((boolean)matchResult.isExactMatch());
    }

    @Test
    public void matchesExactlyWith0DistanceWhenAllRequiredHeadersMatch() {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.PUT, (UrlPattern)WireMock.urlPathEqualTo((String)"/my/url")).withHeader("My-Header", WireMock.equalTo((String)"my-expected-header-val")).build();
        MatchResult matchResult = requestPattern.match((Request)MockRequest.mockRequest().method(RequestMethod.PUT).header("My-Header", "my-expected-header-val").url("/my/url"));
        MatcherAssert.assertThat((Object)matchResult.getDistance(), (Matcher)Matchers.is((Object)0.0));
        Assertions.assertTrue((boolean)matchResult.isExactMatch());
    }

    @Test
    public void doesNotMatchWhenHeaderDoesNotMatch() {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.GET, (UrlPattern)WireMock.urlPathEqualTo((String)"/my/url")).withHeader("My-Header", WireMock.equalTo((String)"my-expected-header-val")).withHeader("My-Other-Header", WireMock.equalTo((String)"my-other-expected-header-val")).build();
        MatchResult matchResult = requestPattern.match((Request)MockRequest.mockRequest().method(RequestMethod.GET).header("My-Header", "my-expected-header-val").header("My-Other-Header", "wrong").url("/my/url"));
        Assertions.assertFalse((boolean)matchResult.isExactMatch());
    }

    @Test
    public void matchesExactlyWhenRequiredAbsentHeaderIsAbsent() {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.GET, (UrlPattern)WireMock.urlPathEqualTo((String)"/my/url")).withHeader("My-Header", WireMock.absent()).withHeader("My-Other-Header", WireMock.equalTo((String)"my-other-expected-header-val")).build();
        MatchResult matchResult = requestPattern.match((Request)MockRequest.mockRequest().method(RequestMethod.GET).header("My-Other-Header", "my-other-expected-header-val").url("/my/url"));
        Assertions.assertTrue((boolean)matchResult.isExactMatch());
    }

    @Test
    public void doesNotMatchWhenRequiredAbsentHeaderIsPresent() {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.GET, (UrlPattern)WireMock.urlPathEqualTo((String)"/my/url")).withHeader("My-Header", WireMock.absent()).withHeader("My-Other-Header", WireMock.equalTo((String)"my-other-expected-header-val")).build();
        MatchResult matchResult = requestPattern.match((Request)MockRequest.mockRequest().method(RequestMethod.GET).header("My-Header", "my-expected-header-val").header("My-Other-Header", "wrong").url("/my/url"));
        Assertions.assertFalse((boolean)matchResult.isExactMatch());
    }

    @Test
    public void bindsToJsonCompatibleWithOriginalRequestPatternForUrl() throws Exception {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.GET, (UrlPattern)WireMock.urlEqualTo((String)"/my/url")).build();
        String actualJson = Json.write((Object)requestPattern);
        JSONAssert.assertEquals((String)"{\t\t\t\t\t\t\t\t\t                \n\t\t\"method\": \"GET\",\t\t\t\t\t\t\n\t\t\"url\": \"/my/url\"                \t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t    ", (String)actualJson, (boolean)true);
    }

    @Test
    public void bindsToJsonCompatibleWithOriginalRequestPatternForUrlPattern() throws Exception {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.GET, (UrlPattern)WireMock.urlMatching((String)"/my/url")).build();
        String actualJson = Json.write((Object)requestPattern);
        JSONAssert.assertEquals((String)"{\t\t\t\t\t\t\t\t\t                \n\t\t\"method\": \"GET\",\t\t\t\t\t\t\n\t\t\"urlPattern\": \"/my/url\"           \t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t    ", (String)actualJson, (boolean)true);
    }

    @Test
    public void bindsToJsonCompatibleWithOriginalRequestPatternForUrlPathPattern() throws Exception {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.GET, (UrlPattern)WireMock.urlPathMatching((String)"/my/url")).build();
        String actualJson = Json.write((Object)requestPattern);
        JSONAssert.assertEquals((String)"{\t\t\t\t\t\t\t\t\t                \n\t\t\"method\": \"GET\",\t\t\t\t\t\t\n\t\t\"urlPathPattern\": \"/my/url\"             \n}\t\t\t\t\t\t\t\t\t\t\t\t    ", (String)actualJson, (boolean)true);
    }

    @Test
    public void bindsToJsonCompatibleWithOriginalRequestPatternForUrlPathAndHeaders() throws Exception {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.GET, (UrlPattern)WireMock.urlPathEqualTo((String)"/my/url")).withHeader("Accept", WireMock.matching((String)"(.*)xml(.*)")).withHeader("If-None-Match", WireMock.matching((String)"([a-z0-9]*)")).build();
        String actualJson = Json.write((Object)requestPattern);
        JSONAssert.assertEquals((String)URL_PATH_AND_HEADERS_EXAMPLE, (String)actualJson, (boolean)true);
    }

    @Test
    public void matchesExactlyWith0DistanceWhenAllRequiredQueryParametersMatch() {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.PUT, (UrlPattern)WireMock.urlPathEqualTo((String)"/my/url")).withQueryParam("param1", WireMock.equalTo((String)"1")).withQueryParam("param2", WireMock.equalTo((String)"2")).build();
        MatchResult matchResult = requestPattern.match((Request)MockRequest.mockRequest().method(RequestMethod.PUT).url("/my/url?param1=1&param1=555&param2=2"));
        MatcherAssert.assertThat((Object)matchResult.getDistance(), (Matcher)Matchers.is((Object)0.0));
        Assertions.assertTrue((boolean)matchResult.isExactMatch());
    }

    @Test
    public void returnsNon0DistanceWhenRequiredQueryParameterMatchDoesNotMatch() {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.PUT, (UrlPattern)WireMock.urlPathEqualTo((String)"/my/url")).withQueryParam("param1", WireMock.equalTo((String)"1")).withQueryParam("param2", WireMock.equalTo((String)"2")).build();
        MatchResult matchResult = requestPattern.match((Request)MockRequest.mockRequest().method(RequestMethod.PUT).url("/my/url?param1=555&param2=2"));
        MatcherAssert.assertThat((Object)matchResult.getDistance(), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(0.0)));
        Assertions.assertFalse((boolean)matchResult.isExactMatch());
    }

    @Test
    public void bindsToJsonCompatibleWithOriginalRequestPatternWithQueryParams() throws Exception {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.GET, (UrlPattern)WireMock.urlPathEqualTo((String)"/my/url")).withQueryParam("param1", WireMock.equalTo((String)"1")).withQueryParam("param2", WireMock.matching((String)"2")).build();
        String actualJson = Json.write((Object)requestPattern);
        JSONAssert.assertEquals((String)"{                              \n    \"method\": \"GET\",       \n    \"urlPath\": \"/my/url\",  \n    \"queryParameters\": {     \n        \"param1\": {          \n            \"equalTo\": \"1\" \n        },                     \n        \"param2\": {          \n            \"matches\": \"2\" \n        }                      \n    }                          \n}", (String)actualJson, (boolean)true);
    }

    @Test
    public void matchesExactlyWith0DistanceWhenAllRequiredFormParametersMatch() {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.PUT, (UrlPattern)WireMock.urlPathEqualTo((String)"/my/url")).withFormParam("key1", WireMock.equalTo((String)"value1")).withFormParam("key2", WireMock.equalTo((String)"value2")).build();
        HashMap<String, FormParameter> formParameters = new HashMap<String, FormParameter>();
        formParameters.put("key1", new FormParameter("key1", List.of("value1")));
        formParameters.put("key2", new FormParameter("key1", List.of("value2")));
        MatchResult matchResult = requestPattern.match((Request)MockRequest.mockRequest().method(RequestMethod.PUT).url("/my/url").formParameters(formParameters));
        MatcherAssert.assertThat((Object)matchResult.getDistance(), (Matcher)Matchers.is((Object)0.0));
        Assertions.assertTrue((boolean)matchResult.isExactMatch());
    }

    @Test
    public void returnsNon0DistanceWhenRequiredFormParameterMatchDoesNotMatch() {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.PUT, (UrlPattern)WireMock.urlPathEqualTo((String)"/my/url")).withFormParam("key1", WireMock.equalTo((String)"value1")).withFormParam("key2", WireMock.equalTo((String)"value2")).build();
        HashMap<String, FormParameter> formParameters = new HashMap<String, FormParameter>();
        formParameters.put("key1", new FormParameter("key1", List.of("value555")));
        formParameters.put("key2", new FormParameter("key1", List.of("value78")));
        MatchResult matchResult = requestPattern.match((Request)MockRequest.mockRequest().method(RequestMethod.PUT).url("/my/url").formParameters(formParameters));
        MatcherAssert.assertThat((Object)matchResult.getDistance(), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(0.0)));
        Assertions.assertFalse((boolean)matchResult.isExactMatch());
    }

    @Test
    public void bindsToJsonCompatibleWithOriginalRequestPatternWithFormParams() throws Exception {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.POST, (UrlPattern)WireMock.urlPathEqualTo((String)"/my/url")).withFormParam("key1", WireMock.equalTo((String)"value1")).withFormParam("key2", WireMock.matching((String)"value2")).build();
        String actualJson = Json.write((Object)requestPattern);
        JSONAssert.assertEquals((String)this.getFormParameterRequestPatternJson(), (String)actualJson, (boolean)true);
    }

    @Test
    public void correctlyDeserializesFormParams() {
        RequestPattern requestPattern = (RequestPattern)Json.read((String)this.getFormParameterRequestPatternJson(), RequestPattern.class);
        Assertions.assertTrue((boolean)(requestPattern.getFormParameters().get("key1") instanceof SingleMatchMultiValuePattern));
        Assertions.assertTrue((boolean)(requestPattern.getFormParameters().get("key2") instanceof SingleMatchMultiValuePattern));
        MatcherAssert.assertThat((Object)((SingleMatchMultiValuePattern)requestPattern.getFormParameters().get("key1")).getValuePattern(), RequestPatternTest.valuePattern(EqualToPattern.class, "value1"));
        MatcherAssert.assertThat((Object)((SingleMatchMultiValuePattern)requestPattern.getFormParameters().get("key2")).getValuePattern(), RequestPatternTest.valuePattern(RegexPattern.class, "value2"));
    }

    private String getFormParameterRequestPatternJson() {
        return "{                              \n    \"method\": \"POST\",       \n    \"urlPath\": \"/my/url\",  \n    \"formParameters\": {     \n        \"key1\": {          \n            \"equalTo\": \"value1\" \n        },                     \n        \"key2\": {          \n            \"matches\": \"value2\" \n        }                      \n    }                          \n}";
    }

    @Test
    public void matchesExactlyWith0DistanceWhenBodyPatternsAllMatch() {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.PUT, (UrlPattern)WireMock.urlPathEqualTo((String)"/my/url")).withRequestBody((ContentPattern)WireMock.equalTo((String)"exactwordone approxwordtwo blah blah")).withRequestBody((ContentPattern)WireMock.containing((String)"two")).build();
        MatchResult matchResult = requestPattern.match((Request)MockRequest.mockRequest().method(RequestMethod.PUT).url("/my/url").body("exactwordone approxwordtwo blah blah"));
        MatcherAssert.assertThat((Object)matchResult.getDistance(), (Matcher)Matchers.is((Object)0.0));
        Assertions.assertTrue((boolean)matchResult.isExactMatch());
    }

    @Test
    public void doesNotMatchExactlyWhenOneBodyPatternDoesNotMatch() {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.PUT, (UrlPattern)WireMock.urlPathEqualTo((String)"/my/url")).withRequestBody((ContentPattern)WireMock.equalTo((String)"exactwordone approxwordtwo blah blah")).withRequestBody((ContentPattern)WireMock.containing((String)"three")).build();
        MatchResult matchResult = requestPattern.match((Request)MockRequest.mockRequest().method(RequestMethod.PUT).url("/my/url").body("exactwordone approxwordtwo blah blah"));
        Assertions.assertFalse((boolean)matchResult.isExactMatch());
    }

    @Test
    public void matchesExactlyWith0DistanceWhenMultipartPatternsAllMatch() {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.POST, (UrlPattern)WireMock.urlPathEqualTo((String)"/my/url")).withAnyRequestBodyPart(WireMock.aMultipart().withName("part-1").withHeader("Content-Type", WireMock.containing((String)"text/plain")).withBody((ContentPattern)WireMock.equalTo((String)"body part value"))).withAnyRequestBodyPart(WireMock.aMultipart().withName("part-2").withHeader("Content-Type", WireMock.containing((String)"application/octet-stream")).withBody((ContentPattern)WireMock.containing((String)"other body"))).build();
        MatchResult matchResult = requestPattern.match((Request)MockRequest.mockRequest().method(RequestMethod.POST).url("/my/url").header("Content-Type", "multipart/form-data; boundary=BOUNDARY").multipartBody("--BOUNDARY\r\nContent-Disposition: form-data; name=\"part-1\"; filename=\"\"\r\nContent-Type: text/plain\r\n\r\nbody part value\r\n--BOUNDARY\r\nContent-Disposition: form-data; name=\"part-2\"; filename=\"\"\r\nContent-Type: application/octet-stream\r\nContent-Transfer-Encoding: base64\r\n\r\nc29tZSBvdGhlciBib2R5IHZhbHVl\r\n--BOUNDARY--"));
        MatcherAssert.assertThat((Object)matchResult.getDistance(), (Matcher)Matchers.is((Object)0.0));
        Assertions.assertTrue((boolean)matchResult.isExactMatch());
    }

    @Test
    public void doesNotMatchExactlyWhenOneMultipartBodyPatternDoesNotMatch() {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.PUT, (UrlPattern)WireMock.urlPathEqualTo((String)"/my/url")).withAnyRequestBodyPart(WireMock.aMultipart().withName("part-2").withBody((ContentPattern)WireMock.containing((String)"non existing part"))).build();
        MatchResult matchResult = requestPattern.match((Request)MockRequest.mockRequest().method(RequestMethod.PUT).url("/my/url").header("Content-Type", "multipart/form-data; boundary=BOUNDARY").multipartBody("--BOUNDARY\r\nContent-Disposition: form-data; name=\"part-2\"; filename=\"\"\r\nContent-Type: application/octet-stream\r\nContent-Transfer-Encoding: base64\r\n\r\nc29tZSBvdGhlciBib2R5IHZhbHVl\r\n--BOUNDARY--"));
        Assertions.assertFalse((boolean)matchResult.isExactMatch());
    }

    @Test
    public void doesNotMatchExactlyWhenOneMultipartHeaderPatternDoesNotMatch() {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.PUT, (UrlPattern)WireMock.urlPathEqualTo((String)"/my/url")).withAnyRequestBodyPart(WireMock.aMultipart().withName("part-1").withHeader("Content-Type", WireMock.containing((String)"application/json"))).build();
        MatchResult matchResult = requestPattern.match((Request)MockRequest.mockRequest().method(RequestMethod.PUT).url("/my/url").header("Content-Type", "multipart/form-data; boundary=BOUNDARY").multipartBody("--BOUNDARY\r\nContent-Disposition: form-data; name=\"part-1\"; filename=\"\"\r\nContent-Type: application/octet-stream\r\nContent-Transfer-Encoding: base64\r\n\r\nc29tZSBvdGhlciBib2R5IHZhbHVl\r\n--BOUNDARY--"));
        Assertions.assertFalse((boolean)matchResult.isExactMatch());
    }

    @Test
    public void matchesExactlyWith0DistanceWhenAllMultipartPatternsMatchAllParts() {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.POST, (UrlPattern)WireMock.urlPathEqualTo((String)"/my/url")).withAllRequestBodyParts(WireMock.aMultipart().withHeader("Content-Type", WireMock.containing((String)"text/plain")).withBody((ContentPattern)WireMock.containing((String)"body value"))).build();
        MatchResult matchResult = requestPattern.match((Request)MockRequest.mockRequest().method(RequestMethod.POST).url("/my/url").header("Content-Type", "multipart/form-data; boundary=BOUNDARY").multipartBody("--BOUNDARY\r\nContent-Disposition: form-data; name=\"part-1\"; filename=\"\"\r\nContent-Type: text/plain\r\n\r\nbody value-1\r\n--BOUNDARY\r\nContent-Disposition: form-data; name=\"part-2\"; filename=\"\"\r\nContent-Type: text/plain\r\nContent-Transfer-Encoding: base64\r\n\r\nc29tZSBvdGhlciBib2R5IHZhbHVl\r\n--BOUNDARY--"));
        MatcherAssert.assertThat((Object)matchResult.getDistance(), (Matcher)Matchers.is((Object)0.0));
        Assertions.assertTrue((boolean)matchResult.isExactMatch());
    }

    @Test
    public void matchesExactlyWhenAllCookiesMatch() {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.POST, (UrlPattern)WireMock.urlPathEqualTo((String)"/my/url")).withCookie("my_cookie", WireMock.equalTo((String)"my-cookie-value")).build();
        MatchResult matchResult = requestPattern.match((Request)MockRequest.mockRequest().method(RequestMethod.POST).cookie("my_cookie", "my-cookie-value").url("/my/url"));
        MatcherAssert.assertThat((Object)matchResult.getDistance(), (Matcher)Matchers.is((Object)0.0));
        Assertions.assertTrue((boolean)matchResult.isExactMatch());
    }

    @Test
    public void doesNotMatchWhenARequiredCookieIsMissing() {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.POST, (UrlPattern)WireMock.urlPathEqualTo((String)"/my/url")).withCookie("my_cookie", WireMock.equalTo((String)"my-cookie-value")).build();
        MatchResult matchResult = requestPattern.match((Request)MockRequest.mockRequest().method(RequestMethod.POST).url("/my/url"));
        Assertions.assertFalse((boolean)matchResult.isExactMatch());
    }

    @Test
    public void doesNotMatchWhenRequiredCookieValueIsWrong() {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.POST, (UrlPattern)WireMock.urlPathEqualTo((String)"/my/url")).withCookie("my_cookie", WireMock.equalTo((String)"my-cookie-value")).build();
        MatchResult matchResult = requestPattern.match((Request)MockRequest.mockRequest().method(RequestMethod.POST).cookie("my_cookie", "wrong-value").url("/my/url"));
        Assertions.assertFalse((boolean)matchResult.isExactMatch());
    }

    @Test
    public void doesNotMatchWhenRequiredAbsentCookieIsPresent() {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.POST, (UrlPattern)WireMock.urlPathEqualTo((String)"/my/url")).withCookie("my_cookie", WireMock.absent()).build();
        MatchResult matchResult = requestPattern.match((Request)MockRequest.mockRequest().method(RequestMethod.POST).cookie("my_cookie", "any-value").url("/my/url"));
        Assertions.assertFalse((boolean)matchResult.isExactMatch());
    }

    @Test
    public void correctlyDeserialisesBodyPatterns() {
        RequestPattern pattern = (RequestPattern)Json.read((String)ALL_BODY_PATTERNS_EXAMPLE, RequestPattern.class);
        MatcherAssert.assertThat((Object)pattern.getBodyPatterns(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{RequestPatternTest.valuePattern(EqualToPattern.class, "thing"), RequestPatternTest.valuePattern(EqualToJsonPattern.class, "{ \"thing\": 1 }"), RequestPatternTest.valuePattern(MatchesJsonPathPattern.class, "@.*"), RequestPatternTest.valuePattern(EqualToXmlPattern.class, "<thing />"), RequestPatternTest.valuePattern(MatchesXPathPattern.class, "//thing"), RequestPatternTest.valuePattern(ContainsPattern.class, "thin"), RequestPatternTest.valuePattern(NegativeContainsPattern.class, "stuff"), RequestPatternTest.valuePattern(NotPattern.class, (String)WireMock.containing((String)"thing").expectedValue), RequestPatternTest.valuePattern(RegexPattern.class, ".*thing.*"), RequestPatternTest.valuePattern(NegativeRegexPattern.class, "^stuff.+")}));
    }

    @Test
    public void correctlySerialisesBodyPatterns() throws Exception {
        RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.PUT, (UrlPattern)WireMock.urlEqualTo((String)"/all/body/patterns")).withRequestBody((ContentPattern)WireMock.equalTo((String)"thing")).withRequestBody((ContentPattern)WireMock.equalToJson((String)"{ \"thing\": 1 }")).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"@.*")).withRequestBody((ContentPattern)WireMock.equalToXml((String)"<thing />")).withRequestBody((ContentPattern)WireMock.matchingXPath((String)"//thing")).withRequestBody((ContentPattern)WireMock.containing((String)"thin")).withRequestBody((ContentPattern)WireMock.notContaining((String)"stuff")).withRequestBody((ContentPattern)WireMock.not((StringValuePattern)WireMock.containing((String)"thing"))).withRequestBody((ContentPattern)WireMock.matching((String)".*thing.*")).withRequestBody((ContentPattern)WireMock.notMatching((String)"^stuff.+")).build();
        String json = Json.write((Object)requestPattern);
        JSONAssert.assertEquals((String)ALL_BODY_PATTERNS_EXAMPLE, (String)json, (boolean)true);
    }

    static Matcher<ContentPattern<?>> valuePattern(final Class<? extends StringValuePattern> patternClass, final String expectedValue) {
        return new TypeSafeDiagnosingMatcher<ContentPattern<?>>(){

            protected boolean matchesSafely(ContentPattern<?> item, Description mismatchDescription) {
                return item.getClass().equals(patternClass) && item.getValue().equals(expectedValue);
            }

            public void describeTo(Description description) {
                description.appendText("a value pattern of type " + patternClass.getSimpleName() + " with expected value " + expectedValue);
            }
        };
    }

    static Matcher<ContentPattern<?>> notValuePattern(final Class<? extends StringValuePattern> patternClass, final StringValuePattern unexpectedPattern) {
        return new TypeSafeDiagnosingMatcher<ContentPattern<?>>(){

            protected boolean matchesSafely(ContentPattern<?> item, Description mismatchDescription) {
                return item.getClass().equals(patternClass) && item.getValue().equals(unexpectedPattern.expectedValue);
            }

            public void describeTo(Description description) {
                description.appendText("a value pattern of type " + patternClass.getSimpleName() + " with expected value " + (String)unexpectedPattern.expectedValue);
            }
        };
    }
}

