/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.BasicCredentials;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.CustomMatcherDefinition;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.MultipartValuePattern;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.ValueMatcher;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Test;

public class RequestPatternBuilderTest {
    @Test
    public void likeRequestPatternWithDifferentUrl() {
        RequestPattern requestPattern = RequestPattern.everything();
        RequestPattern newRequestPattern = RequestPatternBuilder.like((RequestPattern)requestPattern).but().withUrl("/foo").build();
        MatcherAssert.assertThat((Object)newRequestPattern.getUrl(), (Matcher)Is.is((Object)"/foo"));
        MatcherAssert.assertThat((Object)newRequestPattern, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)requestPattern)));
    }

    @Test
    public void likeRequestPatternWithoutCustomMatcher() {
        RequestPattern requestPattern = new RequestPattern("https", WireMock.equalTo((String)"my.wiremock.org"), Integer.valueOf(1234), WireMock.urlEqualTo((String)"/foo"), RequestMethod.POST, Map.of("X-Header", MultiValuePattern.of((StringValuePattern)WireMock.equalTo((String)"bar"))), Collections.emptyMap(), Map.of("query_param", MultiValuePattern.of((StringValuePattern)WireMock.equalTo((String)"bar"))), Map.of("form_param", MultiValuePattern.of((StringValuePattern)WireMock.equalTo((String)"bar"))), Map.of("cookie", WireMock.equalTo((String)"yum")), new BasicCredentials("user", "pass"), List.of(WireMock.equalTo((String)"BODY")), null, null, null);
        RequestPattern newRequestPattern = RequestPatternBuilder.like((RequestPattern)requestPattern).build();
        MatcherAssert.assertThat((Object)newRequestPattern, (Matcher)Is.is((Object)requestPattern));
    }

    @Test
    public void likeRequestPatternWithCustomMatcher() {
        RequestMatcherExtension customRequestMatcher = new RequestMatcherExtension(){

            public MatchResult match(Request request, Parameters parameters) {
                return MatchResult.noMatch((SubEvent[])new SubEvent[0]);
            }
        };
        RequestPattern requestPattern = new RequestPattern((ValueMatcher)customRequestMatcher);
        RequestPattern newRequestPattern = RequestPatternBuilder.like((RequestPattern)requestPattern).build();
        MatcherAssert.assertThat((Object)newRequestPattern, (Matcher)Is.is((Object)requestPattern));
    }

    @Test
    public void likeRequestPatternWithMultipartMatcher() {
        MultipartValuePattern multipartValuePattern = WireMock.aMultipart().withBody((ContentPattern)WireMock.equalToJson((String)"[]")).build();
        RequestPattern requestPattern = RequestPattern.everything();
        RequestPattern newRequestPattern = RequestPatternBuilder.like((RequestPattern)requestPattern).but().withRequestBodyPart(multipartValuePattern).build();
        MatcherAssert.assertThat((Object)newRequestPattern.getMultipartPatterns(), (Matcher)Matchers.everyItem((Matcher)Is.is((Matcher)Matchers.in(Collections.singletonList(multipartValuePattern)))));
        MatcherAssert.assertThat((Object)newRequestPattern, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)requestPattern)));
    }

    @Test
    public void likeRequestPatternWithoutMultipartMatcher() {
        MultipartValuePattern multipartPattern = WireMock.aMultipart().withBody((ContentPattern)WireMock.equalToJson((String)"[]")).build();
        RequestPattern requestPattern = new RequestPattern("https", WireMock.equalTo((String)"my.wiremock.org"), Integer.valueOf(1234), WireMock.urlEqualTo((String)"/foo"), RequestMethod.POST, Map.of("X-Header", MultiValuePattern.of((StringValuePattern)WireMock.equalTo((String)"bar"))), Collections.emptyMap(), Map.of("query_param", MultiValuePattern.of((StringValuePattern)WireMock.equalTo((String)"bar"))), Map.of("form_param", MultiValuePattern.of((StringValuePattern)WireMock.equalTo((String)"bar"))), Map.of("cookie", WireMock.equalTo((String)"yum")), new BasicCredentials("user", "pass"), List.of(WireMock.equalTo((String)"BODY")), null, null, Arrays.asList(multipartPattern));
        RequestPattern newRequestPattern = RequestPatternBuilder.like((RequestPattern)requestPattern).build();
        MatcherAssert.assertThat((Object)newRequestPattern, (Matcher)Is.is((Object)requestPattern));
    }

    @Test
    public void likeRequestPatternWithCustomMatcherDefinition() {
        CustomMatcherDefinition customMatcherDefinition = new CustomMatcherDefinition("foo", Parameters.empty());
        RequestPattern requestPattern = new RequestPattern(customMatcherDefinition);
        RequestPattern newRequestPattern = RequestPatternBuilder.like((RequestPattern)requestPattern).build();
        MatcherAssert.assertThat((Object)newRequestPattern, (Matcher)Is.is((Object)requestPattern));
    }
}

