/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class NotPatternTest {
    NotPatternTest() {
    }

    @Test
    void shouldReturnExactMatchWhenValueIsNull() {
        MatchResult matchResult = WireMock.not((StringValuePattern)WireMock.containing((String)"thing")).match(null);
        boolean result = matchResult.isExactMatch();
        Assertions.assertTrue((boolean)result);
    }

    @Test
    void shouldReturnNoMatchWhenValueIsContainedInTestValue() {
        MatchResult matchResult = WireMock.not((StringValuePattern)WireMock.containing((String)"thing")).match((Object)"otherthings");
        boolean result = matchResult.isExactMatch();
        double distance = matchResult.getDistance();
        Assertions.assertFalse((boolean)result);
        MatcherAssert.assertThat((Object)distance, (Matcher)Matchers.is((Object)1.0));
    }

    @Test
    void shouldReturnExactMatchWhenValueIsNotContainedInTestValue() {
        MatchResult matchResult = WireMock.not((StringValuePattern)WireMock.containing((String)"thing")).match((Object)"otherstuff");
        boolean result = matchResult.isExactMatch();
        Assertions.assertTrue((boolean)result);
    }
}

