/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.NegativeContainsPattern;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NegativeContainsPatternTest {
    @Test
    public void returnsExactMatchWhenExpectedValueNotContainedInTestValue() {
        Assertions.assertTrue((boolean)WireMock.notContaining((String)"thing").match((Object)"otherstuff").isExactMatch());
    }

    @Test
    public void returnsExactMatchWhenTestValueIsNull() {
        Assertions.assertTrue((boolean)WireMock.notContaining((String)"thing").match(null).isExactMatch());
    }

    @Test
    public void returnsNoMatchWhenWhenExpectedValueWhollyContainedInTestValue() {
        MatchResult matchResult = WireMock.notContaining((String)"thing").match((Object)"mythings");
        Assertions.assertFalse((boolean)matchResult.isExactMatch());
        MatcherAssert.assertThat((Object)matchResult.getDistance(), (Matcher)Matchers.is((Object)1.0));
    }

    @Test
    public void objectsShouldBeEqualOnSameExpectedValue() {
        NegativeContainsPattern a = new NegativeContainsPattern("doNotContain");
        NegativeContainsPattern b = new NegativeContainsPattern("doNotContain");
        NegativeContainsPattern c = new NegativeContainsPattern("somethingElse");
        Assertions.assertEquals((Object)a, (Object)b);
        Assertions.assertEquals((int)a.hashCode(), (int)b.hashCode());
        Assertions.assertEquals((Object)b, (Object)a);
        Assertions.assertEquals((int)b.hashCode(), (int)a.hashCode());
        Assertions.assertNotEquals((Object)a, (Object)c);
        Assertions.assertNotEquals((int)a.hashCode(), (int)c.hashCode());
        Assertions.assertNotEquals((Object)b, (Object)c);
        Assertions.assertNotEquals((int)b.hashCode(), (int)c.hashCode());
    }
}

