/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.common.ParameterUtils;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.common.url.PathParams;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.FormParameter;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.jetty11.MultipartParser;
import com.github.tomakehurst.wiremock.matching.MockMultipart;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class MockRequest
implements Request {
    private String scheme = "http";
    private String host = "my.domain";
    private int port = 80;
    private String url = "/";
    private String absoluteUrl = null;
    private RequestMethod method = RequestMethod.ANY;
    private HttpHeaders headers = new HttpHeaders();
    private final Map<String, Cookie> cookies = new HashMap<String, Cookie>();
    private final PathParams pathParams = new PathParams();
    private byte[] body;
    private String clientIp = "1.1.1.1";
    private Collection<Request.Part> multiparts = null;
    private Map<String, FormParameter> formParameters = new HashMap<String, FormParameter>();
    private boolean isBrowserProxyRequest = false;
    private String protocol = "HTTP/1.1";

    public static MockRequest mockRequest() {
        return new MockRequest();
    }

    public MockRequest scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public MockRequest host(String host) {
        this.host = host;
        return this;
    }

    public MockRequest port(int port) {
        this.port = port;
        return this;
    }

    public MockRequest url(String url) {
        this.url = url;
        return this;
    }

    public MockRequest absoluteUrl(String absoluteUrl) {
        this.absoluteUrl = absoluteUrl;
        return this;
    }

    public MockRequest method(RequestMethod method) {
        this.method = method;
        return this;
    }

    public MockRequest header(String key, String ... values) {
        this.headers = this.headers.plus(new HttpHeader[]{HttpHeader.httpHeader((String)key, (String[])values)});
        return this;
    }

    public MockRequest headers(HttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    public MockRequest cookie(String key, String ... values) {
        this.cookies.put(key, new Cookie(Arrays.asList(values)));
        return this;
    }

    public MockRequest body(String body) {
        this.body = body.getBytes(StandardCharsets.UTF_8);
        return this;
    }

    public MockRequest body(byte[] body) {
        this.body = body;
        return this;
    }

    public MockRequest clientIp(String clientIp) {
        this.clientIp = clientIp;
        return this;
    }

    public MockRequest parts(Collection<Request.Part> multiparts) {
        this.multiparts = multiparts;
        return this;
    }

    public MockRequest part(MockMultipart part) {
        if (this.multiparts == null) {
            this.multiparts = new ArrayList<Request.Part>();
        }
        this.multiparts.add(part);
        return this;
    }

    public MockRequest formParameters(Map<String, FormParameter> formParameters) {
        if (formParameters != null) {
            this.formParameters = formParameters;
        }
        return this;
    }

    public MockRequest isBrowserProxyRequest(boolean isBrowserProxyRequest) {
        this.isBrowserProxyRequest = isBrowserProxyRequest;
        return this;
    }

    public MockRequest protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public String getAbsoluteUrl() {
        String portPart = this.port == 80 || this.port == 443 ? "" : ":" + this.port;
        return (String)ParameterUtils.getFirstNonNull((Object)this.absoluteUrl, (Object)String.format("%s://%s%s%s", this.scheme, this.host, portPart, this.url));
    }

    public RequestMethod getMethod() {
        return this.method;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public String getHeader(String key) {
        return this.header(key).firstValue();
    }

    public HttpHeader header(String key) {
        return this.headers.all().stream().filter(input -> input.keyEquals(key)).findFirst().orElseGet(() -> HttpHeader.absent((String)key));
    }

    public ContentTypeHeader contentTypeHeader() {
        return ContentTypeHeader.absent();
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public boolean containsHeader(String key) {
        return this.headers.getHeader(key).isPresent();
    }

    public Set<String> getAllHeaderKeys() {
        return this.getHeaders().keys();
    }

    public Map<String, Cookie> getCookies() {
        return this.cookies;
    }

    public QueryParameter queryParameter(String key) {
        Map queryParams = Urls.splitQuery((URI)URI.create(this.url));
        return (QueryParameter)queryParams.get(key);
    }

    public FormParameter formParameter(String key) {
        return (FormParameter)ParameterUtils.getFirstNonNull((Object)this.formParameters.get(key), (Object)FormParameter.absent((String)key));
    }

    public Map<String, FormParameter> formParameters() {
        return this.formParameters;
    }

    public byte[] getBody() {
        return this.body;
    }

    public String getBodyAsString() {
        return this.body != null ? new String(this.body) : null;
    }

    public String getBodyAsBase64() {
        return "";
    }

    public boolean isBrowserProxyRequest() {
        return this.isBrowserProxyRequest;
    }

    public Optional<Request> getOriginalRequest() {
        return Optional.empty();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public LoggedRequest asLoggedRequest() {
        return LoggedRequest.createFrom((Request)this);
    }

    public boolean isMultipart() {
        return this.getParts() != null;
    }

    public Collection<Request.Part> getParts() {
        return this.multiparts;
    }

    public Request.Part getPart(String name) {
        return this.getParts() != null && name != null ? (Request.Part)this.multiparts.stream().filter(input -> name.equals(input.getName())).findFirst().orElse(null) : null;
    }

    public MockRequest multipartBody(String body) {
        ContentTypeHeader contentTypeHeader = this.headers.getContentTypeHeader();
        String contentType = contentTypeHeader.isPresent() ? contentTypeHeader.firstValue() : "multipart/form-data; boundary=BOUNDARY";
        this.multiparts = MultipartParser.parse(Strings.bytesFromString((String)body), contentType);
        return this;
    }
}

