/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.MatchesJsonSchemaPattern;
import com.github.tomakehurst.wiremock.testsupport.TestFiles;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.javacrumbs.jsonunit.JsonMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class MatchesJsonSchemaPatternTest {
    @Test
    void distanceIsProportionateToNumberOfValidationErrors() {
        String schema = TestFiles.file("schema-validation/shop-order.schema.json");
        MatchesJsonSchemaPattern pattern = new MatchesJsonSchemaPattern(schema);
        MatchResult veryBadMatchResult = pattern.match("{}");
        MatcherAssert.assertThat((Object)veryBadMatchResult.isExactMatch(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)veryBadMatchResult.getDistance(), (Matcher)Matchers.closeTo((double)0.66, (double)0.01));
        MatchResult lessBadMatchResult = pattern.match(TestFiles.file("schema-validation/shop-order.slightly-wrong.json"));
        MatcherAssert.assertThat((Object)lessBadMatchResult.isExactMatch(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)lessBadMatchResult.getDistance(), (Matcher)Matchers.closeTo((double)0.33, (double)0.01));
    }

    private static List<String> invalidContent() {
        return Arrays.asList(null, "", "not json", "{");
    }

    @ParameterizedTest
    @MethodSource(value={"invalidContent"})
    void invalidContentGivesNoMatch(String content) {
        String schema = TestFiles.file("schema-validation/shop-order.schema.json");
        MatchesJsonSchemaPattern pattern = new MatchesJsonSchemaPattern(schema);
        MatchResult veryBadMatchResult = pattern.match(content);
        MatcherAssert.assertThat((Object)veryBadMatchResult.isExactMatch(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)veryBadMatchResult.getDistance(), (Matcher)Matchers.is((Object)1.0));
    }

    @Test
    void serialisesToJsonCorrectlyWithDefaultSchemaVersion() {
        String schema = TestFiles.file("schema-validation/shop-order.schema.json");
        MatchesJsonSchemaPattern pattern = new MatchesJsonSchemaPattern(schema);
        String json = Json.write((Object)pattern);
        String schemaString = (String)JsonPath.read((String)json, (String)"$.matchesJsonSchema", (Predicate[])new Predicate[0]);
        MatcherAssert.assertThat((Object)schemaString, (Matcher)JsonMatchers.jsonEquals((Object)schema));
    }

    @Test
    void serialisesToJsonCorrectlyWithProvidedSchemaVersion() {
        String schema = TestFiles.file("schema-validation/shop-order.schema.json");
        MatchesJsonSchemaPattern pattern = new MatchesJsonSchemaPattern(schema, WireMock.JsonSchemaVersion.V4);
        String json = Json.write((Object)pattern);
        String schemaString = (String)JsonPath.read((String)json, (String)"$.matchesJsonSchema", (Predicate[])new Predicate[0]);
        MatcherAssert.assertThat((Object)schemaString, (Matcher)JsonMatchers.jsonEquals((Object)schema));
    }

    @Test
    void deserialisesFromJsonCorrectlyWithDefaultSchemaVersion() {
        String schemaJson = "{\n    \"required\": [\n      \"itemCatalogueId\",\n      \"quantity\"\n    ],\n    \"properties\": {\n      \"itemCatalogueId\": {\n        \"type\": \"string\"\n      },\n      \"quantity\": {\n        \"type\": \"integer\"\n      },\n      \"fastDelivery\": {\n        \"type\": \"boolean\"\n      }\n    }\n  }";
        String matcherJson = "{\n  \"matchesJsonSchema\": " + MatchesJsonSchemaPatternTest.stringify(schemaJson) + "\n}";
        MatchesJsonSchemaPattern pattern = (MatchesJsonSchemaPattern)Json.read((String)matcherJson, MatchesJsonSchemaPattern.class);
        MatcherAssert.assertThat((Object)pattern.getMatchesJsonSchema(), (Matcher)JsonMatchers.jsonEquals((Object)schemaJson));
    }

    @Test
    void deserialisesFromJsonCorrectlyWithProvidedSchemaVersion() {
        String schemaJson = "{\n    \"properties\": {\n      \"itemCatalogueId\": {\n        \"type\": \"string\"\n      }\n    }\n  }";
        String matcherJson = "{\n  \"matchesJsonSchema\": " + MatchesJsonSchemaPatternTest.stringify(schemaJson) + ",\n  \"schemaVersion\": \"V6\"\n}";
        MatchesJsonSchemaPattern pattern = (MatchesJsonSchemaPattern)Json.read((String)matcherJson, MatchesJsonSchemaPattern.class);
        MatcherAssert.assertThat((Object)pattern.getSchemaVersion(), (Matcher)Matchers.is((Object)WireMock.JsonSchemaVersion.V6));
    }

    @ParameterizedTest
    @MethodSource(value={"simpleRefSchemaMatchingExamples"})
    void simpleRefMatches(String input) {
        String schema = TestFiles.file("schema-validation/has-ref.schema.json");
        MatchesJsonSchemaPattern pattern = new MatchesJsonSchemaPattern(schema, WireMock.JsonSchemaVersion.V4);
        MatchResult match = pattern.match(input);
        MatcherAssert.assertThat((Object)match.isExactMatch(), (Matcher)Matchers.is((Object)true));
    }

    private static Stream<Arguments> simpleRefSchemaMatchingExamples() {
        return Stream.of(Arguments.of((Object[])new Object[]{"{ \"things\": [] }"}), Arguments.of((Object[])new Object[]{"{ \"things\": [ 1 ] }"}), Arguments.of((Object[])new Object[]{"{ \"things\": [ 1, 2 ] }"}));
    }

    @ParameterizedTest
    @MethodSource(value={"simpleRefSchemaNonMatchingExamples"})
    void simpleRefRejectsNonMatches(String input) {
        String schema = TestFiles.file("schema-validation/has-ref.schema.json");
        MatchesJsonSchemaPattern pattern = new MatchesJsonSchemaPattern(schema, WireMock.JsonSchemaVersion.V4);
        MatchResult match = pattern.match(input);
        MatcherAssert.assertThat((Object)match.isExactMatch(), (Matcher)Matchers.is((Object)false));
    }

    private static Stream<Arguments> simpleRefSchemaNonMatchingExamples() {
        return Stream.of(Arguments.of((Object[])new Object[]{"{}"}), Arguments.of((Object[])new Object[]{"{ \"not_things\": null }"}), Arguments.of((Object[])new Object[]{"{ \"not_things\": [] }"}), Arguments.of((Object[])new Object[]{"{ \"things\": null }"}), Arguments.of((Object[])new Object[]{"{ \"things\": {} }"}), Arguments.of((Object[])new Object[]{"{ \"things\": 1 }"}), Arguments.of((Object[])new Object[]{"{ \"things\": [ \"1\" ] }"}));
    }

    @ParameterizedTest
    @Disabled
    @MethodSource(value={"recursiveSchemaMatchingExamples"})
    void recursiveRefExactMatchesCorrectlyMatched(String input) {
        String schema = TestFiles.file("schema-validation/recursive.schema.json");
        MatchesJsonSchemaPattern pattern = new MatchesJsonSchemaPattern(schema, WireMock.JsonSchemaVersion.V4);
        MatchResult match = pattern.match(input);
        MatcherAssert.assertThat((Object)match.isExactMatch(), (Matcher)Matchers.is((Object)true));
    }

    private static Stream<Arguments> recursiveSchemaMatchingExamples() {
        return Stream.of(Arguments.of((Object[])new Object[]{"{ \"name\": \"no_children\" }"}), Arguments.of((Object[])new Object[]{"{ \"name\": \"no_children\", \"children\": null }"}), Arguments.of((Object[])new Object[]{"{ \"name\": \"no_children\", \"children\": [] }"}), Arguments.of((Object[])new Object[]{"{ \"name\": \"no_grandchildren\", \"children\": [{ \"name\": \"no_children\", \"children\": [] }] }"}));
    }

    @ParameterizedTest
    @Disabled
    @MethodSource(value={"recursiveSchemaNonMatchingExamples"})
    void recursiveRefNonMatchesCorrectlyMatched(String input) {
        String schema = TestFiles.file("schema-validation/recursive.schema.json");
        MatchesJsonSchemaPattern pattern = new MatchesJsonSchemaPattern(schema, WireMock.JsonSchemaVersion.V4);
        MatchResult match = pattern.match(input);
        MatcherAssert.assertThat((Object)match.isExactMatch(), (Matcher)Matchers.is((Object)false));
    }

    private static Stream<Arguments> recursiveSchemaNonMatchingExamples() {
        return Stream.of(Arguments.of((Object[])new Object[]{"{}"}), Arguments.of((Object[])new Object[]{"{ \"not_a_name\": null }"}), Arguments.of((Object[])new Object[]{"{ \"name\": \"invalid_child\", \"children\": [{}] }"}), Arguments.of((Object[])new Object[]{"{ \"name\": \"invalid_grandchild\", \"children\": [{ \"name\": \"invalid_child\", \"children\": [{}] }] }"}));
    }

    private static String stringify(String json) {
        return "\"" + json.replace("\n", "").replace("\"", "\\\"") + "\"";
    }
}

