/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class MatchResultTest {
    @Test
    public void aggregatesLazily() {
        ExceptionThrowingMatchResult result1 = new ExceptionThrowingMatchResult();
        ExceptionThrowingMatchResult result2 = new ExceptionThrowingMatchResult();
        ExceptionThrowingMatchResult result3 = new ExceptionThrowingMatchResult();
        MatchResult.aggregate((MatchResult[])new MatchResult[]{result1, result2, result3});
    }

    @Test
    public void aggregatesDistanceCorrectly() {
        MatchResult matchResult = MatchResult.aggregate((MatchResult[])new MatchResult[]{MatchResult.partialMatch((double)0.5), MatchResult.partialMatch((double)0.6), MatchResult.partialMatch((double)0.7)});
        MatcherAssert.assertThat((Object)matchResult.getDistance(), (Matcher)Matchers.is((Object)0.6));
    }

    @Test
    public void aggregatesExactMatchCorrectly() {
        MatchResult matchResult = MatchResult.aggregate((MatchResult[])new MatchResult[]{MatchResult.exactMatch((SubEvent[])new SubEvent[0]), MatchResult.exactMatch((SubEvent[])new SubEvent[0]), MatchResult.exactMatch((SubEvent[])new SubEvent[0]), MatchResult.exactMatch((SubEvent[])new SubEvent[0])});
        MatcherAssert.assertThat((Object)matchResult.isExactMatch(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void aggregatesNonExactMatchCorrectly() {
        MatchResult matchResult = MatchResult.aggregate((MatchResult[])new MatchResult[]{MatchResult.exactMatch((SubEvent[])new SubEvent[0]), MatchResult.exactMatch((SubEvent[])new SubEvent[0]), MatchResult.partialMatch((double)0.99), MatchResult.exactMatch((SubEvent[])new SubEvent[0])});
        MatcherAssert.assertThat((Object)matchResult.isExactMatch(), (Matcher)Matchers.is((Object)false));
    }

    public static class ExceptionThrowingMatchResult
    extends MatchResult {
        public boolean isExactMatch() {
            return false;
        }

        public double getDistance() {
            throw new UnsupportedOperationException();
        }
    }
}

