/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ConsoleNotifier;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import com.github.tomakehurst.wiremock.matching.EqualToXmlPattern;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import java.util.Locale;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.xmlunit.diff.ComparisonType;

public class EqualToXmlPatternTest {
    @RegisterExtension
    public WireMockExtension wm = WireMockExtension.newInstance().build();

    @BeforeEach
    public void init() {
        LocalNotifier.set((Notifier)new ConsoleNotifier(true));
        Locale.setDefault(Locale.ENGLISH);
    }

    @AfterEach
    public void cleanup() {
        LocalNotifier.set(null);
    }

    @Test
    public void returnsNoMatchAnd1DistanceWhenActualIsNull() {
        EqualToXmlPattern pattern = new EqualToXmlPattern("<things>\n    <thing characteristic=\"tepid\"/>\n    <thing characteristic=\"tedious\"/>\n</things>");
        MatchResult matchResult = pattern.match(null);
        Assertions.assertFalse((boolean)matchResult.isExactMatch());
        MatcherAssert.assertThat((Object)matchResult.getDistance(), (Matcher)Matchers.is((Object)1.0));
    }

    @Test
    public void returnsNoMatchAnd1DistanceWhenActualIsEmpty() {
        EqualToXmlPattern pattern = new EqualToXmlPattern("<things>\n    <thing characteristic=\"tepid\"/>\n    <thing characteristic=\"tedious\"/>\n</things>");
        MatchResult matchResult = pattern.match("");
        Assertions.assertFalse((boolean)matchResult.isExactMatch());
        MatcherAssert.assertThat((Object)matchResult.getDistance(), (Matcher)Matchers.is((Object)1.0));
    }

    @Test
    public void returnsNoMatchAnd1DistanceWhenActualIsNotXml() {
        EqualToXmlPattern pattern = new EqualToXmlPattern("<things>\n    <thing characteristic=\"tepid\"/>\n    <thing characteristic=\"tedious\"/>\n</things>");
        MatchResult matchResult = pattern.match("{ \"markup\": \"wrong\" }");
        Assertions.assertFalse((boolean)matchResult.isExactMatch());
        MatcherAssert.assertThat((Object)matchResult.getDistance(), (Matcher)Matchers.is((Object)1.0));
    }

    @Test
    public void returnsExactMatchWhenDocumentsAreIdentical() {
        EqualToXmlPattern pattern = new EqualToXmlPattern("<things>\n    <thing characteristic=\"tepid\"/>\n    <thing characteristic=\"tedious\"/>\n</things>");
        Assertions.assertTrue((boolean)pattern.match("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n<things>\n    <thing characteristic=\"tepid\"/>\n    <thing characteristic=\"tedious\"/>\n</things>").isExactMatch());
    }

    @Test
    public void returnsExactMatchWhenDocumentsAreIdenticalOtherThanWhitespace() {
        EqualToXmlPattern pattern = new EqualToXmlPattern("<things>\n    <thing characteristic=\"tepid\"/>\n    <thing characteristic=\"tedious\"/>\n</things>");
        Assertions.assertTrue((boolean)pattern.match("<things><thing characteristic=\"tepid\"/><thing characteristic=\"tedious\"/></things>").isExactMatch());
    }

    @Test
    public void returnsNoMatchWhenDocumentsAreTotallyDifferent() {
        EqualToXmlPattern pattern = new EqualToXmlPattern("<things>\n    <thing characteristic=\"tepid\"/>\n    <thing characteristic=\"tedious\"/>\n</things>");
        MatchResult matchResult = pattern.match("<no-things-at-all />");
        Assertions.assertFalse((boolean)matchResult.isExactMatch());
        MatcherAssert.assertThat((Object)matchResult.getDistance(), (Matcher)Matchers.is((Object)0.5));
    }

    @Test
    public void returnsLowDistanceWhenActualDocumentHasMissingElement() {
        EqualToXmlPattern pattern = new EqualToXmlPattern("<things>\n    <thing characteristic=\"tepid\"/>\n    <thing characteristic=\"tedious\"/>\n</things>");
        MatchResult matchResult = pattern.match("<things>\n    <thing characteristic=\"tepid\"/>\n</things>");
        MatcherAssert.assertThat((Object)matchResult.getDistance(), (Matcher)Matchers.closeTo((double)0.14, (double)2.0));
    }

    @Test
    public void returnsExactMatchOnNamespacedXml() {
        EqualToXmlPattern pattern = new EqualToXmlPattern("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">\n    <soap:Body>\n        <stuff xmlns=\"https://example.com/mynamespace\">\n            <things />\n        </stuff>\n    </soap:Body>\n</soap:Envelope>\n");
        MatchResult match = pattern.match("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">\n    <soap:Body>\n        <stuff xmlns=\"https://example.com/mynamespace\">\n            <things />\n        </stuff>\n    </soap:Body>\n</soap:Envelope>\n");
        MatcherAssert.assertThat((Object)match.getDistance(), (Matcher)Matchers.is((Object)0.0));
        Assertions.assertTrue((boolean)match.isExactMatch());
    }

    @Test
    public void returnsExactMatchOnNamespacedXmlWhenNamespacePrefixesDiffer() {
        EqualToXmlPattern pattern = new EqualToXmlPattern("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<shampoo:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:shampoo=\"http://schemas.xmlsoap.org/soap/envelope/\">\n    <shampoo:Body>\n        <stuff xmlns=\"https://example.com/mynamespace\">\n            <things />\n        </stuff>\n    </shampoo:Body>\n</shampoo:Envelope>\n");
        MatchResult match = pattern.match("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">\n    <soap:Body>\n        <stuff xmlns=\"https://example.com/mynamespace\">\n            <things />\n        </stuff>\n    </soap:Body>\n</soap:Envelope>\n");
        MatcherAssert.assertThat((Object)match.getDistance(), (Matcher)Matchers.is((Object)0.0));
        Assertions.assertTrue((boolean)match.isExactMatch());
    }

    @Test
    public void doesNotReturnExactMatchWhenNamespaceUriDiffers() {
        EqualToXmlPattern pattern = new EqualToXmlPattern("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">\n    <soap:Body>\n        <stuff xmlns=\"https://example.com/mynamespace\">\n            <things />\n        </stuff>\n    </soap:Body>\n</soap:Envelope>\n");
        Assertions.assertFalse((boolean)pattern.match("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">\n    <soap:Body>\n        <stuff xmlns=\"https://example.com/the-wrong-namespace\">\n            <things />\n        </stuff>\n    </soap:Body>\n</soap:Envelope>\n").isExactMatch());
    }

    @Test
    public void returnsExactMatchWhenAttributesAreInDifferentOrder() {
        EqualToXmlPattern pattern = new EqualToXmlPattern("<my-attribs one=\"1\" two=\"2\" three=\"3\"/>");
        Assertions.assertTrue((boolean)pattern.match("<my-attribs two=\"2\" one=\"1\" three=\"3\"/>").isExactMatch());
    }

    @Test
    public void returnsExactMatchWhenElementsAreInDifferentOrder() {
        EqualToXmlPattern pattern = new EqualToXmlPattern("<my-elements>\n    <one />\n    <two />\n    <three />\n</my-elements>");
        Assertions.assertTrue((boolean)pattern.match("<my-elements>\n    <two />\n    <three />\n    <one />\n</my-elements>").isExactMatch());
    }

    @Test
    public void returnsNoMatchWhenTagNamesDifferAndContentIsSame() {
        EqualToXmlPattern pattern = new EqualToXmlPattern("<one>Hello</one>");
        MatchResult matchResult = pattern.match("<two>Hello</two>");
        MatcherAssert.assertThat((Object)matchResult.isExactMatch(), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)matchResult.getDistance(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)0.0)));
    }

    @Test
    public void logsASensibleErrorMessageWhenActualXmlIsBadlyFormed() {
        Notifier notifier = (Notifier)Mockito.mock(Notifier.class);
        LocalNotifier.set((Notifier)notifier);
        WireMock.equalToXml((String)"<well-formed />").match("badly-formed >").isExactMatch();
        ((Notifier)Mockito.verify((Object)notifier)).info(ArgumentMatchers.contains((String)"Failed to process XML. Content is not allowed in prolog."));
    }

    @Test
    public void doesNotFetchDtdBecauseItCouldResultInAFailedMatch() {
        String xmlWithDtdThatCannotBeFetched = "<!DOCTYPE my_request SYSTEM \"https://thishostname.doesnotexist.com/one.dtd\"><do_request/>";
        EqualToXmlPattern pattern = new EqualToXmlPattern(xmlWithDtdThatCannotBeFetched);
        Assertions.assertTrue((boolean)pattern.match(xmlWithDtdThatCannotBeFetched).isExactMatch());
    }

    @Test
    public void createEqualToXmlPatternWithPlaceholderFromWireMockClass() {
        String placeholderOpeningDelimiterRegex = "theOpeningDelimiterRegex";
        String placeholderClosingDelimiterRegex = "theClosingDelimiterRegex";
        EqualToXmlPattern equalToXmlPattern = WireMock.equalToXml((String)"<a/>", (boolean)true, (String)placeholderOpeningDelimiterRegex, (String)placeholderClosingDelimiterRegex);
        MatcherAssert.assertThat((Object)equalToXmlPattern.isEnablePlaceholders(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)equalToXmlPattern.getPlaceholderOpeningDelimiterRegex(), (Matcher)Matchers.is((Object)placeholderOpeningDelimiterRegex));
        MatcherAssert.assertThat((Object)equalToXmlPattern.getPlaceholderClosingDelimiterRegex(), (Matcher)Matchers.is((Object)placeholderClosingDelimiterRegex));
    }

    @Test
    public void createEqualToXmlPatternWithPlaceholderFromWireMockClass_DefaultDelimiters() {
        EqualToXmlPattern equalToXmlPattern = WireMock.equalToXml((String)"<a/>", (boolean)true);
        MatcherAssert.assertThat((Object)equalToXmlPattern.isEnablePlaceholders(), (Matcher)Matchers.is((Object)true));
        Assertions.assertNull((Object)equalToXmlPattern.getPlaceholderOpeningDelimiterRegex());
        Assertions.assertNull((Object)equalToXmlPattern.getPlaceholderClosingDelimiterRegex());
    }

    @Test
    public void returnsMatchWhenTextNodeIsIgnored() {
        String expectedXml = "<a>#{xmlunit.ignore}</a>";
        String actualXml = "<a>123</a>";
        EqualToXmlPattern pattern = new EqualToXmlPattern(expectedXml, Boolean.valueOf(true), "#\\{", "}", null);
        MatchResult matchResult = pattern.match(actualXml);
        Assertions.assertTrue((boolean)matchResult.isExactMatch());
        MatcherAssert.assertThat((Object)matchResult.getDistance(), (Matcher)Matchers.is((Object)0.0));
    }

    @Test
    public void returnsMatchWhenTextNodeIsIgnored_DefaultDelimiters() {
        String expectedXml = "<a>${xmlunit.ignore}</a>";
        String actualXml = "<a>123</a>";
        EqualToXmlPattern pattern = new EqualToXmlPattern(expectedXml, Boolean.valueOf(true), null, null, null);
        MatchResult matchResult = pattern.match(actualXml);
        Assertions.assertTrue((boolean)matchResult.isExactMatch());
        MatcherAssert.assertThat((Object)matchResult.getDistance(), (Matcher)Matchers.is((Object)0.0));
    }

    @Test
    public void deserializesEqualToXmlWithMinimalParameters() {
        String patternJson = "{\"equalToXml\" : \"<a/>\"}";
        StringValuePattern stringValuePattern = (StringValuePattern)Json.read((String)patternJson, StringValuePattern.class);
        Assertions.assertTrue((boolean)(stringValuePattern instanceof EqualToXmlPattern));
        EqualToXmlPattern equalToXmlPattern = (EqualToXmlPattern)stringValuePattern;
        MatcherAssert.assertThat((Object)equalToXmlPattern.isEnablePlaceholders(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)equalToXmlPattern.getPlaceholderOpeningDelimiterRegex(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)equalToXmlPattern.getPlaceholderClosingDelimiterRegex(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)equalToXmlPattern.getExemptedComparisons(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void deserializesEqualToXmlWithAllParameters() {
        Boolean enablePlaceholders = Boolean.TRUE;
        String placeholderOpeningDelimiterRegex = "theOpeningDelimiterRegex";
        String placeholderClosingDelimiterRegex = "theClosingDelimiterRegex";
        String patternJson = "{\"equalToXml\" : \"<a/>\", \"enablePlaceholders\" : " + enablePlaceholders + ", \"placeholderOpeningDelimiterRegex\" : \"" + placeholderOpeningDelimiterRegex + "\", \"placeholderClosingDelimiterRegex\" : \"" + placeholderClosingDelimiterRegex + "\", \"exemptedComparisons\": [\"SCHEMA_LOCATION\", \"NAMESPACE_URI\", \"ATTR_VALUE\"] }";
        StringValuePattern stringValuePattern = (StringValuePattern)Json.read((String)patternJson, StringValuePattern.class);
        Assertions.assertTrue((boolean)(stringValuePattern instanceof EqualToXmlPattern));
        EqualToXmlPattern equalToXmlPattern = (EqualToXmlPattern)stringValuePattern;
        Assertions.assertEquals((Object)enablePlaceholders, (Object)equalToXmlPattern.isEnablePlaceholders());
        Assertions.assertEquals((Object)placeholderOpeningDelimiterRegex, (Object)equalToXmlPattern.getPlaceholderOpeningDelimiterRegex());
        Assertions.assertEquals((Object)placeholderClosingDelimiterRegex, (Object)equalToXmlPattern.getPlaceholderClosingDelimiterRegex());
        MatcherAssert.assertThat((Object)equalToXmlPattern.getExemptedComparisons(), (Matcher)Matchers.is(Set.of(ComparisonType.SCHEMA_LOCATION, ComparisonType.NAMESPACE_URI, ComparisonType.ATTR_VALUE)));
    }

    @Test
    public void serializesEqualToXmlWithAllParameters() {
        String xml = "<stuff />";
        Boolean enablePlaceholders = Boolean.TRUE;
        String placeholderOpeningDelimiterRegex = "[";
        String placeholderClosingDelimiterRegex = "]";
        EqualToXmlPattern pattern = new EqualToXmlPattern(xml, enablePlaceholders, placeholderOpeningDelimiterRegex, placeholderClosingDelimiterRegex, Set.of(ComparisonType.SCHEMA_LOCATION, ComparisonType.NAMESPACE_URI, ComparisonType.ATTR_VALUE));
        String json = Json.write((Object)pattern);
        MatcherAssert.assertThat((Object)json, WireMatchers.equalToJson("{\n  \"equalToXml\": \"<stuff />\",\n  \"enablePlaceholders\": true,\n  \"placeholderOpeningDelimiterRegex\": \"[\",\n  \"placeholderClosingDelimiterRegex\": \"]\",\n  \"exemptedComparisons\": [\"SCHEMA_LOCATION\", \"ATTR_VALUE\", \"NAMESPACE_URI\"]\n}", JSONCompareMode.NON_EXTENSIBLE));
    }

    @Test
    public void namespaceComparisonCanBeExcluded() {
        String expected = "<?xml version=\"1.0\"?>\n<stuff xmlns:th=\"https://thing.com\">\n    <th:thing>Match this</th:thing>\n</stuff>";
        String actual = "<?xml version=\"1.0\"?>\n<stuff xmlns:st=\"https://stuff.com\">\n    <st:thing>Match this</st:thing>\n</stuff>";
        MatchResult matchResult = WireMock.equalToXml((String)expected).match(actual);
        Assertions.assertTrue((boolean)matchResult.isExactMatch());
    }

    @Test
    public void namespaceComparisonCanBeExcluded2() {
        String expected = "<ns2:GetValue\n        xmlns=\"http://CIS/BIR/PUBL/2014/07/DataContract\"\n        xmlns:ns2=\"http://CIS/BIR/2014/07\"                         \n        xmlns:ns3=\"http://CIS/BIR/PUBL/2014/07\"                    \n        xmlns:ns4=\"http://schemas.microsoft.com/2003/10/Serializa  \n        tion/\"/>";
        String actual = "<ns3:GetValue\n        xmlns=\"http://CIS/BIR/PUBL/2014/07\"\n        xmlns:ns2=\"http://CIS/BIR/PUBL/2014/07/DataContract\"\n        xmlns:ns3=\"http://CIS/BIR/2014/07\"\n        xmlns:ns4=\"http://schemas.microsoft.com/2003/10/Serializa\n        tion/\"/>";
        EqualToXmlPattern pattern = WireMock.equalToXml((String)expected).exemptingComparisons(new ComparisonType[]{ComparisonType.NAMESPACE_URI});
        Assertions.assertTrue((boolean)pattern.match((Object)actual).isExactMatch());
    }

    @Test
    public void testEquals() {
        EqualToXmlPattern a = new EqualToXmlPattern("<ns2:GetValue\n        xmlns=\"http://CIS/BIR/PUBL/2014/07/DataContract\"\n        xmlns:ns2=\"http://CIS/BIR/2014/07\"                         \n        xmlns:ns3=\"http://CIS/BIR/PUBL/2014/07\"                    \n        xmlns:ns4=\"http://schemas.microsoft.com/2003/10/Serializa  \n        tion/\"/>");
        EqualToXmlPattern b = new EqualToXmlPattern("<ns2:GetValue\n        xmlns=\"http://CIS/BIR/PUBL/2014/07/DataContract\"\n        xmlns:ns2=\"http://CIS/BIR/2014/07\"                         \n        xmlns:ns3=\"http://CIS/BIR/PUBL/2014/07\"                    \n        xmlns:ns4=\"http://schemas.microsoft.com/2003/10/Serializa  \n        tion/\"/>");
        EqualToXmlPattern c = new EqualToXmlPattern("<ns2:GetValue\n        xmlns=\"http://CIS/BIR/PUBL/2015/07/DataContract\"\n        xmlns:ns2=\"http://CIS/BIR/2015/07\"                         \n        xmlns:ns3=\"http://CIS/BIR/PUBL/2015/07\"                    \n        xmlns:ns4=\"http://schemas.microsoft.com/2004/10/Serializa  \n        tion/\"/>");
        Assertions.assertEquals((Object)a, (Object)b);
        Assertions.assertEquals((int)a.hashCode(), (int)b.hashCode());
        Assertions.assertEquals((Object)b, (Object)a);
        Assertions.assertEquals((int)b.hashCode(), (int)a.hashCode());
        Assertions.assertNotEquals((Object)a, (Object)c);
        Assertions.assertNotEquals((int)a.hashCode(), (int)c.hashCode());
        Assertions.assertNotEquals((Object)b, (Object)c);
        Assertions.assertNotEquals((int)b.hashCode(), (int)c.hashCode());
    }

    @Test
    void subEventIsReturnedOnXmlParsingError() {
        MatchResult match = new EqualToXmlPattern("<things />").match("<wrong");
        MatcherAssert.assertThat((Object)match.isExactMatch(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)match.getSubEvents().size(), (Matcher)Matchers.is((Object)1));
        String message = ((SubEvent)match.getSubEvents().stream().findFirst().get()).getData().get("message").toString();
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.startsWith((String)"XML document structures must start and end within the same entity"));
    }
}

