/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.matching.EqualToJsonPattern;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.json.JSONException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.skyscreamer.jsonassert.JSONAssert;

public class EqualToJsonTest {
    @Test
    public void returns0DistanceForExactMatchForSingleLevelObject() {
        MatcherAssert.assertThat((Object)WireMock.equalToJson((String)"{                  \n   \"one\":    1,  \n   \"two\":    2,  \n   \"three\":  3,  \n   \"four\":   4   \n}                  \n").match((Object)"{                  \n   \"one\":    1,  \n   \"two\":    2,  \n   \"three\":  3,  \n   \"four\":   4   \n}                  \n").getDistance(), (Matcher)Matchers.is((Object)0.0));
    }

    @Test
    public void returnsNon0DistanceForPartialMatchForSingleLevelObject() {
        MatcherAssert.assertThat((Object)WireMock.equalToJson((String)"{                  \n   \"one\":    1,  \n   \"two\":    2,  \n   \"three\":  3,  \n   \"four\":   4   \n}                  \n").match((Object)"{                  \n   \"one\":    1,  \n   \"two\":    2,  \n   \"three\":  7,  \n   \"four\":   8   \n}                  \n").getDistance(), (Matcher)Matchers.is((Object)0.4));
    }

    @Test
    public void returnsLargeDistanceForTotallyDifferentDocuments() {
        MatcherAssert.assertThat((Object)WireMock.equalToJson((String)"{                  \n   \"one\":    1,  \n   \"two\":    2,  \n   \"three\":  3,  \n   \"four\":   4   \n}                  \n").match((Object)"[1, 2, 3]").getDistance(), (Matcher)Matchers.is((Object)1.0));
    }

    @Test
    public void returnsLargeDistanceWhenActualDocIsAnEmptyObject() {
        MatcherAssert.assertThat((Object)WireMock.equalToJson((String)"{                  \n   \"one\":    1,  \n   \"two\":    2,  \n   \"three\":  3,  \n   \"four\":   4   \n}                  \n").match((Object)"{}").getDistance(), (Matcher)Matchers.is((Object)0.8));
    }

    @Test
    public void returnsLargeDistanceWhenActualDocIsAnEmptyArray() {
        MatcherAssert.assertThat((Object)WireMock.equalToJson((String)"{                  \n   \"one\":    1,  \n   \"two\":    2,  \n   \"three\":  3,  \n   \"four\":   4   \n}                  \n").match((Object)"[]").getDistance(), (Matcher)Matchers.is((Object)1.0));
    }

    @Test
    public void returnsLargeDistanceWhenExpectedDocIsAnEmptyObject() {
        MatcherAssert.assertThat((Object)WireMock.equalToJson((String)"{}").match((Object)"{                  \n   \"one\":    1,  \n   \"two\":    2,  \n   \"three\":  3,  \n   \"four\":   4   \n}                  \n").getDistance(), (Matcher)Matchers.is((Object)0.8));
    }

    @Test
    public void returnsLargeDistanceWhenExpectedDocIsAnEmptyArray() {
        MatcherAssert.assertThat((Object)WireMock.equalToJson((String)"[]").match((Object)"{                  \n   \"one\":    1,  \n   \"two\":    2,  \n   \"three\":  3,  \n   \"four\":   4   \n}                  \n").getDistance(), (Matcher)Matchers.is((Object)1.0));
    }

    @Test
    public void returnsMediumDistanceWhenSubtreeIsMissingFromActual() {
        MatcherAssert.assertThat((Object)WireMock.equalToJson((String)"{\n    \"one\": \"GET\",          \n    \"two\": 2,                \n    \"three\": {               \n        \"four\": \"FOUR\",    \n        \"five\": [            \n            {                  \n                \"six\": 6,    \n                \"seven\": 7   \n            },                 \n            {                  \n                \"eight\": 8,  \n                \"nine\": 9    \n            }                  \n        ]                      \n    }                          \n}").match((Object)"{                          \n   \"one\":    \"GET\",    \n   \"two\":    2,          \n   \"three\":  {           \n       \"four\":   \"FOUR\"\n   }                       \n}                          \n").getDistance(), (Matcher)Matchers.closeTo((double)0.56, (double)0.01));
    }

    @Test
    public void returnsExactMatchWhenObjectPropertyOrderDiffers() {
        Assertions.assertTrue((boolean)WireMock.equalToJson((String)"{                  \n   \"one\":    1,  \n   \"two\":    2,  \n   \"three\":  3,  \n   \"four\":   4   \n}                  \n").match((Object)"{                  \n   \"one\":    1,  \n   \"three\":  3,  \n   \"two\":    2,  \n   \"four\":   4   \n}                  \n").isExactMatch());
    }

    @Test
    public void returnsNonMatchWhenArrayOrderDiffers() {
        Assertions.assertFalse((boolean)WireMock.equalToJson((String)"[1, 2, 3, 4]").match((Object)"[1, 3, 2, 4]").isExactMatch());
    }

    @Test
    public void ignoresArrayOrderDifferenceWhenConfigured() {
        Assertions.assertTrue((boolean)WireMock.equalToJson((String)"[1, 2, 3, 4]", (boolean)true, (boolean)false).match((Object)"[1, 3, 2, 4]").isExactMatch());
    }

    @Test
    public void ignoresNestedArrayOrderDifferenceWhenConfigured() {
        Assertions.assertTrue((boolean)WireMock.equalToJson((String)"{\n    \"one\": 1,\n    \"two\": [\n        { \"val\": 1 },\n        { \"val\": 2 },\n        { \"val\": 3 }\n    ]\n}", (boolean)true, (boolean)false).match((Object)"{\n    \"one\": 1,\n    \"two\": [\n        { \"val\": 3 },\n        { \"val\": 2 },\n        { \"val\": 1 }\n    ]\n}").isExactMatch());
    }

    @Test
    public void ignoresExtraObjectAttributesWhenConfigured() {
        Assertions.assertTrue((boolean)WireMock.equalToJson((String)"{                  \n   \"one\":    1,  \n   \"two\":    2,  \n   \"three\":  3,  \n   \"four\":   4   \n}                  \n", (boolean)false, (boolean)true).match((Object)"{                  \n   \"one\":    1,  \n   \"three\":  3,  \n   \"two\":    2,  \n   \"four\":   4,  \n   \"five\":   5,  \n   \"six\":    6   \n}                  \n").isExactMatch());
    }

    @Test
    public void ignoresExtraObjectAttributesAndArrayOrderWhenConfigured() {
        Assertions.assertTrue((boolean)WireMock.equalToJson((String)"{                          \n   \"one\":    1,          \n   \"two\":    2,          \n   \"three\":  3,          \n   \"four\":   [1, 2, 3]   \n}                  \n", (boolean)true, (boolean)true).match((Object)"{                          \n   \"one\":    1,          \n   \"three\":  3,          \n   \"two\":    2,          \n   \"four\":   [2, 1, 3],  \n   \"five\":   5,          \n   \"six\":    6           \n}                          \n").isExactMatch());
    }

    @Test
    public void correctlyDeserialisesFromJsonStringWhenAdditionalParamsPresent() {
        StringValuePattern pattern = (StringValuePattern)Json.read((String)"{\n    \"equalToJson\": \"2\",\n    \"ignoreArrayOrder\": true,\n    \"ignoreExtraElements\": true\n}", StringValuePattern.class);
        MatcherAssert.assertThat((Object)pattern, (Matcher)Matchers.instanceOf(EqualToJsonPattern.class));
        MatcherAssert.assertThat((Object)((EqualToJsonPattern)pattern).isIgnoreArrayOrder(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((EqualToJsonPattern)pattern).isIgnoreExtraElements(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)pattern.getExpected(), (Matcher)Matchers.is((Object)"2"));
    }

    @Test
    public void correctlyDeserialisesFromJsonValueWhenAdditionalParamsPresent() throws JSONException {
        String expectedJson = "{ \"someKey\": \"someValue\" }";
        String serializedJson = "{                                           \n    \"equalToJson\": " + expectedJson + ",  \n    \"ignoreArrayOrder\": true,             \n    \"ignoreExtraElements\": true           \n}                                             ";
        StringValuePattern pattern = (StringValuePattern)Json.read((String)serializedJson, StringValuePattern.class);
        MatcherAssert.assertThat((Object)pattern, (Matcher)Matchers.instanceOf(EqualToJsonPattern.class));
        MatcherAssert.assertThat((Object)((EqualToJsonPattern)pattern).isIgnoreArrayOrder(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((EqualToJsonPattern)pattern).isIgnoreExtraElements(), (Matcher)Matchers.is((Object)true));
        JSONAssert.assertEquals((String)pattern.getExpected(), (String)expectedJson, (boolean)false);
    }

    @Test
    public void correctlySerialisesToJsonValueWhenAdditionalParamsPresentAndConstructedWithJsonValue() throws JSONException {
        String expectedJson = "{ \"someKey\": \"someValue\" }";
        EqualToJsonPattern pattern = new EqualToJsonPattern(Json.node((String)expectedJson), Boolean.valueOf(true), Boolean.valueOf(true));
        String serialised = Json.write((Object)pattern);
        String expected = "{                                           \n    \"equalToJson\": " + expectedJson + ",  \n    \"ignoreArrayOrder\": true,             \n    \"ignoreExtraElements\": true           \n}                                             ";
        JSONAssert.assertEquals((String)expected, (String)serialised, (boolean)false);
    }

    @Test
    public void correctlySerialisesToJsonWhenAdditionalParamsPresentAndConstructedWithString() throws JSONException {
        EqualToJsonPattern pattern = new EqualToJsonPattern("4444", Boolean.valueOf(true), Boolean.valueOf(true));
        String serialised = Json.write((Object)pattern);
        JSONAssert.assertEquals((String)"{\n    \"equalToJson\": \"4444\",\n    \"ignoreArrayOrder\": true,\n    \"ignoreExtraElements\": true\n}", (String)serialised, (boolean)false);
    }

    @Test
    public void correctlyDeserialisesFromJsonStringWhenAdditionalParamsAbsent() {
        StringValuePattern pattern = (StringValuePattern)Json.read((String)"{\n    \"equalToJson\": \"2\"\n}", StringValuePattern.class);
        MatcherAssert.assertThat((Object)pattern, (Matcher)Matchers.instanceOf(EqualToJsonPattern.class));
        MatcherAssert.assertThat((Object)((EqualToJsonPattern)pattern).isIgnoreArrayOrder(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)((EqualToJsonPattern)pattern).isIgnoreExtraElements(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)pattern.getExpected(), (Matcher)Matchers.is((Object)"2"));
    }

    @Test
    public void correctlyDeserialisesFromJsonValueWhenAdditionalParamsAbsent() throws JSONException {
        String expectedJson = "[ 1, 2, \"value\" ]";
        StringValuePattern pattern = (StringValuePattern)Json.read((String)("{ \"equalToJson\": " + expectedJson + " }"), StringValuePattern.class);
        MatcherAssert.assertThat((Object)pattern, (Matcher)Matchers.instanceOf(EqualToJsonPattern.class));
        MatcherAssert.assertThat((Object)((EqualToJsonPattern)pattern).isIgnoreArrayOrder(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)((EqualToJsonPattern)pattern).isIgnoreExtraElements(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        JSONAssert.assertEquals((String)pattern.getExpected(), (String)expectedJson, (boolean)false);
    }

    @Test
    public void correctlySerialisesToJsonWhenAdditionalParamsAbsentAndConstructedWithJsonValue() throws JSONException {
        String expectedJson = "[ 1, 2, \"value\" ]";
        EqualToJsonPattern pattern = new EqualToJsonPattern(Json.node((String)expectedJson), null, null);
        String serialised = Json.write((Object)pattern);
        JSONAssert.assertEquals((String)("{ \"equalToJson\": " + expectedJson + " }"), (String)serialised, (boolean)false);
    }

    @Test
    public void correctlySerialisesToJsonWhenAdditionalParamsAbsent() throws JSONException {
        EqualToJsonPattern pattern = new EqualToJsonPattern("4444", null, null);
        String serialised = Json.write((Object)pattern);
        JSONAssert.assertEquals((String)"{\n    \"equalToJson\": \"4444\"\n}", (String)serialised, (boolean)false);
    }

    @Test
    public void returnsNoExactMatchForVerySimilarNestedDocs() {
        Assertions.assertFalse((boolean)new EqualToJsonPattern("{\n    \"outer\": {\n        \"inner:\": {\n            \"wrong\": 1\n        }\n    }\n}", Boolean.valueOf(false), Boolean.valueOf(false)).match("{\n    \"outer\": {\n        \"inner:\": {\n            \"thing\": 1\n        }\n    }\n}").isExactMatch());
    }

    @Test
    public void doesNotMatchWhenValueIsNull() {
        MatchResult match = new EqualToJsonPattern("{\n    \"outer\": {\n        \"inner:\": {\n            \"wrong\": 1\n        }\n    }\n}", Boolean.valueOf(false), Boolean.valueOf(false)).match(null);
        Assertions.assertFalse((boolean)match.isExactMatch());
        MatcherAssert.assertThat((Object)match.getDistance(), (Matcher)Matchers.is((Object)1.0));
    }

    @Test
    public void doesNotMatchWhenValueIsEmptyString() {
        MatchResult match = new EqualToJsonPattern("{\n    \"outer\": {\n        \"inner:\": {\n            \"wrong\": 1\n        }\n    }\n}", Boolean.valueOf(false), Boolean.valueOf(false)).match("");
        Assertions.assertFalse((boolean)match.isExactMatch());
        MatcherAssert.assertThat((Object)match.getDistance(), (Matcher)Matchers.is((Object)1.0));
    }

    @Test
    public void doesNotMatchWhenValueIsNotJson() {
        MatchResult match = new EqualToJsonPattern("{\n    \"outer\": {\n        \"inner:\": {\n            \"wrong\": 1\n        }\n    }\n}", Boolean.valueOf(false), Boolean.valueOf(false)).match("<some-xml />");
        Assertions.assertFalse((boolean)match.isExactMatch());
        MatcherAssert.assertThat((Object)match.getDistance(), (Matcher)Matchers.is((Object)1.0));
    }

    @Test
    public void doesNotBreakWhenComparingNestedArraysOfDifferentSizes() {
        String expected = "{\"columns\": [{\"name\": \"agreementnumber\",\"a\": 1},{\"name\": \"utilizerstatus\",\"b\": 2}]}";
        String actual = "{\"columns\": [{\"name\": \"x\",\"y\": 3},{\"name\": \"agreementnumber\",\"a\": 1},{\"name\": \"agreementstatus\",\"b\": 2}]}";
        MatchResult match = new EqualToJsonPattern(expected, Boolean.valueOf(false), Boolean.valueOf(false)).match(actual);
        Assertions.assertFalse((boolean)match.isExactMatch());
    }

    @Test
    public void doesNotBreakWhenComparingTopLevelArraysOfDifferentSizesWithCommonElements() {
        String expected = "[    \n  { \"one\": 1 },  \n  { \"two\": 2 },  \n  { \"three\": 3 } \n]";
        String actual = "[      \n  { \"zero\": 0 }, \n  { \"one\": 1 },  \n  { \"two\": 2 },  \n  { \"four\": 4 }  \n]";
        MatchResult match = new EqualToJsonPattern(expected, Boolean.valueOf(false), Boolean.valueOf(false)).match(actual);
        Assertions.assertFalse((boolean)match.isExactMatch());
    }

    @Test
    public void ignoresExtraElementsWhenParameterIsPresentsWithoutIgnoreArrayOrder() {
        StringValuePattern pattern = (StringValuePattern)Json.read((String)"{\n    \"equalToJson\": { \"one\": 1 },\n    \"ignoreExtraElements\": true\n}", StringValuePattern.class);
        MatcherAssert.assertThat((Object)pattern.match((Object)"{\n    \"one\": 1,\n    \"two\": 2\n}").isExactMatch(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void doesNotMatchEmptyArraysWhenNotIgnoringExtraElements() {
        String expected = "{\"client\":\"AAA\",\"name\":\"BBB\"}";
        String actual = "{\"client\":\"AAA\", \"name\":\"BBB\", \"addresses\": [ ]}";
        MatchResult match = new EqualToJsonPattern(expected, Boolean.valueOf(false), Boolean.valueOf(false)).match(actual);
        Assertions.assertFalse((boolean)match.isExactMatch());
    }

    @Test
    public void doesNotMatchEmptyArrayWhenIgnoringExtraArrayElementsAndNotIgnoringExtraElements() {
        String expected = "{\"client\":\"AAA\",\"name\":\"BBB\"}";
        String actual = "{\"client\":\"AAA\", \"name\":\"BBB\", \"addresses\": [ ]}";
        MatchResult match = new EqualToJsonPattern(expected, Boolean.valueOf(true), Boolean.valueOf(false)).match(actual);
        Assertions.assertFalse((boolean)match.isExactMatch());
    }

    @Test
    public void doesNotMatchEmptyObjectWhenIgnoringExtraArrayElementsAndNotIgnoringExtraElements() {
        String expected = "{\"client\":\"AAA\",\"name\":\"BBB\"}";
        String actual = "{\"client\":\"AAA\", \"name\":\"BBB\", \"addresses\": { }}";
        MatchResult match = new EqualToJsonPattern(expected, Boolean.valueOf(true), Boolean.valueOf(false)).match(actual);
        Assertions.assertFalse((boolean)match.isExactMatch());
    }

    @Test
    public void treatsTwoTopLevelsArraysWithDifferingOrderAsSameWhenIgnoringOrder() {
        String expected = "[\"a\",\"b\", \"c\",\"d\",\"e\",\"f\",\"g\",\"h\"]";
        String actual = "[\"b\",\"a\", \"d\",\"c\",\"e\",\"f\",\"g\",\"h\"]";
        EqualToJsonPattern pattern = new EqualToJsonPattern(expected, Boolean.valueOf(true), Boolean.valueOf(true));
        MatchResult result = pattern.match(actual);
        Assertions.assertTrue((boolean)result.isExactMatch());
    }

    @Test
    public void supportsPlaceholders() {
        String expected = "{\n  \"id\": \"${json-unit.any-string}\",\n  \"name\": \"Tom\"\n}";
        String actual = "{\n  \"id\": \"abc123\",\n  \"name\": \"Tom\"\n}";
        MatchResult match = new EqualToJsonPattern(expected, Boolean.valueOf(false), Boolean.valueOf(false)).match(actual);
        MatcherAssert.assertThat((Object)match.isExactMatch(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void supportsRegexPlaceholders() {
        String expected = "{\n  \"id\": \"${json-unit.regex}[a-z]+\",\n  \"name\": \"Tom\"\n}";
        String actualMatching = "{\n  \"id\": \"abc\",\n  \"name\": \"Tom\"\n}";
        MatchResult match = new EqualToJsonPattern(expected, Boolean.valueOf(false), Boolean.valueOf(false)).match(actualMatching);
        MatcherAssert.assertThat((Object)match.isExactMatch(), (Matcher)Matchers.is((Object)true));
        String actualNonMatching = "{\n  \"id\": \"123\",\n  \"name\": \"Tom\"\n}";
        MatchResult nonMatch = new EqualToJsonPattern(expected, Boolean.valueOf(false), Boolean.valueOf(false)).match(actualNonMatching);
        MatcherAssert.assertThat((Object)nonMatch.isExactMatch(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void objectsShouldBeEqualOnSameExpectedValue() {
        EqualToJsonPattern a = new EqualToJsonPattern("{\n  \"id\": \"abc\",\n  \"name\": \"Tom\"\n}", Boolean.valueOf(false), Boolean.valueOf(false));
        EqualToJsonPattern b = new EqualToJsonPattern("{\n  \"id\": \"abc\",\n  \"name\": \"Tom\"\n}", Boolean.valueOf(false), Boolean.valueOf(false));
        EqualToJsonPattern c = new EqualToJsonPattern("{\n  \"id\": \"123\",\n  \"name\": \"Eric\"\n}", Boolean.valueOf(false), Boolean.valueOf(false));
        Assertions.assertEquals((Object)a, (Object)b);
        Assertions.assertEquals((int)a.hashCode(), (int)b.hashCode());
        Assertions.assertEquals((Object)b, (Object)a);
        Assertions.assertEquals((int)b.hashCode(), (int)a.hashCode());
        Assertions.assertNotEquals((Object)a, (Object)c);
        Assertions.assertNotEquals((int)a.hashCode(), (int)c.hashCode());
        Assertions.assertNotEquals((Object)b, (Object)c);
        Assertions.assertNotEquals((int)b.hashCode(), (int)c.hashCode());
    }

    @Test
    void subEventIsReturnedOnJsonParsingError() {
        MatchResult match = new EqualToJsonPattern("{}", Boolean.valueOf(false), Boolean.valueOf(false)).match("{ \"wrong");
        MatcherAssert.assertThat((Object)match.getSubEvents().size(), (Matcher)Matchers.is((Object)1));
        Errors.Error error = (Errors.Error)((Errors)((SubEvent)match.getSubEvents().stream().findFirst().get()).getDataAs(Errors.class)).getErrors().stream().findFirst().get();
        MatcherAssert.assertThat((Object)error.getDetail(), (Matcher)Matchers.startsWith((String)"Unexpected end-of-input"));
    }
}

