/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.ContainsPattern;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ContainsPatternTest {
    @Test
    public void returnsExactMatchWhenExpectedValueWhollyContainedInTestValue() {
        Assertions.assertTrue((boolean)WireMock.containing((String)"thing").match((Object)"mythings").isExactMatch());
    }

    @Test
    public void returnsNoMatchWhenExpectedValueNotContainedInTestValue() {
        MatchResult matchResult = WireMock.containing((String)"thing").match((Object)"otherstuff");
        Assertions.assertFalse((boolean)matchResult.isExactMatch());
        MatcherAssert.assertThat((Object)matchResult.getDistance(), (Matcher)Matchers.is((Object)1.0));
    }

    @Test
    public void objectsShouldBeEqualOnSameExpectedValue() {
        ContainsPattern a = new ContainsPattern("someString");
        ContainsPattern b = new ContainsPattern("someString");
        ContainsPattern c = new ContainsPattern("someOtherString");
        Assertions.assertEquals((Object)a, (Object)b);
        Assertions.assertEquals((int)a.hashCode(), (int)b.hashCode());
        Assertions.assertEquals((Object)b, (Object)a);
        Assertions.assertEquals((int)b.hashCode(), (int)a.hashCode());
        Assertions.assertNotEquals((Object)a, (Object)c);
        Assertions.assertNotEquals((int)a.hashCode(), (int)c.hashCode());
        Assertions.assertNotEquals((Object)b, (Object)c);
        Assertions.assertNotEquals((int)b.hashCode(), (int)c.hashCode());
    }
}

