/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.DateTimeTruncation;
import com.github.tomakehurst.wiremock.common.DateTimeUnit;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.matching.AbstractDateTimePattern;
import com.github.tomakehurst.wiremock.matching.BeforeDateTimePattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import net.javacrumbs.jsonunit.JsonMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeforeDateTimePatternTest {
    @Test
    public void matchesZonedISO8601BeforeZonedLiteralDateTime() {
        BeforeDateTimePattern matcher = WireMock.before((String)"2021-06-14T15:15:15Z");
        Assertions.assertTrue((boolean)matcher.match((Object)"2021-06-01T15:15:15Z").isExactMatch());
        Assertions.assertFalse((boolean)matcher.match((Object)"2021-07-01T23:59:59Z").isExactMatch());
    }

    @Test
    public void matchesZonedExpectedWithLocalActual() {
        BeforeDateTimePattern matcher = WireMock.before((String)"2021-06-14T15:15:15Z");
        Assertions.assertTrue((boolean)matcher.match((Object)"2021-06-01T15:15:15").isExactMatch());
        Assertions.assertFalse((boolean)matcher.match((Object)"2021-07-01T23:59:59").isExactMatch());
    }

    @Test
    public void matchesLocalISO8601BeforeLocalLiteralDateTime() {
        BeforeDateTimePattern matcher = WireMock.before((String)"2021-06-14T15:15:15");
        Assertions.assertTrue((boolean)matcher.match((Object)"2021-06-01T15:15:15").isExactMatch());
        Assertions.assertFalse((boolean)matcher.match((Object)"2021-07-01T23:59:59").isExactMatch());
    }

    @Test
    public void matchesZonedISO8601BeforeLocalLiteralDateTime() {
        BeforeDateTimePattern matcher = WireMock.before((String)"2021-06-14T15:15:15");
        Assertions.assertTrue((boolean)matcher.match((Object)"2021-06-01T15:15:15Z").isExactMatch());
        Assertions.assertFalse((boolean)matcher.match((Object)"2021-07-01T23:59:59Z").isExactMatch());
    }

    @Test
    public void doesNotMatchWhenActualValueUnparseable() {
        BeforeDateTimePattern matcher = WireMock.before((String)"2021-06-14T15:15:15");
        Assertions.assertFalse((boolean)matcher.match((Object)"2021-06-01T15:15:blahsdfj123").isExactMatch());
    }

    @Test
    public void doesNotMatchWhenActualValueIsNull() {
        BeforeDateTimePattern matcher = WireMock.before((String)"2021-06-14T15:15:15");
        Assertions.assertFalse((boolean)matcher.match(null).isExactMatch());
    }

    @Test
    public void doesNotMatchWhenExpectedValueUnparseable() {
        BeforeDateTimePattern matcher = WireMock.before((String)"2021-06-wrongstuff:15:15");
        Assertions.assertFalse((boolean)matcher.match((Object)"2021-06-01T15:15:15Z").isExactMatch());
    }

    @Test
    public void returnsAReasonableDistanceWhenNoMatchForZonedExpectedZonedActual() {
        BeforeDateTimePattern matcher = WireMock.before((String)"2021-01-01T00:00:00Z");
        MatcherAssert.assertThat((Object)matcher.match((Object)"2071-01-01T00:00:00Z").getDistance(), (Matcher)Matchers.is((Object)0.5));
        MatcherAssert.assertThat((Object)matcher.match((Object)"2121-01-01T00:00:00Z").getDistance(), (Matcher)Matchers.is((Object)1.0));
        MatcherAssert.assertThat((Object)matcher.match(null).getDistance(), (Matcher)Matchers.is((Object)1.0));
        MatcherAssert.assertThat((Object)matcher.match((Object)"2022-01-01T00:00:00Z").getDistance(), (Matcher)Matchers.is((Object)0.01));
    }

    @Test
    public void returnsAReasonableDistanceWhenNoMatchForLocalExpectedZonedActual() {
        BeforeDateTimePattern matcher = WireMock.before((String)"2021-01-01T00:00:00");
        MatcherAssert.assertThat((Object)matcher.match((Object)"2071-01-01T00:00:00Z").getDistance(), (Matcher)Matchers.is((Object)0.5));
        MatcherAssert.assertThat((Object)matcher.match((Object)"2121-01-01T00:00:00Z").getDistance(), (Matcher)Matchers.is((Object)1.0));
        MatcherAssert.assertThat((Object)matcher.match(null).getDistance(), (Matcher)Matchers.is((Object)1.0));
        MatcherAssert.assertThat((Object)matcher.match((Object)"2022-01-01T00:00:00Z").getDistance(), (Matcher)Matchers.is((Object)0.01));
    }

    @Test
    public void returnsAReasonableDistanceWhenNoMatchForLocalExpectedLocalActual() {
        BeforeDateTimePattern matcher = WireMock.before((String)"2021-01-01T00:00:00");
        MatcherAssert.assertThat((Object)matcher.match((Object)"2071-01-01T00:00:00").getDistance(), (Matcher)Matchers.is((Object)0.5));
        MatcherAssert.assertThat((Object)matcher.match((Object)"2121-01-01T00:00:00").getDistance(), (Matcher)Matchers.is((Object)1.0));
        MatcherAssert.assertThat((Object)matcher.match(null).getDistance(), (Matcher)Matchers.is((Object)1.0));
        MatcherAssert.assertThat((Object)matcher.match((Object)"2022-01-01T00:00:00").getDistance(), (Matcher)Matchers.is((Object)0.01));
    }

    @Test
    public void matchesZonedRFC1123ActualDate() {
        BeforeDateTimePattern matcher = WireMock.before((String)"2021-06-14T15:15:15Z");
        Assertions.assertTrue((boolean)matcher.match((Object)"Tue, 01 Jun 2021 15:16:17 GMT").isExactMatch());
        Assertions.assertFalse((boolean)matcher.match((Object)"Thu, 01 Jul 2021 15:16:17 GMT").isExactMatch());
    }

    @Test
    public void matchesZonedRFC1036ActualDate() {
        BeforeDateTimePattern matcher = WireMock.before((String)"2021-06-14T15:15:15Z");
        Assertions.assertTrue((boolean)matcher.match((Object)"Tuesday, 01-Jun-21 14:14:14 GMT").isExactMatch());
        Assertions.assertFalse((boolean)matcher.match((Object)"Thursday, 01-Jul-21 15:16:17 GMT").isExactMatch());
    }

    @Test
    public void matchesZonedSingleDigitDayAsctimeActualDate() {
        BeforeDateTimePattern matcher = WireMock.before((String)"2021-06-14T01:01:01Z");
        Assertions.assertTrue((boolean)matcher.match((Object)"Tue Jun  1 01:01:01 2021").isExactMatch());
        Assertions.assertFalse((boolean)matcher.match((Object)"Thu Jul  1 01:01:01 2021").isExactMatch());
    }

    @Test
    public void matchesZonedDoubleDigitDayAsctimeActualDate() {
        BeforeDateTimePattern matcher = WireMock.before((String)"2021-06-14T01:01:01Z");
        Assertions.assertTrue((boolean)matcher.match((Object)"Thu Jun 10 01:01:01 2021").isExactMatch());
        Assertions.assertFalse((boolean)matcher.match((Object)"Sat Jul 10 01:01:01 2021").isExactMatch());
    }

    @Test
    public void matchesNonUTCZonedISO8601ActualDate() {
        BeforeDateTimePattern matcher = WireMock.before((String)"2021-06-14T15:15:15Z");
        Assertions.assertTrue((boolean)matcher.match((Object)"2021-06-14T15:15:15+01:00[Europe/London]").isExactMatch());
        Assertions.assertFalse((boolean)matcher.match((Object)"2021-06-14T16:15:15+01:00[Europe/London]").isExactMatch());
    }

    @Test
    public void matchesActualDateAccordingToSpecifiedFormat() {
        AbstractDateTimePattern matcher = WireMock.before((String)"2021-06-14").actualFormat("dd/MM/yyyy");
        Assertions.assertTrue((boolean)matcher.match((Object)"01/06/2021").isExactMatch());
        Assertions.assertFalse((boolean)matcher.match((Object)"01/07/2021").isExactMatch());
    }

    @Test
    public void matchesAgainstNow() {
        BeforeDateTimePattern matcher = WireMock.beforeNow();
        String right = ZonedDateTime.now().minusDays(2L).toString();
        Assertions.assertTrue((boolean)matcher.match((Object)right).isExactMatch());
        String wrong = ZonedDateTime.now().plusHours(4L).toString();
        Assertions.assertFalse((boolean)matcher.match((Object)wrong).isExactMatch());
    }

    @Test
    public void matchesAgainstOffsetFromNow() {
        BeforeDateTimePattern matcher = WireMock.before((String)"now -5 days");
        String right = ZonedDateTime.now().minusDays(7L).toString();
        Assertions.assertTrue((boolean)matcher.match((Object)right).isExactMatch());
        String wrong = ZonedDateTime.now().minusDays(4L).toString();
        Assertions.assertFalse((boolean)matcher.match((Object)wrong).isExactMatch());
    }

    @Test
    public void truncatesExpectedDateToSpecifiedUnit() {
        AbstractDateTimePattern matcher = WireMock.before((String)"15 days").truncateExpected(DateTimeTruncation.FIRST_DAY_OF_MONTH);
        TemporalAdjuster truncateToMonth = TemporalAdjusters.firstDayOfMonth();
        ZonedDateTime good = ZonedDateTime.now().with(truncateToMonth).plus(14L, ChronoUnit.DAYS);
        ZonedDateTime bad = ZonedDateTime.now().with(truncateToMonth).plus(16L, ChronoUnit.DAYS);
        Assertions.assertTrue((boolean)matcher.match((Object)good.toString()).isExactMatch());
        Assertions.assertFalse((boolean)matcher.match((Object)bad.toString()).isExactMatch());
    }

    @Test
    public void truncatesActualDateToSpecifiedUnit() {
        AbstractDateTimePattern matcher = WireMock.before((String)"15 days").truncateExpected(DateTimeTruncation.FIRST_DAY_OF_MONTH).truncateActual(DateTimeTruncation.LAST_DAY_OF_MONTH);
        ZonedDateTime good = ZonedDateTime.now().minusMonths(1L);
        ZonedDateTime bad = ZonedDateTime.now().with(TemporalAdjusters.lastDayOfMonth()).minusDays(1L);
        Assertions.assertTrue((boolean)matcher.match((Object)good.toString()).isExactMatch());
        Assertions.assertFalse((boolean)matcher.match((Object)bad.toString()).isExactMatch());
    }

    @Test
    public void serialisesLiteralDateTimeAndFormatFormToJson() {
        AbstractDateTimePattern matcher = WireMock.before((String)"2021-06-01T00:00:00").actualFormat("dd/MM/yyyy");
        MatcherAssert.assertThat((Object)Json.write((Object)matcher), (Matcher)JsonMatchers.jsonEquals((Object)"{\n  \"before\": \"2021-06-01T00:00:00\",\n  \"actualFormat\": \"dd/MM/yyyy\"\n}"));
    }

    @Test
    public void serialisesOffsetWithActualTruncationFormToJson() {
        AbstractDateTimePattern matcher = WireMock.beforeNow().expectedOffset(15, DateTimeUnit.DAYS).truncateActual(DateTimeTruncation.FIRST_DAY_OF_MONTH);
        MatcherAssert.assertThat((Object)Json.write((Object)matcher), (Matcher)JsonMatchers.jsonEquals((Object)"{\n  \"before\": \"now +15 days\",\n  \"truncateActual\": \"first day of month\"\n}"));
    }

    @Test
    public void serialisesOffsetWithExpectedAndActualTruncationFormToJson() {
        AbstractDateTimePattern matcher = WireMock.beforeNow().expectedOffset(15, DateTimeUnit.DAYS).truncateExpected(DateTimeTruncation.FIRST_HOUR_OF_DAY).truncateActual(DateTimeTruncation.FIRST_DAY_OF_MONTH);
        MatcherAssert.assertThat((Object)Json.write((Object)matcher), (Matcher)JsonMatchers.jsonEquals((Object)"{\n  \"before\": \"now +15 days\",\n  \"truncateExpected\": \"first hour of day\",\n  \"truncateActual\": \"first day of month\"\n}"));
    }

    @Test
    public void deserialisesLiteralDateAndTimeWithFormatFromJson() {
        BeforeDateTimePattern matcher = (BeforeDateTimePattern)Json.read((String)"{\n  \"before\": \"2021-06-15T00:00:00\",\n  \"actualFormat\": \"dd/MM/yyyy\"\n}", BeforeDateTimePattern.class);
        MatcherAssert.assertThat((Object)matcher.getExpected(), (Matcher)Matchers.is((Object)"2021-06-15T00:00:00"));
        MatcherAssert.assertThat((Object)matcher.getActualFormat(), (Matcher)Matchers.is((Object)"dd/MM/yyyy"));
    }

    @Test
    public void deserialisesPositiveOffsetAndTruncateFormFromJson() {
        BeforeDateTimePattern matcher = (BeforeDateTimePattern)Json.read((String)"{\n  \"before\": \"15 days\",\n  \"truncateActual\": \"first day of year\"\n}", BeforeDateTimePattern.class);
        MatcherAssert.assertThat((Object)matcher.getTruncateExpected(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)matcher.getTruncateActual(), (Matcher)Matchers.is((Object)"first day of year"));
    }

    @Test
    public void deserialisesNegativeOffsetFormFromJson() {
        StringValuePattern matcher = (StringValuePattern)Json.read((String)"{\n  \"before\": \"-15 days\"\n}", BeforeDateTimePattern.class);
        ZonedDateTime good = ZonedDateTime.now().minus(16L, ChronoUnit.DAYS);
        ZonedDateTime bad = ZonedDateTime.now().minus(14L, ChronoUnit.DAYS);
        Assertions.assertTrue((boolean)matcher.match((Object)good.toString()).isExactMatch());
        Assertions.assertFalse((boolean)matcher.match((Object)bad.toString()).isExactMatch());
    }

    @Test
    public void deserialisesOffsetWithSeparateAmountAndUnitAttributesFromJson() {
        BeforeDateTimePattern matcher = (BeforeDateTimePattern)Json.read((String)"{\n  \"before\": \"now\",\n  \"expectedOffset\": -15,\n  \"expectedOffsetUnit\": \"days\"\n}\n", BeforeDateTimePattern.class);
        ZonedDateTime good = ZonedDateTime.now().minus(16L, ChronoUnit.DAYS);
        ZonedDateTime bad = ZonedDateTime.now().minus(14L, ChronoUnit.DAYS);
        Assertions.assertTrue((boolean)matcher.match(good.toString()).isExactMatch());
        Assertions.assertFalse((boolean)matcher.match(bad.toString()).isExactMatch());
    }

    @Test
    public void acceptsJavaZonedDateTimeAsExpected() {
        BeforeDateTimePattern matcher = WireMock.before((ZonedDateTime)ZonedDateTime.parse("2020-08-29T00:00:00Z"));
        Assertions.assertTrue((boolean)matcher.match("2019-01-01T00:00:00Z").isExactMatch());
    }

    @Test
    public void acceptsJavaLocalDateTimeAsExpected() {
        BeforeDateTimePattern matcher = WireMock.before((LocalDateTime)LocalDateTime.parse("2020-08-29T00:00:00"));
        Assertions.assertTrue((boolean)matcher.match("2019-01-01T00:00:00").isExactMatch());
    }

    @Test
    public void objectsShouldBeEqualOnSameExpectedValue() {
        BeforeDateTimePattern a = WireMock.before((LocalDateTime)LocalDateTime.parse("2020-08-29T00:00:00"));
        BeforeDateTimePattern b = WireMock.before((LocalDateTime)LocalDateTime.parse("2020-08-29T00:00:00"));
        BeforeDateTimePattern c = WireMock.before((LocalDateTime)LocalDateTime.parse("2022-01-01T10:10:10"));
        Assertions.assertEquals((Object)a, (Object)b);
        Assertions.assertEquals((int)a.hashCode(), (int)b.hashCode());
        Assertions.assertEquals((Object)b, (Object)a);
        Assertions.assertEquals((int)b.hashCode(), (int)a.hashCode());
        Assertions.assertNotEquals((Object)a, (Object)c);
        Assertions.assertNotEquals((int)a.hashCode(), (int)c.hashCode());
        Assertions.assertNotEquals((Object)b, (Object)c);
        Assertions.assertNotEquals((int)b.hashCode(), (int)c.hashCode());
    }
}

