/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.DateTimeOffset;
import com.github.tomakehurst.wiremock.common.DateTimeTruncation;
import com.github.tomakehurst.wiremock.common.DateTimeUnit;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.matching.AbstractDateTimePattern;
import com.github.tomakehurst.wiremock.matching.AfterDateTimePattern;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import net.javacrumbs.jsonunit.JsonMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AfterDateTimePatternTest {
    @Test
    public void matchesZonedToZoned() {
        AfterDateTimePattern matcher = WireMock.after((String)"2021-06-14T12:13:14Z");
        Assertions.assertTrue((boolean)matcher.match((Object)"2022-06-14T12:13:14Z").isExactMatch());
        Assertions.assertFalse((boolean)matcher.match((Object)"2020-06-14T12:13:14Z").isExactMatch());
    }

    @Test
    public void matchesLocalToLocal() {
        AfterDateTimePattern matcher = WireMock.after((String)"2021-06-14T12:13:14");
        Assertions.assertTrue((boolean)matcher.match((Object)"2022-06-14T12:13:14").isExactMatch());
        Assertions.assertFalse((boolean)matcher.match((Object)"2020-06-14T12:13:14").isExactMatch());
    }

    @Test
    public void matchesLocalToZoned() {
        AfterDateTimePattern matcher = WireMock.after((String)"2021-06-14T12:13:14");
        Assertions.assertTrue((boolean)matcher.match((Object)"2022-06-14T12:13:14Z").isExactMatch());
        Assertions.assertFalse((boolean)matcher.match((Object)"2020-06-14T12:13:14Z").isExactMatch());
    }

    @Test
    public void matchesZonedExpectedWithLocalActual() {
        AfterDateTimePattern matcher = WireMock.after((String)"2021-06-14T15:15:15Z");
        Assertions.assertTrue((boolean)matcher.match((Object)"2021-07-01T23:59:59").isExactMatch());
        Assertions.assertFalse((boolean)matcher.match((Object)"2021-06-01T15:15:15").isExactMatch());
    }

    @Test
    public void matchesZonedToNowOffset() {
        AbstractDateTimePattern matcher = WireMock.afterNow().expectedOffset(27, DateTimeUnit.MINUTES);
        ZonedDateTime good = ZonedDateTime.now().plusHours(1L);
        ZonedDateTime bad = ZonedDateTime.now().minusMinutes(1L);
        Assertions.assertTrue((boolean)matcher.match((Object)good.toString()).isExactMatch());
        Assertions.assertFalse((boolean)matcher.match((Object)bad.toString()).isExactMatch());
    }

    @Test
    public void matchesNowWithExpectedAndActualTruncated() {
        AbstractDateTimePattern matcher = WireMock.afterNow().truncateExpected(DateTimeTruncation.FIRST_DAY_OF_MONTH).truncateActual(DateTimeTruncation.LAST_DAY_OF_MONTH);
        ZonedDateTime good = ZonedDateTime.now();
        ZonedDateTime bad = ZonedDateTime.now().minusMonths(1L).minusHours(1L);
        Assertions.assertTrue((boolean)matcher.match((Object)good.toString()).isExactMatch());
        Assertions.assertFalse((boolean)matcher.match((Object)bad.toString()).isExactMatch());
    }

    @Test
    public void doesNotMatchWhenActualValueIsNull() {
        AfterDateTimePattern matcher = WireMock.after((String)"2021-06-14T15:15:15Z");
        Assertions.assertFalse((boolean)matcher.match(null).isExactMatch());
    }

    @Test
    public void returnsAReasonableDistanceWhenNoMatchForLocalExpectedZonedActual() {
        AfterDateTimePattern matcher = WireMock.after((String)"2021-01-01T00:00:00Z");
        MatcherAssert.assertThat((Object)matcher.match((Object)"1971-01-01T00:00:00Z").getDistance(), (Matcher)Matchers.is((Object)0.5));
        MatcherAssert.assertThat((Object)matcher.match((Object)"1921-01-01T00:00:00Z").getDistance(), (Matcher)Matchers.is((Object)1.0));
        MatcherAssert.assertThat((Object)matcher.match(null).getDistance(), (Matcher)Matchers.is((Object)1.0));
        MatcherAssert.assertThat((Object)matcher.match((Object)"2020-01-01T00:00:00Z").getDistance(), (Matcher)Matchers.is((Object)0.01));
    }

    @Test
    public void serialisesToJson() {
        AfterDateTimePattern matcher = (AfterDateTimePattern)WireMock.afterNow().expectedOffset(DateTimeOffset.fromString((String)"now -5 days")).truncateExpected(DateTimeTruncation.LAST_DAY_OF_MONTH).truncateActual(DateTimeTruncation.FIRST_DAY_OF_YEAR);
        MatcherAssert.assertThat((Object)Json.write((Object)matcher), (Matcher)JsonMatchers.jsonEquals((Object)"{\n  \"after\": \"now -5 days\",\n  \"truncateExpected\": \"last day of month\",\n  \"truncateActual\": \"first day of year\"\n}"));
    }

    @Test
    public void deserialisesFromJson() {
        AfterDateTimePattern matcher = (AfterDateTimePattern)Json.read((String)"{\n  \"after\": \"now\",\n  \"truncateExpected\": \"first hour of day\",\n  \"truncateActual\": \"last day of year\"\n}", AfterDateTimePattern.class);
        MatcherAssert.assertThat((Object)matcher.getExpected(), (Matcher)Matchers.is((Object)"now +0 seconds"));
        MatcherAssert.assertThat((Object)matcher.getTruncateExpected(), (Matcher)Matchers.is((Object)"first hour of day"));
        MatcherAssert.assertThat((Object)matcher.getTruncateActual(), (Matcher)Matchers.is((Object)"last day of year"));
    }

    @Test
    public void deserialisesOffsetWithSeparateAmountAndUnitAttributesFromJson() {
        AfterDateTimePattern matcher = (AfterDateTimePattern)Json.read((String)"{\n  \"after\": \"now\",\n  \"expectedOffset\": -15,\n  \"expectedOffsetUnit\": \"days\"\n}\n", AfterDateTimePattern.class);
        ZonedDateTime good = ZonedDateTime.now().minus(14L, ChronoUnit.DAYS);
        ZonedDateTime bad = ZonedDateTime.now().minus(16L, ChronoUnit.DAYS);
        Assertions.assertTrue((boolean)matcher.match(good.toString()).isExactMatch());
        Assertions.assertFalse((boolean)matcher.match(bad.toString()).isExactMatch());
    }

    @Test
    public void acceptsJavaZonedDateTimeAsExpected() {
        AfterDateTimePattern matcher = WireMock.after((ZonedDateTime)ZonedDateTime.parse("2020-08-29T00:00:00Z"));
        Assertions.assertTrue((boolean)matcher.match("2021-01-01T00:00:00Z").isExactMatch());
    }

    @Test
    public void acceptsJavaLocalDateTimeAsExpected() {
        AfterDateTimePattern matcher = WireMock.after((LocalDateTime)LocalDateTime.parse("2020-08-29T00:00:00"));
        Assertions.assertTrue((boolean)matcher.match("2021-01-01T00:00:00").isExactMatch());
    }

    @Test
    public void objectsShouldBeEqualOnSameExpectedValue() {
        AfterDateTimePattern a = WireMock.after((LocalDateTime)LocalDateTime.parse("2020-08-29T00:00:00"));
        AfterDateTimePattern b = WireMock.after((LocalDateTime)LocalDateTime.parse("2020-08-29T00:00:00"));
        AfterDateTimePattern c = WireMock.after((LocalDateTime)LocalDateTime.parse("2022-01-01T10:10:10"));
        Assertions.assertEquals((Object)a, (Object)b);
        Assertions.assertEquals((int)a.hashCode(), (int)b.hashCode());
        Assertions.assertEquals((Object)b, (Object)a);
        Assertions.assertEquals((int)b.hashCode(), (int)a.hashCode());
        Assertions.assertNotEquals((Object)a, (Object)c);
        Assertions.assertNotEquals((int)a.hashCode(), (int)c.hashCode());
        Assertions.assertNotEquals((Object)b, (Object)c);
        Assertions.assertNotEquals((int)b.hashCode(), (int)c.hashCode());
    }
}

