/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.matching.AbsentPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AbsentPatternTest {
    @Test
    public void correctlyDeserializesFromJson() {
        StringValuePattern stringValuePattern = (StringValuePattern)Json.read((String)"{                             \n  \"absent\": \"(absent)\"    \n}", StringValuePattern.class);
        MatcherAssert.assertThat((Object)stringValuePattern, (Matcher)Matchers.instanceOf(AbsentPattern.class));
        MatcherAssert.assertThat((Object)stringValuePattern.isAbsent(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void objectsShouldBeEqualOnSameExpectedValue() {
        AbsentPattern a = new AbsentPattern("someString");
        AbsentPattern b = new AbsentPattern("someString");
        AbsentPattern c = new AbsentPattern("someOtherString");
        Assertions.assertEquals((Object)a, (Object)b);
        Assertions.assertEquals((int)a.hashCode(), (int)b.hashCode());
        Assertions.assertEquals((Object)b, (Object)a);
        Assertions.assertEquals((int)b.hashCode(), (int)a.hashCode());
        Assertions.assertNotEquals((Object)a, (Object)c);
        Assertions.assertNotEquals((int)a.hashCode(), (int)c.hashCode());
        Assertions.assertNotEquals((Object)b, (Object)c);
        Assertions.assertNotEquals((int)b.hashCode(), (int)c.hashCode());
    }
}

