/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.junit5;

import com.github.tomakehurst.wiremock.client.VerificationException;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import java.util.Optional;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.mockito.Mockito;

public class JUnitJupiterExtensionFailOnUnmatchedTest {
    CloseableHttpClient client;
    ExtensionContext extensionContext;

    @BeforeEach
    void init() {
        this.client = HttpClientFactory.createClient();
        this.extensionContext = (ExtensionContext)Mockito.mock(ExtensionContext.class);
        Mockito.when((Object)this.extensionContext.getElement()).thenReturn(Optional.empty());
    }

    @Test
    void throws_a_verification_exception_when_an_unmatched_request_is_made_during_the_test() throws Exception {
        WireMockExtension extension = WireMockExtension.newInstance().failOnUnmatchedRequests(true).build();
        extension.beforeEach(this.extensionContext);
        extension.stubFor(WireMock.get((String)"/found").willReturn(WireMock.ok()));
        try (CloseableHttpResponse response = this.client.execute((ClassicHttpRequest)new HttpGet(extension.url("/not-found")));){
            MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)404));
        }
        Assertions.assertThrows(VerificationException.class, () -> extension.afterEach(this.extensionContext));
    }

    @Test
    void does_not_throw_a_verification_exception_when_fail_on_unmatched_disabled() throws Exception {
        WireMockExtension extension = WireMockExtension.newInstance().failOnUnmatchedRequests(false).build();
        extension.beforeEach(this.extensionContext);
        extension.stubFor(WireMock.get((String)"/found").willReturn(WireMock.ok()));
        try (CloseableHttpResponse response = this.client.execute((ClassicHttpRequest)new HttpGet(extension.url("/not-found")));){
            MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)404));
        }
        Assertions.assertDoesNotThrow(() -> extension.afterEach(this.extensionContext));
    }
}

