/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty11;

import com.github.tomakehurst.wiremock.admin.AdminRoutes;
import com.github.tomakehurst.wiremock.common.DataTruncationSettings;
import com.github.tomakehurst.wiremock.common.Limit;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.StubServer;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extensions;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.BasicResponseRenderer;
import com.github.tomakehurst.wiremock.http.ResponseRenderer;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.jetty.JettyHttpServer;
import com.github.tomakehurst.wiremock.jetty.JettyHttpServerFactory;
import com.github.tomakehurst.wiremock.security.Authenticator;
import com.github.tomakehurst.wiremock.security.NoAuthenticator;
import com.github.tomakehurst.wiremock.verification.RequestJournal;
import com.github.tomakehurst.wiremock.verification.notmatched.NotMatchedRenderer;
import com.github.tomakehurst.wiremock.verification.notmatched.PlainTextStubNotMatchedRenderer;
import java.lang.reflect.Field;
import java.util.Collections;
import org.eclipse.jetty.server.ServerConnector;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class JettyHttpServerTest {
    static final DataTruncationSettings NO_TRUNCATION = new DataTruncationSettings(Limit.UNLIMITED);
    private AdminRequestHandler adminRequestHandler;
    private StubRequestHandler stubRequestHandler;
    private JettyHttpServerFactory serverFactory = new JettyHttpServerFactory();

    @BeforeEach
    public void init() {
        Admin admin = (Admin)Mockito.mock(Admin.class);
        this.adminRequestHandler = new AdminRequestHandler(AdminRoutes.forClient(), admin, (ResponseRenderer)new BasicResponseRenderer(), (Authenticator)new NoAuthenticator(), false, Collections.emptyList(), Collections.emptyList(), NO_TRUNCATION);
        this.stubRequestHandler = new StubRequestHandler((StubServer)Mockito.mock(StubServer.class), (ResponseRenderer)Mockito.mock(ResponseRenderer.class), admin, Collections.emptyMap(), Collections.emptyMap(), (RequestJournal)Mockito.mock(RequestJournal.class), Collections.emptyList(), Collections.emptyList(), false, NO_TRUNCATION, (NotMatchedRenderer)new PlainTextStubNotMatchedRenderer(Extensions.NONE));
    }

    @Test
    public void testStopTimeout() {
        long expectedStopTimeout = 1000L;
        WireMockConfiguration config = WireMockConfiguration.wireMockConfig().jettyStopTimeout(Long.valueOf(expectedStopTimeout));
        JettyHttpServer jettyHttpServer = (JettyHttpServer)this.serverFactory.buildHttpServer((Options)config, this.adminRequestHandler, this.stubRequestHandler);
        MatcherAssert.assertThat((Object)jettyHttpServer.stopTimeout(), (Matcher)Matchers.is((Object)expectedStopTimeout));
    }

    @Test
    public void testStopTimeoutNotSet() {
        long expectedStopTimeout = 1000L;
        WireMockConfiguration config = WireMockConfiguration.wireMockConfig();
        JettyHttpServer jettyHttpServer = (JettyHttpServer)this.serverFactory.buildHttpServer((Options)config, this.adminRequestHandler, this.stubRequestHandler);
        MatcherAssert.assertThat((Object)jettyHttpServer.stopTimeout(), (Matcher)Matchers.is((Object)expectedStopTimeout));
    }

    @Test
    public void testHttpConnectorIsNullWhenHttpDisabled() throws NoSuchFieldException, IllegalAccessException {
        WireMockConfiguration config = WireMockConfiguration.wireMockConfig().httpDisabled(true);
        JettyHttpServer jettyHttpServer = (JettyHttpServer)this.serverFactory.buildHttpServer((Options)config, this.adminRequestHandler, this.stubRequestHandler);
        Field httpConnectorField = JettyHttpServer.class.getDeclaredField("httpConnector");
        httpConnectorField.setAccessible(true);
        ServerConnector httpConnector = (ServerConnector)httpConnectorField.get(jettyHttpServer);
        Assertions.assertNull((Object)httpConnector);
    }
}

