/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.extension.ResponseTransformer;
import com.github.tomakehurst.wiremock.extension.ResponseTransformerV2;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.StubResponseRenderer;
import com.github.tomakehurst.wiremock.matching.MockRequest;
import com.github.tomakehurst.wiremock.store.BlobStore;
import com.github.tomakehurst.wiremock.store.InMemorySettingsStore;
import com.github.tomakehurst.wiremock.store.SettingsStore;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.ServeEventFactory;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;

public class StubResponseRendererTest {
    private static final int TEST_TIMEOUT = 500;
    private BlobStore filesBlobStore;
    private SettingsStore settingsStore;
    private List<ResponseTransformer> responseTransformers;
    private List<ResponseTransformerV2> v2ResponseTransformers;
    private StubResponseRenderer stubResponseRenderer;

    @BeforeEach
    public void init() {
        this.filesBlobStore = (BlobStore)Mockito.mock(BlobStore.class);
        this.settingsStore = new InMemorySettingsStore();
        this.responseTransformers = new ArrayList<ResponseTransformer>();
        this.v2ResponseTransformers = new ArrayList<ResponseTransformerV2>();
        this.stubResponseRenderer = new StubResponseRenderer(this.filesBlobStore, this.settingsStore, null, this.responseTransformers, this.v2ResponseTransformers);
    }

    @Test
    @Timeout(value=500L)
    public void endpointFixedDelayShouldOverrideGlobalDelay() throws Exception {
        this.settingsStore.set(GlobalSettings.builder().fixedDelay(Integer.valueOf(1000)).build());
        Response response = this.stubResponseRenderer.render(this.createServeEvent(100));
        MatcherAssert.assertThat((Object)response.getInitialDelay(), (Matcher)Matchers.is((Object)100L));
    }

    @Test
    @Timeout(value=500L)
    public void globalFixedDelayShouldNotBeOverriddenIfNoEndpointDelaySpecified() throws Exception {
        this.settingsStore.set(GlobalSettings.builder().fixedDelay(Integer.valueOf(1000)).build());
        Response response = this.stubResponseRenderer.render(this.createServeEvent(null));
        MatcherAssert.assertThat((Object)response.getInitialDelay(), (Matcher)Matchers.is((Object)1000L));
    }

    @Test
    @Timeout(value=500L)
    public void shouldSetGlobalFixedDelayOnResponse() throws Exception {
        this.settingsStore.set(GlobalSettings.builder().fixedDelay(Integer.valueOf(1000)).build());
        Response response = this.stubResponseRenderer.render(this.createServeEvent(null));
        MatcherAssert.assertThat((Object)response.getInitialDelay(), (Matcher)Matchers.is((Object)1000L));
    }

    @Test
    public void shouldSetEndpointFixedDelayOnResponse() throws Exception {
        Response response = this.stubResponseRenderer.render(this.createServeEvent(2000));
        MatcherAssert.assertThat((Object)response.getInitialDelay(), (Matcher)Matchers.is((Object)2000L));
    }

    @Test
    @Timeout(value=500L)
    public void shouldSetEndpointDistributionDelayOnResponse() throws Exception {
        this.settingsStore.set(GlobalSettings.builder().delayDistribution(() -> 123L).build());
        Response response = this.stubResponseRenderer.render(this.createServeEvent(null));
        MatcherAssert.assertThat((Object)response.getInitialDelay(), (Matcher)Matchers.is((Object)123L));
    }

    @Test
    @Timeout(value=500L)
    public void shouldCombineFixedDelayDistributionDelay() throws Exception {
        this.settingsStore.set(GlobalSettings.builder().delayDistribution(() -> 123L).build());
        Response response = this.stubResponseRenderer.render(this.createServeEvent(2000));
        MatcherAssert.assertThat((Object)response.getInitialDelay(), (Matcher)Matchers.is((Object)2123L));
    }

    private ServeEvent createServeEvent(Integer fixedDelayMillis) {
        return ServeEventFactory.newPostMatchServeEvent((Request)MockRequest.mockRequest(), new ResponseDefinition(0, "", "", null, "", "", null, null, fixedDelayMillis, null, null, null, null, null, null, null, Boolean.valueOf(true)));
    }
}

