/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.MockRequest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;

public class ResponseDefinitionTest {
    @Test
    public void getProxyUrlGivesBackRequestUrlIfBrowserProxyRequest() {
        ResponseDefinition response = ResponseDefinition.browserProxy((Request)MockRequest.mockRequest().host("my.domain").url("/path").isBrowserProxyRequest(true));
        MatcherAssert.assertThat((Object)response.getProxyUrl(), (Matcher)CoreMatchers.equalTo((Object)"http://my.domain/path"));
    }

    @Test
    public void getProxyUrlGivesBackTheProxyUrlWhenNotBrowserProxy() {
        ResponseDefinition response = ResponseDefinitionBuilder.responseDefinition().proxiedFrom("http://my.proxy.url").build();
        response.setOriginalRequest((Request)MockRequest.mockRequest().url("/path"));
        MatcherAssert.assertThat((Object)response.getProxyUrl(), (Matcher)CoreMatchers.equalTo((Object)"http://my.proxy.url/path"));
    }

    @Test
    public void doesNotRemoveRequestPathPrefixWhenPrefixToRemoveDoesNotMatch() {
        ResponseDefinition response = ResponseDefinitionBuilder.responseDefinition().proxiedFrom("http://my.proxy.url").withProxyUrlPrefixToRemove("/no/match").build();
        response.setOriginalRequest((Request)MockRequest.mockRequest().url("/path"));
        MatcherAssert.assertThat((Object)response.getProxyUrl(), (Matcher)CoreMatchers.equalTo((Object)"http://my.proxy.url/path"));
    }

    @Test
    public void removesRequestPathPrefixWhenPrefixToRemoveMatches() {
        ResponseDefinition response = ResponseDefinitionBuilder.responseDefinition().proxiedFrom("http://my.proxy.url").withProxyUrlPrefixToRemove("/path").build();
        response.setOriginalRequest((Request)MockRequest.mockRequest().url("/path"));
        MatcherAssert.assertThat((Object)response.getProxyUrl(), (Matcher)CoreMatchers.equalTo((Object)"http://my.proxy.url"));
    }

    @Test
    public void getProxyUrlGivesBackTheProxyUrlWhenProxiedUrlBeginWithWhiteSpace() {
        ResponseDefinition response = ResponseDefinitionBuilder.responseDefinition().proxiedFrom(" http://my.proxy.url").build();
        response.setOriginalRequest((Request)MockRequest.mockRequest().url("/path"));
        MatcherAssert.assertThat((Object)response.getProxyUrl(), (Matcher)CoreMatchers.equalTo((Object)"http://my.proxy.url/path"));
    }

    @Test
    public void getProxyUrlGivesBackTheProxyUrlWhenProxiedUrlEndWithWhiteSpace() {
        ResponseDefinition response = ResponseDefinitionBuilder.responseDefinition().proxiedFrom("http://my.proxy.url ").build();
        response.setOriginalRequest((Request)MockRequest.mockRequest().url("/path"));
        MatcherAssert.assertThat((Object)response.getProxyUrl(), (Matcher)CoreMatchers.equalTo((Object)"http://my.proxy.url/path"));
    }

    @Test
    public void getProxyUrlGivesBackTheProxyUrlWhenProxiedFromUrlNull() {
        ResponseDefinition response = ResponseDefinitionBuilder.responseDefinition().build();
        response.setOriginalRequest((Request)MockRequest.mockRequest().url("/path"));
        MatcherAssert.assertThat((Object)response.getProxyUrl(), (Matcher)CoreMatchers.equalTo((Object)"null/path"));
    }
}

