/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HttpHeaderTest {
    @Test
    public void returnsIsPresentFalseWhenNoValuesPresent() {
        HttpHeader header = HttpHeader.absent((String)"Test-Header");
        MatcherAssert.assertThat((Object)header.isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void returnsIsPresentTrueWhenOneValuePresent() {
        HttpHeader header = new HttpHeader("Test-Header", new String[]{"value"});
        MatcherAssert.assertThat((Object)header.isPresent(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void returnsFirstValueWhenOneSpecified() {
        HttpHeader header = new HttpHeader("Test-Header", new String[]{"value"});
        MatcherAssert.assertThat((Object)header.firstValue(), (Matcher)Matchers.is((Object)"value"));
    }

    @Test
    public void returnsAllValuesWhenManySpecified() {
        HttpHeader header = new HttpHeader("Test-Header", new String[]{"value1", "value2", "value3"});
        MatcherAssert.assertThat((Object)header.values(), (Matcher)Matchers.hasItems((Object[])new String[]{"value1", "value2", "value3"}));
    }

    @Test
    public void correctlyIndicatesWhenHeaderContainsValue() {
        HttpHeader header = new HttpHeader("Test-Header", new String[]{"value1", "value2", "value3"});
        MatcherAssert.assertThat((Object)header.containsValue("value2"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)header.containsValue("value72727"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void throwsExceptionWhenAttemptingToAccessFirstValueWhenAbsent() {
        Assertions.assertThrows(IllegalStateException.class, () -> HttpHeader.absent((String)"Something").firstValue());
    }

    @Test
    public void throwsExceptionWhenAttemptingToAccessValuesWhenAbsent() {
        Assertions.assertThrows(IllegalStateException.class, () -> HttpHeader.absent((String)"Something").values());
    }

    @Test
    public void shouldMatchSingleValueToValuePattern() {
        HttpHeader header = new HttpHeader("My-Header", new String[]{"my-value"});
        MatcherAssert.assertThat((Object)header.hasValueMatching(WireMock.equalTo((String)"my-value")), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)header.hasValueMatching(WireMock.equalTo((String)"other-value")), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldMatchMultiValueToValuePattern() {
        HttpHeader header = new HttpHeader("My-Header", new String[]{"value1", "value2", "value3"});
        MatcherAssert.assertThat((Object)header.hasValueMatching(WireMock.matching((String)"value.*")), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)header.hasValueMatching(WireMock.equalTo((String)"value2")), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)header.hasValueMatching(WireMock.equalTo((String)"value4")), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldEqualWhenIdentical() throws Exception {
        HttpHeader header1 = new HttpHeader("My-Header", new String[]{"value1"});
        HttpHeader header2 = new HttpHeader("My-Header", new String[]{"value1"});
        MatcherAssert.assertThat((Object)header1.equals((Object)header2), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)header1.hashCode(), (Matcher)IsEqual.equalTo((Object)header2.hashCode()));
    }

    @Test
    public void shouldEqualWhenKeysHaveDifferentCases() throws Exception {
        HttpHeader header1 = new HttpHeader("MY-HEADER", new String[]{"value1", "value2"});
        HttpHeader header2 = new HttpHeader("my-header", new String[]{"value1", "value2"});
        MatcherAssert.assertThat((Object)header1.equals((Object)header2), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)header1.hashCode(), (Matcher)IsEqual.equalTo((Object)header2.hashCode()));
    }

    @Test
    public void shouldNotEqualWhenContentsAreDifferent() throws Exception {
        HttpHeader header1 = new HttpHeader("My-Header", new String[]{"value1"});
        HttpHeader header2 = new HttpHeader("My-Header", new String[]{"VALUE1"});
        MatcherAssert.assertThat((Object)header1.equals((Object)header2), (Matcher)Matchers.is((Object)false));
    }
}

