/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.common.ssl.KeyStoreSettings;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.crypto.InMemoryKeyStore;
import com.github.tomakehurst.wiremock.crypto.Secret;
import com.github.tomakehurst.wiremock.crypto.X509CertificateSpecification;
import com.github.tomakehurst.wiremock.crypto.X509CertificateVersion;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import java.io.File;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.junit.jupiter.api.AfterEach;

public abstract class HttpClientFactoryCertificateVerificationTest {
    protected static final List<String> TRUST_NOBODY = Collections.emptyList();
    protected WireMockServer server = null;
    protected CloseableHttpClient client;

    public void startServerAndBuildClient(List<String> trustedHosts, String certificateCN, boolean validCertificate) throws Exception {
        InMemoryKeyStore ks = new InMemoryKeyStore(InMemoryKeyStore.KeyStoreType.JKS, new Secret("password"));
        KeyPair keyPair = this.generateKeyPair();
        X509CertificateSpecification certificateSpecification = new X509CertificateSpecification(X509CertificateVersion.V3, "CN=" + certificateCN, "CN=wiremock.org", new Date(), new Date(System.currentTimeMillis() + 31536000000L));
        X509Certificate certificate = certificateSpecification.certificateFor(keyPair);
        ks.addPrivateKey("wiremock", keyPair, certificate);
        File serverKeyStoreFile = File.createTempFile("wiremock-server", "jks");
        ks.saveAs(serverKeyStoreFile);
        this.server = new WireMockServer((Options)WireMockConfiguration.options().httpDisabled(true).dynamicHttpsPort().keystorePath(serverKeyStoreFile.getAbsolutePath()));
        this.server.start();
        InMemoryKeyStore clientTrustStore = new InMemoryKeyStore(InMemoryKeyStore.KeyStoreType.JKS, new Secret("password"));
        if (validCertificate) {
            clientTrustStore.addCertificate("wiremock", certificate);
        }
        File clientTrustStoreFile = File.createTempFile("wiremock-client", "jks");
        clientTrustStore.saveAs(clientTrustStoreFile);
        KeyStoreSettings clientTrustStoreSettings = new KeyStoreSettings(clientTrustStoreFile.getAbsolutePath(), "password", "jks");
        this.client = HttpClientFactory.createClient((int)1000, (int)300000, (ProxySettings)ProxySettings.NO_PROXY, (KeyStoreSettings)clientTrustStoreSettings, (boolean)false, trustedHosts, (boolean)false);
    }

    @AfterEach
    public void stopServer() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    private KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(1024);
        return keyGen.generateKeyPair();
    }
}

