/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.testsupport.MockRequestBuilder;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ContentTypeHeaderTest {
    @Test
    public void returnsMimeTypeAndCharsetWhenBothPresent() {
        ContentTypeHeader header = new ContentTypeHeader("text/plain; charset=utf-8");
        MatcherAssert.assertThat((Object)header.mimeTypePart(), (Matcher)Matchers.is((Object)"text/plain"));
        Optional encoding = header.encodingPart();
        Assertions.assertTrue((boolean)encoding.isPresent());
        MatcherAssert.assertThat((Object)((String)encoding.get()), (Matcher)Matchers.is((Object)"utf-8"));
    }

    @Test
    public void returnsMimeTypeWhenNoCharsetPresent() {
        ContentTypeHeader header = new ContentTypeHeader("text/plain");
        MatcherAssert.assertThat((Object)header.mimeTypePart(), (Matcher)Matchers.is((Object)"text/plain"));
    }

    @Test
    public void returnsCharsetWhenNotFirstParameter() {
        ContentTypeHeader header = new ContentTypeHeader("text/plain; param=value; charset=utf-8");
        Optional encoding = header.encodingPart();
        Assertions.assertTrue((boolean)encoding.isPresent());
        MatcherAssert.assertThat((Object)((String)encoding.get()), (Matcher)Matchers.is((Object)"utf-8"));
    }

    @Test
    public void returnsAbsentOptionalEncodingPartWhenNotPresent() {
        ContentTypeHeader header = new ContentTypeHeader("text/plain");
        Assertions.assertFalse((boolean)header.encodingPart().isPresent());
    }

    @Test
    public void stripsDoubleQuotesFromEncodingPart() {
        ContentTypeHeader header = new ContentTypeHeader("application/json;charset=\"UTF-8\"");
        Optional encoding = header.encodingPart();
        Assertions.assertTrue((boolean)encoding.isPresent());
        MatcherAssert.assertThat((Object)((String)encoding.get()), (Matcher)Matchers.is((Object)"UTF-8"));
    }

    @Test
    public void fetchesFromRequest() {
        Request request = new MockRequestBuilder().withHeader("Content-Type", "text/xml").build();
        ContentTypeHeader contentTypeHeader = request.contentTypeHeader();
        MatcherAssert.assertThat((Object)contentTypeHeader.mimeTypePart(), (Matcher)Matchers.is((Object)"text/xml"));
    }

    @Test
    public void throwsExceptionOnAttemptToSetNullHeaderValue() {
        Assertions.assertThrows(NullPointerException.class, () -> new MockRequestBuilder().withHeader("Content-Type", null).build());
    }

    @Test
    public void returnsNullFromMimeTypePartWhenContentTypeIsAbsent() {
        ContentTypeHeader header = ContentTypeHeader.absent();
        MatcherAssert.assertThat((Object)header.mimeTypePart(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void returnsCharsetWhenPresent() {
        ContentTypeHeader header = new ContentTypeHeader("text/plain; charset=iso-8859-1");
        MatcherAssert.assertThat((Object)header.charset(), (Matcher)Matchers.is((Object)StandardCharsets.ISO_8859_1));
    }

    @Test
    public void returnsDefaultCharsetWhenEncodingNotPresent() {
        ContentTypeHeader header = new ContentTypeHeader("text/plain");
        MatcherAssert.assertThat((Object)header.charset(), (Matcher)Matchers.is((Object)Strings.DEFAULT_CHARSET));
    }

    @Test
    public void returnsDefaultCharsetWhenAbsent() {
        ContentTypeHeader header = ContentTypeHeader.absent();
        MatcherAssert.assertThat((Object)header.charset(), (Matcher)Matchers.is((Object)Strings.DEFAULT_CHARSET));
    }
}

