/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.jknack.handlebars.Options;
import com.github.tomakehurst.wiremock.common.ConsoleNotifier;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.extension.responsetemplating.SystemKeyAuthoriser;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.SystemValueHelper;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SystemValueHelperTest {
    private SystemValueHelper helper;

    @BeforeEach
    public void init() {
        this.helper = new SystemValueHelper(new SystemKeyAuthoriser(Set.of(".*")));
        LocalNotifier.set((Notifier)new ConsoleNotifier(true));
    }

    @Test
    public void getExistingEnvironmentVariableShouldNotNull() throws Exception {
        Map<String, Object> optionsHash = Map.of("key", "PATH", "type", "ENVIRONMENT");
        String output = this.render(optionsHash);
        Assertions.assertNotNull((Object)output);
        Assertions.assertTrue((output.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void getNonExistingEnvironmentVariableShouldNull() throws Exception {
        Map<String, Object> optionsHash = Map.of("key", "NON_EXISTING_VAR", "type", "ENVIRONMENT");
        String output = this.render(optionsHash);
        Assertions.assertNull((Object)output);
    }

    @Test
    public void getForbiddenEnvironmentVariableShouldReturnError() throws Exception {
        this.helper = new SystemValueHelper(new SystemKeyAuthoriser(Set.of("JAVA*")));
        Map<String, Object> optionsHash = Map.of("key", "TEST_VAR", "type", "ENVIRONMENT");
        String value = this.render(optionsHash);
        Assertions.assertEquals((Object)"[ERROR: Access to TEST_VAR is denied]", (Object)value);
    }

    @Test
    public void getEmptyKeyShouldReturnError() throws Exception {
        Map<String, Object> optionsHash = Map.of("key", "", "type", "PROPERTY");
        String value = this.render(optionsHash);
        Assertions.assertEquals((Object)"[ERROR: The key cannot be empty]", (Object)value);
    }

    @Test
    public void getAllowedPropertyShouldSuccess() throws Exception {
        this.helper = new SystemValueHelper(new SystemKeyAuthoriser(Set.of("test.*")));
        System.setProperty("test.key", "aaa");
        Assertions.assertEquals((Object)"aaa", (Object)System.getProperty("test.key"));
        Map<String, Object> optionsHash = Map.of("key", "test.key", "type", "PROPERTY");
        String value = this.render(optionsHash);
        Assertions.assertEquals((Object)"aaa", (Object)value);
    }

    @Test
    public void getForbiddenPropertyShouldReturnError() throws Exception {
        this.helper = new SystemValueHelper(new SystemKeyAuthoriser(Set.of("JAVA.*")));
        System.setProperty("test.key", "aaa");
        Map<String, Object> optionsHash = Map.of("key", "test.key", "type", "PROPERTY");
        String value = this.render(optionsHash);
        Assertions.assertEquals((Object)"[ERROR: Access to test.key is denied]", (Object)value);
    }

    @Test
    public void getNonExistingSystemPropertyShouldNull() throws Exception {
        Map<String, Object> optionsHash = Map.of("key", "not.existing.prop", "type", "PROPERTY");
        String output = this.render(optionsHash);
        Assertions.assertNull((Object)output);
    }

    private String render(Map<String, Object> optionsHash) throws IOException {
        return this.helper.apply(null, new Options.Builder(null, null, null, null, null).setHash(optionsHash).build());
    }
}

