/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.TagType;
import com.github.jknack.handlebars.Template;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelperTestBase;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.ParseJsonHelper;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ParseJsonHelperTest
extends HandlebarsHelperTestBase {
    private ParseJsonHelper helper;

    @BeforeEach
    public void init() {
        this.helper = new ParseJsonHelper();
    }

    @Test
    public void parsesASimpleJsonObject() throws Exception {
        String inputJson = "{\"testKey1\": \"val1\", \"testKey2\": \"val2\"}";
        Object output = this.render(inputJson, new Object[0], TagType.VAR);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.instanceOf(Map.class));
        Map result = (Map)output;
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.aMapWithSize((int)2));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.hasEntry((Object)"testKey1", (Object)"val1"));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.hasEntry((Object)"testKey2", (Object)"val2"));
    }

    @Test
    public void parsesAJsonObjectContainingArray() throws Exception {
        String inputJson = "{\"arr\": [\"one\", \"two\", \"three\"]}";
        Object output = this.render(inputJson, new Object[0], TagType.VAR);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.instanceOf(Map.class));
        Map result = (Map)output;
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.aMapWithSize((int)1));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.hasKey((Object)"arr"));
        MatcherAssert.assertThat(result.get("arr"), (Matcher)Matchers.instanceOf(List.class));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.hasEntry((Object)"arr", Arrays.asList("one", "two", "three")));
    }

    @Test
    public void parseANestedJsonObject() throws Exception {
        String inputJson = "{\"parent\": {\"child\": \"val\"}}";
        Object output = this.render(inputJson, new Object[0], TagType.VAR);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.instanceOf(Map.class));
        Map result = (Map)output;
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.aMapWithSize((int)1));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.hasKey((Object)"parent"));
        MatcherAssert.assertThat(result.get("parent"), (Matcher)Matchers.instanceOf(Map.class));
        Map parent = (Map)result.get("parent");
        MatcherAssert.assertThat((Object)parent, (Matcher)Matchers.hasEntry((Object)"child", (Object)"val"));
    }

    @Test
    public void parsesJsonWithTopLevelArray() throws Exception {
        String inputJson = "[{\"key\": \"val\"}]";
        Object output = this.render(inputJson, new Object[0], TagType.VAR);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.instanceOf(List.class));
        List result = (List)output;
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(result.get(0), (Matcher)Matchers.instanceOf(Map.class));
        Map inner = (Map)result.get(0);
        MatcherAssert.assertThat((Object)inner, (Matcher)Matchers.hasEntry((Object)"key", (Object)"val"));
    }

    @Test
    public void parsesNullJsonIfSection() throws Exception {
        Object inputJson = null;
        Object output = this.render(inputJson, new Object[0], TagType.SECTION);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.instanceOf(Map.class));
        Map result = (Map)output;
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.aMapWithSize((int)0));
    }

    @Test
    public void parsesNullJsonIfNotSection() throws Exception {
        Object inputJson = null;
        Object output = this.render(inputJson, new Object[0], TagType.VAR);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.instanceOf(Map.class));
        Map result = (Map)output;
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.aMapWithSize((int)0));
    }

    @Test
    public void parsesEmptyJsonIfSection() throws Exception {
        String inputJson = "{}";
        Object output = this.render(inputJson, new Object[0], TagType.SECTION);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.instanceOf(Map.class));
        Map result = (Map)output;
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.aMapWithSize((int)0));
    }

    @Test
    public void parsesEmptyJsonIfNotSection() throws Exception {
        String inputJson = "{}";
        Object output = this.render(inputJson, new Object[0], TagType.VAR);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.instanceOf(Map.class));
        Map result = (Map)output;
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.aMapWithSize((int)0));
    }

    private Object render(Object context, Object[] params, TagType tagType) throws IOException {
        return this.helper.apply(context, new Options.Builder(null, null, tagType, this.createContext(), Template.EMPTY).setParams(params).build());
    }
}

