/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelperTestBase;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.MathsHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.RenderableDate;
import java.util.Date;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MathsHelperTest
extends HandlebarsHelperTestBase {
    MathsHelper helper;

    @BeforeEach
    public void init() {
        this.helper = new MathsHelper();
    }

    @Test
    public void returnsAnErrorIfNotExactlyTwoParameters() throws Exception {
        String expectedError = "[ERROR: All maths functions require two operands and an operator as parameters e.g. 3 '+' 2]";
        MatcherAssert.assertThat((Object)((String)this.renderHelperValue(this.helper, 5, new Object[]{"+"})), (Matcher)Matchers.is((Object)expectedError));
        MatcherAssert.assertThat((Object)((String)this.renderHelperValue(this.helper, 5, new Object[]{"+", "6", true, 1})), (Matcher)Matchers.is((Object)expectedError));
        MatcherAssert.assertThat((Object)((String)this.renderHelperValue(this.helper, 5, new Object[0])), (Matcher)Matchers.is((Object)expectedError));
    }

    @Test
    public void returnsAnErrorIfOperatorNotRecognised() throws Exception {
        MatcherAssert.assertThat((Object)((String)this.renderHelperValue(this.helper, 2, new Object[]{"&", 3})), (Matcher)Matchers.is((Object)"[ERROR: & is not a valid mathematical operator]"));
    }

    @Test
    public void addsTwoIntegers() throws Exception {
        MatcherAssert.assertThat((Object)((Integer)this.renderHelperValue(this.helper, 2, new Object[]{"+", 3})), (Matcher)Matchers.is((Object)5));
    }

    @Test
    public void addsTwoLongs() throws Exception {
        long left = 0x80000000L;
        long right = 0x80000000L;
        long expected = 0x100000000L;
        MatcherAssert.assertThat((Object)((Long)this.renderHelperValue(this.helper, left, new Object[]{"+", right})), (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void addsAStringAndInteger() throws Exception {
        MatcherAssert.assertThat((Object)((Integer)this.renderHelperValue(this.helper, "2", new Object[]{"+", 3})), (Matcher)Matchers.is((Object)5));
    }

    @Test
    public void addsADoubleAndInteger() throws Exception {
        MatcherAssert.assertThat((Object)((Double)this.renderHelperValue(this.helper, 0.5, new Object[]{"+", 3})), (Matcher)Matchers.is((Object)3.5));
    }

    @Test
    public void addsAStringDoubleAndDouble() throws Exception {
        MatcherAssert.assertThat((Object)((Double)this.renderHelperValue(this.helper, "0.25", new Object[]{"+", "0.34"})), (Matcher)Matchers.is((Object)0.59));
    }

    @Test
    public void addsADoubleAndFloat() throws Exception {
        MatcherAssert.assertThat((Object)((Double)this.renderHelperValue(this.helper, Float.valueOf(0.25f), new Object[]{"+", Float.valueOf(0.34f)})), (Matcher)Matchers.closeTo((double)0.59, (double)0.01));
    }

    @Test
    public void subtractsTwoIntegers() throws Exception {
        MatcherAssert.assertThat((Object)((Integer)this.renderHelperValue(this.helper, 10, new Object[]{"-", 3})), (Matcher)Matchers.is((Object)7));
    }

    @Test
    public void multipliesTwoIntegers() throws Exception {
        MatcherAssert.assertThat((Object)((Integer)this.renderHelperValue(this.helper, 10, new Object[]{"*", 3})), (Matcher)Matchers.is((Object)30));
        MatcherAssert.assertThat((Object)((Integer)this.renderHelperValue(this.helper, 10, new Object[]{"x", 3})), (Matcher)Matchers.is((Object)30));
    }

    @Test
    public void dividesTwoIntegers() throws Exception {
        MatcherAssert.assertThat((Object)((Integer)this.renderHelperValue(this.helper, 15, new Object[]{"/", 3})), (Matcher)Matchers.is((Object)5));
    }

    @Test
    public void modsTwoIntegers() throws Exception {
        MatcherAssert.assertThat((Object)((Integer)this.renderHelperValue(this.helper, 11, new Object[]{"%", 3})), (Matcher)Matchers.is((Object)2));
    }

    @Test
    void coercesEpochFormattedRenderableDateParameterCorrectly() throws Exception {
        Date date = new Date(1663258226792L);
        MatcherAssert.assertThat((Object)((Long)this.renderHelperValue(this.helper, new RenderableDate(date, "epoch", null), new Object[]{"+", 0})), (Matcher)Matchers.is((Object)1663258226792L));
    }
}

