/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.extension.ResponseDefinitionTransformerV2;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelperTestBase;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsXPathHelper;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.MockRequest;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class HandlebarsXPathHelperTest
extends HandlebarsHelperTestBase {
    private HandlebarsXPathHelper helper;

    @BeforeEach
    public void init() {
        this.helper = new HandlebarsXPathHelper();
    }

    @Test
    public void rendersASimpleValue() {
        ResponseDefinition responseDefinition = HandlebarsXPathHelperTest.transform((ResponseDefinitionTransformerV2)this.transformer, MockRequest.mockRequest().url("/xml").body("<a><test>success</test></a>"), WireMock.aResponse().withBody("<test>{{xPath request.body '/a/test/text()'}}</test>"));
        MatcherAssert.assertThat((Object)responseDefinition.getBody(), (Matcher)Matchers.is((Object)"<test>success</test>"));
    }

    @Test
    public void rendersNothingWhenTheXPathExpressionResolvesNoContent() {
        ResponseDefinition responseDefinition = HandlebarsXPathHelperTest.transform((ResponseDefinitionTransformerV2)this.transformer, MockRequest.mockRequest().url("/xml").body("<a><test>success</test></a>"), WireMock.aResponse().withBody("<test>{{xPath request.body '/b/test'}}</test>"));
        MatcherAssert.assertThat((Object)responseDefinition.getBody(), (Matcher)Matchers.startsWith((String)"<test></test>"));
    }

    @Test
    public void extractsASimpleValue() throws IOException {
        this.testHelper(this.helper, "<test>success</test>", "/test/text()", "success");
    }

    @Test
    public void extractsAnAttribute() throws IOException {
        this.testHelper(this.helper, "<test outcome=\"success\"/>", "/test/@outcome", "success");
    }

    @Test
    public void extractsASubElement() throws IOException {
        this.testHelper(this.helper, "<outer>\n    <inner>stuff</inner>\n</outer>", "/outer/inner", WireMatchers.equalToXml("<inner>stuff</inner>"));
    }

    @Test
    public void rendersAMeaningfulErrorWhenTheInputXmlIsInvalid() {
        this.testHelperError(this.helper, "<testsuccess</test>", "/test", (Matcher<String>)Matchers.is((Object)"[ERROR: <testsuccess</test> is not valid XML]"));
    }

    @Test
    public void rendersAMeaningfulErrorWhenTheXPathExpressionIsInvalid() {
        this.testHelperError(this.helper, "<test>success</test>", "/\\test", (Matcher<String>)Matchers.is((Object)"[ERROR: /\\test is not a valid XPath expression]"));
    }

    @Test
    public void rendersAMeaningfulErrorWhenTheXPathExpressionIsAbsent() {
        this.testHelperError(this.helper, "<test>success</test>", (String)null, (Matcher<String>)Matchers.is((Object)"[ERROR: The XPath expression cannot be empty]"));
    }

    @Test
    public void rendersABlankWhenTheInputXmlIsAbsent() {
        this.testHelperError(this.helper, null, "/test", (Matcher<String>)Matchers.is((Object)""));
    }

    @Test
    public void returnsCorrectResultWhenSameExpressionUsedTwiceOnIdenticalDocuments() throws Exception {
        String one = this.renderHelperValue(this.helper, "<test>one</test>", new Object[]{"/test/text()"}).toString();
        String two = this.renderHelperValue(this.helper, "<test>one</test>", new Object[]{"/test/text()"}).toString();
        MatcherAssert.assertThat((Object)one, (Matcher)Matchers.is((Object)"one"));
        MatcherAssert.assertThat((Object)two, (Matcher)Matchers.is((Object)"one"));
    }

    @Test
    public void returnsCorrectResultWhenSameExpressionUsedTwiceOnDifferentDocuments() throws Exception {
        String one = this.renderHelperValue(this.helper, "<test>one</test>", new Object[]{"/test/text()"}).toString();
        String two = this.renderHelperValue(this.helper, "<test>two</test>", new Object[]{"/test/text()"}).toString();
        MatcherAssert.assertThat((Object)one, (Matcher)Matchers.is((Object)"one"));
        MatcherAssert.assertThat((Object)two, (Matcher)Matchers.is((Object)"two"));
    }

    @Test
    public void returnsCorrectResultWhenDifferentExpressionsUsedOnSameDocument() throws Exception {
        String one = this.renderHelperValue(this.helper, "<test><one>1</one><two>2</two></test>", new Object[]{"/test/one/text()"}).toString();
        String two = this.renderHelperValue(this.helper, "<test><one>1</one><two>2</two></test>", new Object[]{"/test/two/text()"}).toString();
        MatcherAssert.assertThat((Object)one, (Matcher)Matchers.is((Object)"1"));
        MatcherAssert.assertThat((Object)two, (Matcher)Matchers.is((Object)"2"));
    }

    @Test
    public void rendersXmlWhenElementIsSelected() throws Exception {
        String one = this.renderHelperValue(this.helper, "<test><one>1</one><two>2</two></test>", new Object[]{"/test/one"}).toString();
        MatcherAssert.assertThat((Object)one.trim(), (Matcher)Matchers.is((Object)"<one>1</one>"));
    }

    @Test
    public void supportsIterationOverNodeListWithEachHelper() {
        ResponseDefinition responseDefinition = HandlebarsXPathHelperTest.transform((ResponseDefinitionTransformerV2)this.transformer, MockRequest.mockRequest().body("<?xml version=\"1.0\"?>\n<stuff>\n    <thing>One</thing>\n    <thing>Two</thing>\n    <thing>Three</thing>\n</stuff>"), WireMock.aResponse().withBody("{{#each (xPath request.body '/stuff/thing/text()') as |thing|}}{{thing}} {{/each}}"));
        MatcherAssert.assertThat((Object)responseDefinition.getBody(), (Matcher)Matchers.is((Object)"One Two Three "));
    }

    @Test
    public void supportsIterationOverElementsWithAttributes() {
        ResponseDefinition responseDefinition = HandlebarsXPathHelperTest.transform((ResponseDefinitionTransformerV2)this.transformer, MockRequest.mockRequest().body("<?xml version=\"1.0\"?>\n<stuff>\n    <thing id=\"1\">One</thing>\n    <thing id=\"2\">Two</thing>\n    <thing id=\"3\">Three</thing>\n</stuff>"), WireMock.aResponse().withBody("{{#each (xPath request.body '/stuff/thing') as |thing|}}{{{thing.attributes.id}}} {{/each}}"));
        MatcherAssert.assertThat((Object)responseDefinition.getBody(), (Matcher)Matchers.is((Object)"1 2 3 "));
    }

    @Test
    public void supportsIterationOverNamespacedElements() {
        ResponseDefinition responseDefinition = HandlebarsXPathHelperTest.transform((ResponseDefinitionTransformerV2)this.transformer, MockRequest.mockRequest().body("<?xml version=\"1.0\"?>\n<stuff xmlns:th=\"https://thing.com\">\n    <th:thing>One</th:thing>\n    <th:thing>Two</th:thing>\n    <th:thing>Three</th:thing>\n</stuff>"), WireMock.aResponse().withBody("{{#each (xPath request.body '/stuff/thing') as |thing|}}{{{thing.text}}} {{/each}}"));
        MatcherAssert.assertThat((Object)responseDefinition.getBody(), (Matcher)Matchers.is((Object)"One Two Three "));
    }

    @Test
    public void rendersNamespacedElement() {
        ResponseDefinition responseDefinition = HandlebarsXPathHelperTest.transform((ResponseDefinitionTransformerV2)this.transformer, MockRequest.mockRequest().body("<?xml version=\"1.0\"?>\n<stuff xmlns:th=\"https://thing.com\">\n    <th:thing>One</th:thing>\n    <th:thing>Two</th:thing>\n    <th:thing>Three</th:thing>\n</stuff>"), WireMock.aResponse().withBody("{{{xPath request.body '/stuff'}}}"));
        MatcherAssert.assertThat((Object)responseDefinition.getBody(), (Matcher)Matchers.equalToCompressingWhiteSpace((String)"<stuff xmlns:th=\"https://thing.com\">\n    <th:thing>One</th:thing>\n    <th:thing>Two</th:thing>\n    <th:thing>Three</th:thing>\n</stuff>"));
    }

    @Test
    public void rendersElementNames() {
        ResponseDefinition responseDefinition = HandlebarsXPathHelperTest.transform((ResponseDefinitionTransformerV2)this.transformer, MockRequest.mockRequest().body("<?xml version=\"1.0\"?>\n<stuff>\n    <one>1</one>\n    <two>2</two>\n    <three>3</three>\n</stuff>"), WireMock.aResponse().withBody("{{#each (xPath request.body '/stuff/*') as |thing|}}{{{thing.name}}} {{/each}}"));
        MatcherAssert.assertThat((Object)responseDefinition.getBody(), (Matcher)Matchers.is((Object)"one two three "));
    }
}

