/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.jknack.handlebars.Options;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ConsoleNotifier;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.extension.responsetemplating.ResponseTemplateTransformer;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsRandomValuesHelper;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.MockRequest;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.ServeEventFactory;
import com.github.tomakehurst.wiremock.testsupport.ExtensionFactoryUtils;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import java.io.IOException;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class HandlebarsRandomValuesHelperTest {
    private HandlebarsRandomValuesHelper helper;
    private ResponseTemplateTransformer transformer;

    @BeforeEach
    public void init() {
        this.helper = new HandlebarsRandomValuesHelper();
        this.transformer = ExtensionFactoryUtils.buildTemplateTransformer(true);
        LocalNotifier.set((Notifier)new ConsoleNotifier(true));
    }

    @Test
    public void generatesRandomAlphaNumericOfSpecifiedLength() throws Exception {
        Map<String, Object> optionsHash = Map.of("length", 36);
        String output = this.render(optionsHash);
        MatcherAssert.assertThat((Object)output.length(), (Matcher)Matchers.is((Object)36));
        MatcherAssert.assertThat((Object)output, WireMatchers.matches("^[a-z0-9]+$"));
    }

    @Test
    public void generatesUppercaseRandomAlphaNumericOfSpecifiedLength() throws Exception {
        Map<String, Object> optionsHash = Map.of("length", 36, "uppercase", true);
        String output = this.render(optionsHash);
        MatcherAssert.assertThat((Object)output.length(), (Matcher)Matchers.is((Object)36));
        MatcherAssert.assertThat((Object)output, WireMatchers.matches("^[A-Z0-9]+$"));
    }

    @Test
    public void generatesRandomAlphabeticOfSpecifiedLength() throws Exception {
        Map<String, Object> optionsHash = Map.of("length", 43, "type", "ALPHABETIC", "uppercase", true);
        String output = this.render(optionsHash);
        MatcherAssert.assertThat((Object)output.length(), (Matcher)Matchers.is((Object)43));
        MatcherAssert.assertThat((Object)output, WireMatchers.matches("^[A-Z]+$"));
    }

    @Test
    public void generatesRandomNumericOfSpecifiedLength() throws Exception {
        Map<String, Object> optionsHash = Map.of("length", 55, "type", "NUMERIC");
        String output = this.render(optionsHash);
        MatcherAssert.assertThat((Object)output.length(), (Matcher)Matchers.is((Object)55));
        MatcherAssert.assertThat((Object)output, WireMatchers.matches("^[0-9]+$"));
    }

    @Test
    public void generatesRandomStringOfSpecifiedLength() throws Exception {
        Map<String, Object> optionsHash = Map.of("length", 67, "type", "ALPHANUMERIC_AND_SYMBOLS");
        String output = this.render(optionsHash);
        MatcherAssert.assertThat((Object)output.length(), (Matcher)Matchers.is((Object)67));
        MatcherAssert.assertThat((Object)output, WireMatchers.matches("^.+$"));
    }

    @Test
    public void generatesRandomHexadecimalOfSpecifiedLength() throws Exception {
        Map<String, Object> optionsHash = Map.of("length", 64, "type", "HEXADECIMAL");
        String output = this.render(optionsHash);
        MatcherAssert.assertThat((Object)output.length(), (Matcher)Matchers.is((Object)64));
        MatcherAssert.assertThat((Object)output, WireMatchers.matches("^[0-9a-f]+$"));
    }

    @Test
    public void randomValuesCanBeAssignedToVariables() {
        ServeEvent serveEvent = ServeEventFactory.newPostMatchServeEvent((Request)MockRequest.mockRequest().url("/random-value"), WireMock.aResponse().withBody("{{#assign 'paymentId'}}{{randomValue length=20 type='ALPHANUMERIC' uppercase=true}}{{/assign}}\n{{paymentId}}\n{{paymentId}}"));
        ResponseDefinition responseDefinition = this.transformer.transform(serveEvent);
        String[] bodyLines = responseDefinition.getBody().trim().split("\n");
        MatcherAssert.assertThat((Object)bodyLines[0], (Matcher)Matchers.is((Object)bodyLines[1]));
        MatcherAssert.assertThat((Object)bodyLines[0].length(), (Matcher)Matchers.is((Object)20));
    }

    @Test
    public void generatesRandomUUID() throws Exception {
        Map<String, Object> optionsHash = Map.of("type", "UUID");
        String output = this.render(optionsHash);
        MatcherAssert.assertThat((Object)output.length(), (Matcher)Matchers.is((Object)36));
        MatcherAssert.assertThat((Object)output, WireMatchers.matches("^[a-z0-9\\-]+$"));
    }

    private String render(Map<String, Object> optionsHash) throws IOException {
        return this.helper.apply(null, new Options.Builder(null, null, null, null, null).setHash(optionsHash).build()).toString();
    }
}

