/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Options;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ConsoleNotifier;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.ResponseDefinitionTransformerV2;
import com.github.tomakehurst.wiremock.extension.responsetemplating.ResponseTemplateTransformer;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelperTestBase;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsJsonPathHelper;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.MockRequest;
import com.github.tomakehurst.wiremock.testsupport.ExtensionFactoryUtils;
import com.github.tomakehurst.wiremock.testsupport.MockWireMockServices;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class HandlebarsJsonPathHelperTest
extends HandlebarsHelperTestBase {
    private HandlebarsJsonPathHelper helper;

    @BeforeEach
    public void init() {
        this.helper = new HandlebarsJsonPathHelper();
        LocalNotifier.set((Notifier)new ConsoleNotifier(true));
    }

    @Test
    public void mergesASimpleValueFromRequestIntoResponseBody() {
        ResponseDefinition responseDefinition = HandlebarsJsonPathHelperTest.transform((ResponseDefinitionTransformerV2)this.transformer, MockRequest.mockRequest().url("/json").body("{\"a\": {\"test\": \"success\"}}"), WireMock.aResponse().withBody("{\"test\": \"{{jsonPath request.body '$.a.test'}}\"}"));
        MatcherAssert.assertThat((Object)responseDefinition.getBody(), (Matcher)Matchers.is((Object)"{\"test\": \"success\"}"));
    }

    @Test
    public void incluesAnErrorInTheResponseBodyWhenTheJsonPathIsInvalid() {
        ResponseDefinition responseDefinition = HandlebarsJsonPathHelperTest.transform((ResponseDefinitionTransformerV2)this.transformer, MockRequest.mockRequest().url("/json").body("{\"a\": {\"test\": \"success\"}}"), WireMock.aResponse().withBody("{\"test\": \"{{jsonPath request.body '$![bbb'}}\"}"));
        MatcherAssert.assertThat((Object)responseDefinition.getBody(), (Matcher)Matchers.startsWith((String)"{\"test\": \"[ERROR: "));
    }

    @Test
    public void listResultFromJsonPathQueryCanBeUsedByHandlebarsEachHelper() {
        ResponseDefinition responseDefinition = HandlebarsJsonPathHelperTest.transform((ResponseDefinitionTransformerV2)this.transformer, MockRequest.mockRequest().url("/json").body("{\n    \"items\": [\n        {\n            \"name\": \"One\"\n        },\n        {\n            \"name\": \"Two\"\n        },\n        {\n            \"name\": \"Three\"\n        }\n    ]\n}"), WireMock.aResponse().withBody("{{#each (jsonPath request.body '$.items') as |item|}}{{item.name}} {{/each}}"));
        MatcherAssert.assertThat((Object)responseDefinition.getBody(), (Matcher)Matchers.is((Object)"One Two Three "));
    }

    @Test
    public void mapResultFromJsonPathQueryCanBeUsedByHandlebarsEachHelper() {
        ResponseDefinition responseDefinition = HandlebarsJsonPathHelperTest.transform((ResponseDefinitionTransformerV2)this.transformer, MockRequest.mockRequest().url("/json").body("{\n    \"items\": {\n        \"one\": 1,\n        \"two\": 2,\n        \"three\": 3\n    }\n}"), WireMock.aResponse().withBody("{{#each (jsonPath request.body '$.items') as |value key|}}{{key}}: {{value}} {{/each}}"));
        MatcherAssert.assertThat((Object)responseDefinition.getBody(), (Matcher)Matchers.is((Object)"one: 1 two: 2 three: 3 "));
    }

    @Test
    public void singleValueResultFromJsonPathQueryCanBeUsedByHandlebarsIfHelper() {
        ResponseDefinition responseDefinition = HandlebarsJsonPathHelperTest.transform((ResponseDefinitionTransformerV2)this.transformer, MockRequest.mockRequest().url("/json").body("{\n    \"items\": {\n        \"one\": true,\n        \"two\": false,\n        \"three\": true\n    }\n}"), WireMock.aResponse().withBody("{{#if (jsonPath request.body '$.items.one')}}One{{/if}}\n{{#if (jsonPath request.body '$.items.two')}}Two{{/if}}"));
        MatcherAssert.assertThat((Object)responseDefinition.getBody(), (Matcher)Matchers.containsString((String)"One"));
        MatcherAssert.assertThat((Object)responseDefinition.getBody(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Two")));
    }

    @Test
    public void extractsASingleStringValueFromTheInputJson() throws IOException {
        this.testHelper(this.helper, "{\"test\":\"success\"}", "$.test", "success");
    }

    @Test
    public void extractsASingleNumberValueFromTheInputJson() throws IOException {
        this.testHelper(this.helper, "{\"test\": 1.2}", "$.test", "1.2");
    }

    @Test
    public void extractsASingleBooleanValueFromTheInputJson() throws IOException {
        this.testHelper(this.helper, "{\"test\": false}", "$.test", "false");
    }

    @Test
    public void extractsAJsonObjectFromTheInputJson() throws IOException {
        this.testHelper(this.helper, "{                          \n    \"outer\": {               \n        \"inner\": \"Sanctum\" \n    }                          \n}", "$.outer", WireMatchers.equalToJson("{                         \n        \"inner\": \"Sanctum\" \n    }"));
    }

    @Test
    public void extractsAJsonArrayFromTheInputJson() throws IOException {
        this.testHelper(this.helper, "{\n    \"things\": [1, 2, 3]\n}", "$.things", WireMatchers.equalToJson("[1, 2, 3]"));
    }

    @Test
    public void rendersAMeaningfulErrorWhenInputJsonIsInvalid() {
        this.testHelperError(this.helper, "{\"test\":\"success}", "$.test", (Matcher<String>)Matchers.is((Object)"[ERROR: {\"test\":\"success} is not valid JSON]"));
    }

    @Test
    public void rendersAMeaningfulErrorWhenJsonPathIsInvalid() {
        this.testHelperError(this.helper, "{\"test\":\"success\"}", "$==test", (Matcher<String>)Matchers.is((Object)"[ERROR: $==test is not a valid JSONPath expression]"));
    }

    @Test
    public void rendersAnEmptyStringWhenJsonValueUndefined() {
        this.testHelperError(this.helper, "{\"test\":\"success\"}", "$.test2", (Matcher<String>)Matchers.is((Object)""));
    }

    @Test
    public void rendersAnEmptyStringWhenJsonValueUndefinedAndOptionsEmpty() throws Exception {
        Map<String, Object> options = Map.of();
        String output = this.render("{\"test\":\"success\"}", "$.test2", options);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void rendersDefaultValueWhenShallowJsonValueUndefined() throws Exception {
        Map<String, Object> options = Map.of("default", "0");
        String output = this.render("{}", "$.test", options);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.is((Object)"0"));
    }

    @Test
    public void rendersDefaultValueWhenDeepJsonValueUndefined() throws Exception {
        Map<String, Object> options = Map.of("default", "0");
        String output = this.render("{}", "$.outer.inner[0]", options);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.is((Object)"0"));
    }

    @Test
    public void rendersDefaultValueWhenJsonValueNull() throws Exception {
        Map<String, Object> options = Map.of("default", "0");
        String output = this.render("{\"test\":null}", "$.test", options);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.is((Object)"0"));
    }

    @Test
    public void ignoresDefaultWhenJsonValueEmpty() throws Exception {
        Map<String, Object> options = Map.of("default", "0");
        String output = this.render("{\"test\":\"\"}", "$.test", options);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void ignoresDefaultWhenJsonValueZero() throws Exception {
        Map<String, Object> options = Map.of("default", "1");
        String output = this.render("{\"test\":0}", "$.test", options);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.is((Object)"0"));
    }

    private String render(String content, String path, Map<String, Object> options) throws IOException {
        return this.helper.apply((Object)content, new Options.Builder(null, null, null, this.createContext(), null).setParams(new Object[]{path}).setHash(options).build()).toString();
    }

    @Test
    public void rendersAnEmptyStringWhenJsonIsNull() {
        this.testHelperError(this.helper, null, "$.test", (Matcher<String>)Matchers.is((Object)""));
    }

    @Test
    public void rendersAMeaningfulErrorWhenJsonPathIsNull() {
        this.testHelperError(this.helper, "{\"test\":\"success}", (String)null, (Matcher<String>)Matchers.is((Object)"[ERROR: The JSONPath cannot be empty]"));
    }

    @Test
    public void extractsValueFromAMap() {
        ResponseTemplateTransformer transformer = (ResponseTemplateTransformer)ExtensionFactoryUtils.buildExtension(new MockWireMockServices(), services -> List.of(new ResponseTemplateTransformer(services.getTemplateEngine(), true, services.getFiles(), Collections.emptyList()){

            protected Map<String, Object> addExtraModelElements(Request request, ResponseDefinition responseDefinition, FileSource files, Parameters parameters) {
                return ImmutableMap.of((Object)"mapData", (Object)ImmutableMap.of((Object)"things", (Object)"abc"));
            }
        }));
        ResponseDefinition responseDefinition = HandlebarsJsonPathHelperTest.transform((ResponseDefinitionTransformerV2)transformer, MockRequest.mockRequest(), WireMock.aResponse().withBody("{{jsonPath mapData '$.things'}}"));
        MatcherAssert.assertThat((Object)responseDefinition.getBody(), (Matcher)Matchers.is((Object)"abc"));
    }

    @Test
    public void returnsCorrectResultWhenSameExpressionUsedTwiceOnIdenticalDocuments() throws Exception {
        String one = (String)this.renderHelperValue(this.helper, "{\"test\": \"one\"}", new Object[]{"$.test"});
        String two = (String)this.renderHelperValue(this.helper, "{\"test\": \"one\"}", new Object[]{"$.test"});
        MatcherAssert.assertThat((Object)one, (Matcher)Matchers.is((Object)"one"));
        MatcherAssert.assertThat((Object)two, (Matcher)Matchers.is((Object)"one"));
    }

    @Test
    public void returnsCorrectResultWhenSameExpressionUsedTwiceOnDifferentDocuments() throws Exception {
        String one = (String)this.renderHelperValue(this.helper, "{\"test\": \"one\"}", new Object[]{"$.test"});
        String two = (String)this.renderHelperValue(this.helper, "{\"test\": \"two\"}", new Object[]{"$.test"});
        MatcherAssert.assertThat((Object)one, (Matcher)Matchers.is((Object)"one"));
        MatcherAssert.assertThat((Object)two, (Matcher)Matchers.is((Object)"two"));
    }

    @Test
    public void returnsCorrectResultWhenDifferentExpressionsUsedOnSameDocument() throws Exception {
        int one = (Integer)this.renderHelperValue(this.helper, "{\n  \"test\": {\n    \"one\": 1,\n    \"two\": 2\n  }\n}", new Object[]{"$.test.one"});
        int two = (Integer)this.renderHelperValue(this.helper, "{\n  \"test\": {\n    \"one\": 1,\n    \"two\": 2\n  }\n}", new Object[]{"$.test.two"});
        MatcherAssert.assertThat((Object)one, (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)two, (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void helperCanBeCalledDirectlyWithoutSupplyingRenderCache() throws Exception {
        Context context = Context.newBuilder(null).build();
        Options options = new Options(null, null, null, context, null, null, new Object[]{"$.stuff"}, null, new ArrayList(0));
        Object result = this.helper.apply((Object)"{\"stuff\":1}", options);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.instanceOf(Integer.class));
        MatcherAssert.assertThat((Object)((Integer)result), (Matcher)Matchers.is((Object)1));
    }
}

