/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.github.jknack.handlebars.Options;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ConsoleNotifier;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.extension.ResponseDefinitionTransformerV2;
import com.github.tomakehurst.wiremock.extension.responsetemplating.ResponseTemplateTransformer;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsCurrentDateHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelperTestBase;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.RenderableDate;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.MockRequest;
import com.github.tomakehurst.wiremock.testsupport.ExtensionFactoryUtils;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class HandlebarsCurrentDateHelperTest {
    private HandlebarsCurrentDateHelper helper;
    private ResponseTemplateTransformer transformer;

    @BeforeEach
    public void init() {
        this.helper = new HandlebarsCurrentDateHelper();
        this.transformer = ExtensionFactoryUtils.buildTemplateTransformer(true);
        LocalNotifier.set((Notifier)new ConsoleNotifier(true));
    }

    @Test
    public void rendersNowDateTime() throws Exception {
        Map<String, Object> optionsHash = Map.of();
        Object output = this.render(optionsHash);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.instanceOf(RenderableDate.class));
        MatcherAssert.assertThat((Object)output.toString(), WireMatchers.matches("^[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9:]+Z$"));
    }

    @Test
    public void rendersNowDateTimeWithCustomFormat() throws Exception {
        Map<String, Object> optionsHash = Map.of("format", "yyyy/mm/dd");
        Object output = this.render(optionsHash);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.instanceOf(RenderableDate.class));
        MatcherAssert.assertThat((Object)output.toString(), WireMatchers.matches("^[0-9]{4}/[0-9]{2}/[0-9]{2}$"));
    }

    @Test
    public void rendersPassedDateTimeWithDayOffset() throws Exception {
        String format = "yyyy-MM-dd";
        SimpleDateFormat df = new SimpleDateFormat(format);
        Map<String, Object> optionsHash = Map.of("format", format, "offset", "5 days");
        Object output = this.render(df.parse("2018-04-16"), optionsHash);
        MatcherAssert.assertThat((Object)output.toString(), (Matcher)Matchers.is((Object)"2018-04-21"));
    }

    @Test
    public void rendersNowWithDayOffset() throws Exception {
        Map<String, Object> optionsHash = Map.of("offset", "6 months");
        Object output = this.render(optionsHash);
        System.out.println(output);
    }

    @Test
    public void rendersNowAsUnixEpochInMilliseconds() throws Exception {
        Map<String, Object> optionsHash = Map.of("format", "epoch");
        Date date = new Date();
        Object output = this.render(date, optionsHash);
        MatcherAssert.assertThat((Object)output.toString(), (Matcher)Matchers.is((Object)String.valueOf(date.getTime())));
    }

    @Test
    public void rendersNowAsUnixEpochInSeconds() throws Exception {
        Map<String, Object> optionsHash = Map.of("format", "unix");
        Date date = new Date();
        Object output = this.render(date, optionsHash);
        MatcherAssert.assertThat((Object)output.toString(), (Matcher)Matchers.is((Object)String.valueOf(date.getTime() / 1000L)));
    }

    @Test
    public void adjustsISO8601ToSpecfiedTimezone() throws Exception {
        Map<String, Object> optionsHash = Map.of("offset", "3 days", "timezone", "Australia/Sydney");
        Date inputDate = new ISO8601DateFormat().parse("2014-10-09T06:06:01Z");
        Object output = this.render(inputDate, optionsHash);
        MatcherAssert.assertThat((Object)output.toString(), (Matcher)Matchers.is((Object)"2014-10-12T17:06:01+11:00"));
    }

    @Test
    public void adjustsCustomFormatToSpecfiedTimezone() throws Exception {
        Map<String, Object> optionsHash = Map.of("offset", "3 days", "timezone", "Australia/Sydney", "format", "yyyy-MM-dd HH:mm:ssZ");
        Date inputDate = new ISO8601DateFormat().parse("2014-10-09T06:06:01Z");
        Object output = this.render(inputDate, optionsHash);
        MatcherAssert.assertThat((Object)output.toString(), (Matcher)Matchers.is((Object)"2014-10-12 17:06:01+1100"));
    }

    @Test
    public void helperIsIncludedInTemplateTransformerWithNowTagName() {
        ResponseDefinition responseDefinition = HandlebarsHelperTestBase.transform((ResponseDefinitionTransformerV2)this.transformer, MockRequest.mockRequest().url("/random-value"), WireMock.aResponse().withBody("{{now offset='6 days'}}"));
        String body = responseDefinition.getBody().trim();
        MatcherAssert.assertThat((Object)body, WireMatchers.matches("^[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9:]+Z$"));
    }

    @Test
    public void helperIsIncludedInTemplateTransformerWithDateTagName() {
        ResponseDefinition responseDefinition = HandlebarsHelperTestBase.transform((ResponseDefinitionTransformerV2)this.transformer, MockRequest.mockRequest().url("/random-value"), WireMock.aResponse().withBody("{{date offset='6 days'}}"));
        String body = responseDefinition.getBody().trim();
        MatcherAssert.assertThat((Object)body, WireMatchers.matches("^[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9:]+Z$"));
    }

    @Test
    public void acceptsDateParameterwithDateTagName() {
        ResponseDefinition responseDefinition = HandlebarsHelperTestBase.transform((ResponseDefinitionTransformerV2)this.transformer, MockRequest.mockRequest().url("/parsed-date"), WireMock.aResponse().withBody("{{date (parseDate '2018-05-05T10:11:12Z') offset='-1 days'}}"));
        String body = responseDefinition.getBody().trim();
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.is((Object)"2018-05-04T10:11:12Z"));
    }

    private Object render(Map<String, Object> optionsHash) throws IOException {
        return this.render(null, optionsHash);
    }

    private Object render(Date context, Map<String, Object> optionsHash) throws IOException {
        return this.helper.apply(context, new Options.Builder(null, null, null, null, null).setHash(optionsHash).build());
    }
}

