/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.extension.Parameters;
import java.time.LocalDate;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class ParametersTest {
    @Test
    public void convertsParametersToAnObject() {
        MyData myData = (MyData)Parameters.from(Map.of("name", "Tom", "num", 27, "date", "2023-01-01")).as(MyData.class);
        MatcherAssert.assertThat((Object)myData.getName(), (Matcher)Matchers.is((Object)"Tom"));
        MatcherAssert.assertThat((Object)myData.getNum(), (Matcher)Matchers.is((Object)27));
        MatcherAssert.assertThat((Object)myData.getDate(), (Matcher)Matchers.is((Object)LocalDate.of(2023, 1, 1)));
    }

    @Test
    public void convertsToParametersFromAnObject() {
        MyData myData = new MyData("Mark", 12, LocalDate.of(2023, 1, 1));
        Parameters parameters = Parameters.of((Object)myData);
        MatcherAssert.assertThat((Object)parameters.getString("name"), (Matcher)Matchers.is((Object)"Mark"));
        MatcherAssert.assertThat((Object)parameters.getInt("num"), (Matcher)Matchers.is((Object)12));
        MatcherAssert.assertThat((Object)parameters.getString("date"), (Matcher)Matchers.is((Object)"2023-01-01"));
    }

    public static class MyData {
        private final String name;
        private final Integer num;
        private final LocalDate date;

        @JsonCreator
        public MyData(@JsonProperty(value="name") String name, @JsonProperty(value="num") Integer num, @JsonProperty(value="date") LocalDate date) {
            this.name = name;
            this.num = num;
            this.date = date;
        }

        public String getName() {
            return this.name;
        }

        public Integer getNum() {
            return this.num;
        }

        public LocalDate getDate() {
            return this.date;
        }
    }
}

