/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.direct;

import com.github.tomakehurst.wiremock.common.JettySettings;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.direct.DirectCallHttpServer;
import com.github.tomakehurst.wiremock.direct.SleepFacade;
import com.github.tomakehurst.wiremock.http.AbstractRequestHandler;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.HttpResponder;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class DirectCallHttpServerTest {
    @Mock
    private SleepFacade sleepFacade;
    @Mock
    private Options options;
    @Mock
    private JettySettings jettySettings;
    @Mock
    private AdminRequestHandler adminRequestHandler;
    @Mock
    private StubRequestHandler stubRequestHandler;
    private DirectCallHttpServer server;

    DirectCallHttpServerTest() {
    }

    @BeforeEach
    void setup() {
        Mockito.when((Object)this.options.jettySettings()).thenReturn((Object)this.jettySettings);
        Mockito.when((Object)this.jettySettings.getStopTimeout()).thenReturn(Optional.empty());
        this.server = new DirectCallHttpServer(this.sleepFacade, this.options, this.adminRequestHandler, this.stubRequestHandler);
    }

    abstract class AbstractRequestHandlerTest {
        @Mock
        private Request request;
        @Mock
        private Response response;
        private Response actual;

        AbstractRequestHandlerTest() {
        }

        abstract AbstractRequestHandler handler();

        abstract Response handle(Request var1);

        @Nested
        class AsyncTimeout {
            AsyncTimeout() {
            }

            @BeforeEach
            void setup() {
                Mockito.when((Object)DirectCallHttpServerTest.this.jettySettings.getStopTimeout()).thenReturn(Optional.of(5L));
                DirectCallHttpServerTest.this.server = new DirectCallHttpServer(DirectCallHttpServerTest.this.options, DirectCallHttpServerTest.this.adminRequestHandler, DirectCallHttpServerTest.this.stubRequestHandler);
            }

            @Test
            void throwsIllegalStateExceptionWhenNoResponse() {
                IllegalStateException actual = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> AbstractRequestHandlerTest.this.handle(AbstractRequestHandlerTest.this.request));
                Assertions.assertEquals((Object)"The request was not handled within the timeout of 5ms", (Object)actual.getMessage());
                Assertions.assertTrue((boolean)(actual.getCause() instanceof TimeoutException));
            }
        }

        @Disabled(value="Is not implemented")
        @Nested
        class Fault {
            Fault() {
            }
        }

        @Nested
        class WhenDelay {
            WhenDelay() {
            }

            @Disabled(value="Is not implemented")
            @Nested
            class ChunkedDribbleDelay {
                ChunkedDribbleDelay() {
                }
            }

            @Nested
            class WhenRandomDelay {
                WhenRandomDelay() {
                }

                @Disabled(value="Needs to be implemented")
                @Test
                void todo() {
                    Assertions.fail();
                }
            }

            @Nested
            class WhenFixed {
                WhenFixed() {
                }

                @BeforeEach
                void setup() {
                    Mockito.when((Object)AbstractRequestHandlerTest.this.response.getInitialDelay()).thenReturn((Object)1000L);
                    ((AbstractRequestHandler)Mockito.doAnswer(i -> {
                        HttpResponder responder = (HttpResponder)i.getArgument(1, HttpResponder.class);
                        responder.respond(AbstractRequestHandlerTest.this.request, AbstractRequestHandlerTest.this.response, Collections.emptyMap());
                        return null;
                    }).when((Object)AbstractRequestHandlerTest.this.handler())).handle((Request)ArgumentMatchers.any(), (HttpResponder)ArgumentMatchers.any(), (ServeEvent)ArgumentMatchers.any());
                    AbstractRequestHandlerTest.this.actual = AbstractRequestHandlerTest.this.handle(AbstractRequestHandlerTest.this.request);
                }

                @Test
                void delegatesRequest() {
                    ((AbstractRequestHandler)Mockito.verify((Object)AbstractRequestHandlerTest.this.handler())).handle((Request)Mockito.eq((Object)AbstractRequestHandlerTest.this.request), (HttpResponder)ArgumentMatchers.any(), (ServeEvent)ArgumentMatchers.any());
                }

                @Test
                void delegatesDelays() {
                    ((SleepFacade)Mockito.verify((Object)DirectCallHttpServerTest.this.sleepFacade)).sleep(1000L);
                }

                @Test
                void returnsResponse() {
                    Assertions.assertEquals((Object)AbstractRequestHandlerTest.this.response, (Object)AbstractRequestHandlerTest.this.actual);
                }
            }
        }

        @Nested
        class HappyPath {
            HappyPath() {
            }

            @BeforeEach
            void setup() {
                ((AbstractRequestHandler)Mockito.doAnswer(i -> {
                    HttpResponder responder = (HttpResponder)i.getArgument(1, HttpResponder.class);
                    responder.respond(AbstractRequestHandlerTest.this.request, AbstractRequestHandlerTest.this.response, Collections.emptyMap());
                    return null;
                }).when((Object)AbstractRequestHandlerTest.this.handler())).handle((Request)ArgumentMatchers.any(), (HttpResponder)ArgumentMatchers.any(), (ServeEvent)ArgumentMatchers.any());
                AbstractRequestHandlerTest.this.actual = AbstractRequestHandlerTest.this.handle(AbstractRequestHandlerTest.this.request);
            }

            @Test
            void delegatesRequest() {
                ((AbstractRequestHandler)Mockito.verify((Object)AbstractRequestHandlerTest.this.handler())).handle((Request)Mockito.eq((Object)AbstractRequestHandlerTest.this.request), (HttpResponder)ArgumentMatchers.any(), (ServeEvent)ArgumentMatchers.any());
            }

            @Test
            void returnsResponse() {
                Assertions.assertEquals((Object)AbstractRequestHandlerTest.this.response, (Object)AbstractRequestHandlerTest.this.actual);
            }
        }
    }

    @Nested
    class StubRequest
    extends AbstractRequestHandlerTest {
        StubRequest() {
        }

        @Override
        AbstractRequestHandler handler() {
            return DirectCallHttpServerTest.this.stubRequestHandler;
        }

        @Override
        Response handle(Request request) {
            return DirectCallHttpServerTest.this.server.stubRequest(request);
        }
    }

    @Nested
    class AdminRequest
    extends AbstractRequestHandlerTest {
        AdminRequest() {
        }

        @Override
        AbstractRequestHandler handler() {
            return DirectCallHttpServerTest.this.adminRequestHandler;
        }

        @Override
        Response handle(Request request) {
            return DirectCallHttpServerTest.this.server.adminRequest(request);
        }
    }

    @Nested
    class HttpsPort {
        HttpsPort() {
        }

        @Test
        void isInvalidPortNumber() {
            Assertions.assertEquals((int)DirectCallHttpServerTest.this.server.httpsPort(), (int)-2);
        }
    }

    @Nested
    class Port {
        Port() {
        }

        @Test
        void isInvalidPortNumber() {
            Assertions.assertEquals((int)DirectCallHttpServerTest.this.server.port(), (int)-1);
        }
    }

    @Nested
    class IsRunning {
        IsRunning() {
        }

        @Test
        void isAlwaysTrue() {
            Assertions.assertTrue((boolean)DirectCallHttpServerTest.this.server.isRunning());
        }

        @Test
        void isUnaffectedByStop() {
            boolean isRunning = DirectCallHttpServerTest.this.server.isRunning();
            DirectCallHttpServerTest.this.server.stop();
            Assertions.assertEquals((Object)DirectCallHttpServerTest.this.server.isRunning(), (Object)isRunning);
        }
    }

    @Nested
    class Stop {
        Stop() {
        }

        @Test
        void doesNothing() {
            Assertions.assertDoesNotThrow(() -> ((DirectCallHttpServer)DirectCallHttpServerTest.this.server).start());
        }
    }

    @Nested
    class Start {
        Start() {
        }

        @Test
        void doesNothing() {
            Assertions.assertDoesNotThrow(() -> ((DirectCallHttpServer)DirectCallHttpServerTest.this.server).start());
        }
    }

    @Nested
    class Constructor {
        Constructor() {
        }

        @Test
        void publicConstructor() {
            Assertions.assertDoesNotThrow(() -> new DirectCallHttpServer(DirectCallHttpServerTest.this.options, DirectCallHttpServerTest.this.adminRequestHandler, DirectCallHttpServerTest.this.stubRequestHandler));
        }
    }
}

