/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common.url;

import com.github.tomakehurst.wiremock.common.url.PathParams;
import com.github.tomakehurst.wiremock.common.url.PathTemplate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PathTemplateTest {
    @Test
    public void extractsSinglePathParameter() {
        PathTemplate template = new PathTemplate("/things/{id}");
        PathParams pathParams = template.parse("/things/11-22-33");
        MatcherAssert.assertThat((Object)((String)pathParams.get((Object)"id")), (Matcher)Matchers.is((Object)"11-22-33"));
    }

    @Test
    public void throwsIllegalArgumentExceptionIfAttemptingParsingOnNonMatchingUrl() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            PathTemplate template = new PathTemplate("/things/{id}");
            template.parse("/things/stuff/11-22-33");
        });
    }

    @Test
    public void matchesWhenUrlIsEquivalentToTemplate() {
        PathTemplate template = new PathTemplate("/things/{id}/otherthings/{subId}");
        MatcherAssert.assertThat((Object)template.matches("/things/11-22-33/otherthings/12378"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void nonMatchWhenUrlIsShorterThanTemplate() {
        PathTemplate template = new PathTemplate("/things/{id}/otherthings/{subId}");
        MatcherAssert.assertThat((Object)template.matches("/things/11-22-33/otherthings"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void nonMatchWhenUrlPartIsMismatch() {
        PathTemplate template = new PathTemplate("/things/{id}/otherthings/{subId}");
        MatcherAssert.assertThat((Object)template.matches("/things/11-22-33/other-stuff/1234"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void rendersWithParameters() {
        PathTemplate template = new PathTemplate("/things/{id}/otherthings/{subId}");
        PathParams pathParams = new PathParams().add("id", "123").add("subId", "456");
        String path = template.render(pathParams);
        MatcherAssert.assertThat((Object)path, (Matcher)Matchers.is((Object)"/things/123/otherthings/456"));
    }

    @Test
    public void rendersWithoutParameters() {
        PathTemplate template = new PathTemplate("/things/stuff");
        String path = template.render(PathParams.empty());
        MatcherAssert.assertThat((Object)path, (Matcher)Matchers.is((Object)"/things/stuff"));
    }

    @Test
    public void throwsErrorWhenNotAllParametersAreBound() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            PathTemplate template = new PathTemplate("/things/{id}/otherthings/{subId}");
            template.render(new PathParams().add("id", "123"));
        });
    }

    @Test
    public void parseWithWildcardAndOneDepthPath() {
        PathTemplate template = new PathTemplate("/things/**");
        PathParams pathParams = template.parse("/things/stuff");
        MatcherAssert.assertThat((Object)((String)pathParams.get((Object)"0")), (Matcher)Matchers.is((Object)"stuff"));
    }

    @Test
    public void parseWithWildcardAndTwoDepthPath() {
        PathTemplate template = new PathTemplate("/things/**");
        PathParams pathParams = template.parse("/things/foo/bar");
        MatcherAssert.assertThat((Object)((String)pathParams.get((Object)"0")), (Matcher)Matchers.is((Object)"foo/bar"));
    }

    @Test
    public void parseWithVariableAndWildcardAndTwoDepthPath() {
        PathTemplate template = new PathTemplate("/things/{id}/**");
        PathParams pathParams = template.parse("/things/foo/bar");
        MatcherAssert.assertThat((Object)((String)pathParams.get((Object)"id")), (Matcher)Matchers.is((Object)"foo"));
        MatcherAssert.assertThat((Object)((String)pathParams.get((Object)"0")), (Matcher)Matchers.is((Object)"bar"));
    }

    @Test
    public void renderWithWildcardAndOneDepth() {
        PathTemplate template = new PathTemplate("/things/**");
        PathParams pathParams = new PathParams().add("0", "stuff");
        String path = template.render(pathParams);
        MatcherAssert.assertThat((Object)path, (Matcher)Matchers.is((Object)"/things/stuff"));
    }

    @Test
    public void renderWithWildcardAndTwoDepth() {
        PathTemplate template = new PathTemplate("/things/**");
        PathParams pathParams = new PathParams().add("0", "foo/bar");
        String path = template.render(pathParams);
        MatcherAssert.assertThat((Object)path, (Matcher)Matchers.is((Object)"/things/foo/bar"));
    }

    @Test
    public void renderWithVariableAndWildcardAndTwoDepthPath() {
        PathTemplate template = new PathTemplate("/things/{id}/**");
        PathParams pathParams = new PathParams().add("id", "foo").add("0", "bar");
        String path = template.render(pathParams);
        MatcherAssert.assertThat((Object)path, (Matcher)Matchers.is((Object)"/things/foo/bar"));
    }

    @Test
    public void throwsErrorWhenNotWildcardParameterIsNotBound() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            PathTemplate template = new PathTemplate("/things/{id}/**");
            template.render(new PathParams().add("id", "123"));
        });
    }

    @Test
    public void checkHashAndEquality() {
        List<String> templates = Arrays.asList("/things", "/things/", "/things/**", "/things/{id}", "/things/{name}", "/things/**/", "/things/{id}/", "/things/{name}/");
        LinkedHashSet<PathTemplate> uriTemplateSet = new LinkedHashSet<PathTemplate>();
        for (String template : templates) {
            PathTemplate uriTemplate = new PathTemplate(template);
            if (uriTemplateSet.add(uriTemplate)) continue;
            Assertions.fail((String)String.format("Can't add '%s' to '%s'", template, uriTemplateSet));
        }
    }

    @Test
    public void checkEquality() {
        List<String> templates = Arrays.asList("/things", "/things/", "/things/**", "/things/{id}", "/things/{name}", "/things/**/", "/things/{id}/", "/things/{name}/");
        ArrayList<PathTemplate> uriTemplates = new ArrayList<PathTemplate>();
        for (String template : templates) {
            PathTemplate uriTemplate = new PathTemplate(template);
            if (uriTemplates.contains(uriTemplate)) {
                Assertions.fail((String)String.format("Can't add '%s' to '%s'", template, uriTemplates));
            }
            uriTemplates.add(uriTemplate);
        }
    }

    @Test
    void returnsPathTemplateWithVariablesStrippedOut() {
        PathTemplate pathTemplate = new PathTemplate("/one/{first}/two/{second}/three");
        MatcherAssert.assertThat((Object)pathTemplate.withoutVariables(), (Matcher)Matchers.is((Object)"/one//two//three"));
    }

    @Test
    void indicatesWhetherAStringCouldBeAPathTemplate() {
        Assertions.assertTrue((boolean)PathTemplate.couldBePathTemplate((String)"/things/{id}"));
        Assertions.assertTrue((boolean)PathTemplate.couldBePathTemplate((String)"/things/**"));
        Assertions.assertTrue((boolean)PathTemplate.couldBePathTemplate((String)"/things/{id}/stuff"));
        Assertions.assertFalse((boolean)PathTemplate.couldBePathTemplate((String)"/things/in/path"));
        Assertions.assertFalse((boolean)PathTemplate.couldBePathTemplate((String)"/thing"));
    }

    @Test
    void correctlyStripsFormatCharactersFromKeysWhenParsing() {
        PathTemplate pathTemplate = new PathTemplate("/one/{.first}/two/{;second*}");
        PathParams pathParams = pathTemplate.parse("/one/.3,4,5/two/;second=1;second=2");
        MatcherAssert.assertThat((Object)((String)pathParams.get((Object)"first")), (Matcher)Matchers.is((Object)".3,4,5"));
        MatcherAssert.assertThat((Object)((String)pathParams.get((Object)"second")), (Matcher)Matchers.is((Object)";second=1;second=2"));
    }

    @Test
    void correctlyStripsFormatCharactersFromKeysWhenRendering() {
        PathTemplate pathTemplate = new PathTemplate("/one/{.first}/two/{;second*}");
        PathParams pathParams = new PathParams().add("first", ".3,4,5").add("second", ";second=1;second=2");
        String renderedUrl = pathTemplate.render(pathParams);
        MatcherAssert.assertThat((Object)renderedUrl, (Matcher)Matchers.is((Object)"/one/.3,4,5/two/;second=1;second=2"));
    }
}

