/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.TextFile;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;

public class TextFileTest {
    @Test
    @DisabledOnOs(value={OS.WINDOWS}, disabledReason="This test can only be run on non-Windows its behaviour is OS specific")
    public void returnsPathToFileOnLinuxSystems() throws Exception {
        TextFile textFile = new TextFile(new URI("file://home/bob/myfile.txt"));
        String path = textFile.getPath();
        Assertions.assertEquals((Object)"/home/bob/myfile.txt", (Object)path);
    }

    @Test
    @EnabledOnOs(value={OS.WINDOWS}, disabledReason="This test can only be run on Windows because File uses FileSystem in its constructor and its behaviour is OS specific")
    public void returnsPathToFileOnWindowsSystems() throws Exception {
        TextFile textFile = new TextFile(new URI("file:/C:/Users/bob/myfile.txt"));
        Path path = Paths.get(textFile.getPath(), new String[0]);
        Assertions.assertEquals((Object)Paths.get("C:/Users/bob/myfile.txt", new String[0]), (Object)path);
    }
}

