/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.SingleRootFileSource;
import com.github.tomakehurst.wiremock.security.NotAuthorisedException;
import com.github.tomakehurst.wiremock.testsupport.TestFiles;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SingleRootFileSourceTest {
    public static final String ROOT_PATH = TestFiles.filePath("filesource");

    @Test
    public void listsTextFilesRecursively() {
        SingleRootFileSource fileSource = new SingleRootFileSource(ROOT_PATH);
        List files = fileSource.listFilesRecursively();
        MatcherAssert.assertThat((Object)files, WireMatchers.hasExactlyIgnoringOrder(WireMatchers.fileNamed("one"), WireMatchers.fileNamed("two"), WireMatchers.fileNamed("three"), WireMatchers.fileNamed("four"), WireMatchers.fileNamed("five"), WireMatchers.fileNamed("six"), WireMatchers.fileNamed("seven"), WireMatchers.fileNamed("eight"), WireMatchers.fileNamed("deepfile.json")));
    }

    @Test
    public void writesTextFileEvenWhenRootIsARelativePath() throws IOException {
        String relativeRootPath = "./target/tmp/";
        FileUtils.forceMkdir((File)new File(relativeRootPath));
        SingleRootFileSource fileSource = new SingleRootFileSource(relativeRootPath);
        Path fileAbsolutePath = Paths.get(relativeRootPath, new String[0]).toAbsolutePath().resolve("myFile");
        fileSource.writeTextFile(fileAbsolutePath.toString(), "stuff");
        MatcherAssert.assertThat((Object)Files.exists(fileAbsolutePath, new LinkOption[0]), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void listFilesRecursivelyThrowsExceptionWhenRootIsNotDir() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            SingleRootFileSource fileSource = new SingleRootFileSource("src/test/resources/filesource/one");
            fileSource.listFilesRecursively();
        });
    }

    @Test
    public void writeThrowsExceptionWhenRootIsNotDir() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            SingleRootFileSource fileSource = new SingleRootFileSource("src/test/resources/filesource/one");
            fileSource.writeTextFile("thing", "stuff");
        });
    }

    @Test
    public void listFilesRecursivelyThrowsExceptionWhenLastPathNodeIsSimilarToRootButWithExtraCharacters() {
        Assertions.assertThrows(NotAuthorisedException.class, () -> {
            SingleRootFileSource fileSource = new SingleRootFileSource("src/test/resources/security-filesource/root");
            fileSource.getBinaryFileNamed("../rootdir/file.json");
        });
    }

    @Test
    public void writeTextFileThrowsExceptionWhenGivenRelativePathNotUnderRoot() {
        Assertions.assertThrows(NotAuthorisedException.class, () -> {
            SingleRootFileSource fileSource = new SingleRootFileSource(ROOT_PATH);
            fileSource.writeTextFile("..", "stuff");
        });
    }

    @Test
    public void writeTextFileThrowsExceptionWhenGivenAbsolutePathNotUnderRoot() {
        Assertions.assertThrows(NotAuthorisedException.class, () -> {
            SingleRootFileSource fileSource = new SingleRootFileSource(ROOT_PATH);
            String badPath = Paths.get("..", "not-under-root").toAbsolutePath().toString();
            fileSource.writeTextFile(badPath, "stuff");
        });
    }

    @Test
    public void writeBinaryFileThrowsExceptionWhenGivenRelativePathNotUnderRoot() {
        Assertions.assertThrows(NotAuthorisedException.class, () -> {
            SingleRootFileSource fileSource = new SingleRootFileSource(ROOT_PATH);
            fileSource.writeBinaryFile("..", "stuff".getBytes());
        });
    }

    @Test
    public void writeBinaryFileThrowsExceptionWhenGivenAbsolutePathNotUnderRoot() {
        Assertions.assertThrows(NotAuthorisedException.class, () -> {
            SingleRootFileSource fileSource = new SingleRootFileSource(ROOT_PATH);
            String badPath = Paths.get("..", "not-under-root").toAbsolutePath().toString();
            fileSource.writeBinaryFile(badPath, "stuff".getBytes());
        });
    }

    @Test
    public void deleteThrowsExceptionWhenGivenPathNotUnderRoot() {
        Assertions.assertThrows(NotAuthorisedException.class, () -> {
            SingleRootFileSource fileSource = new SingleRootFileSource(ROOT_PATH);
            String badPath = Paths.get("..", "not-under-root").toAbsolutePath().toString();
            fileSource.deleteFile(badPath);
        });
    }

    @Test
    public void readBinaryFileThrowsExceptionWhenRelativePathIsOutsideRoot() {
        Assertions.assertThrows(NotAuthorisedException.class, () -> {
            SingleRootFileSource fileSource = new SingleRootFileSource(ROOT_PATH);
            fileSource.getBinaryFileNamed("../illegal.file");
        });
    }

    @Test
    public void readTextFileThrowsExceptionWhenRelativePathIsOutsideRoot() {
        Assertions.assertThrows(NotAuthorisedException.class, () -> {
            SingleRootFileSource fileSource = new SingleRootFileSource(ROOT_PATH);
            fileSource.getTextFileNamed("../illegal.file");
        });
    }

    @Test
    public void readBinaryFileThrowsExceptionWhenAbsolutePathIsOutsideRoot() throws Exception {
        Assertions.assertThrows(NotAuthorisedException.class, () -> {
            SingleRootFileSource fileSource = new SingleRootFileSource(ROOT_PATH);
            String badPath = new File(ROOT_PATH, "../illegal.file").getCanonicalPath();
            fileSource.getBinaryFileNamed(badPath);
        });
    }

    @Test
    public void readTextFileThrowsExceptionWhenAbsolutePathIsOutsideRoot() throws Exception {
        Assertions.assertThrows(NotAuthorisedException.class, () -> {
            SingleRootFileSource fileSource = new SingleRootFileSource(ROOT_PATH);
            String badPath = new File(ROOT_PATH, "../illegal.file").getCanonicalPath();
            fileSource.getTextFileNamed(badPath);
        });
    }
}

