/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.NetworkAddressRules;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class NetworkAddressRulesTest {
    @Test
    void allowsAddressIncludedAndNotExcluded() {
        NetworkAddressRules rules = NetworkAddressRules.builder().allow("10.1.1.1-10.2.1.1").allow("192.168.1.1-192.168.2.1").deny("10.1.2.3").deny("10.5.5.5").build();
        MatcherAssert.assertThat((Object)rules.isAllowed("192.168.1.111"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)rules.isAllowed("10.1.2.1"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)rules.isAllowed("10.1.2.3"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)rules.isAllowed("10.5.5.5"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void onlyAllowSingleIp() {
        NetworkAddressRules rules = NetworkAddressRules.builder().allow("10.1.1.1").build();
        MatcherAssert.assertThat((Object)rules.isAllowed("10.1.1.1"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)rules.isAllowed("10.1.1.0"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)rules.isAllowed("10.1.1.2"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void onlyDenySingleIp() {
        NetworkAddressRules rules = NetworkAddressRules.builder().deny("10.1.1.1").build();
        MatcherAssert.assertThat((Object)rules.isAllowed("10.1.1.1"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)rules.isAllowed("10.1.1.0"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)rules.isAllowed("10.1.1.2"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void allowAndDenySingleIps() {
        NetworkAddressRules rules = NetworkAddressRules.builder().deny("10.1.1.1").allow("10.1.1.3").build();
        MatcherAssert.assertThat((Object)rules.isAllowed("10.1.1.0"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)rules.isAllowed("10.1.1.1"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)rules.isAllowed("10.1.1.2"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)rules.isAllowed("10.1.1.3"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)rules.isAllowed("10.1.1.4"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void allowRangeAndDenySingleIp() {
        NetworkAddressRules rules = NetworkAddressRules.builder().allow("10.1.1.1-10.1.1.3").deny("10.1.1.2").build();
        MatcherAssert.assertThat((Object)rules.isAllowed("10.1.1.0"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)rules.isAllowed("10.1.1.1"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)rules.isAllowed("10.1.1.2"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)rules.isAllowed("10.1.1.3"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)rules.isAllowed("10.1.1.4"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void denyRangeAndAllowSingleIp() {
        NetworkAddressRules rules = NetworkAddressRules.builder().deny("10.1.1.1-10.1.1.3").allow("10.1.1.2").build();
        MatcherAssert.assertThat((Object)rules.isAllowed("10.1.1.0"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)rules.isAllowed("10.1.1.1"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)rules.isAllowed("10.1.1.2"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)rules.isAllowed("10.1.1.3"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)rules.isAllowed("10.1.1.4"), (Matcher)Matchers.is((Object)false));
    }
}

