/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.NetworkAddressRange;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class NetworkAddressRangeTest {
    @Test
    void singleIpAddress() {
        NetworkAddressRange exclusion = NetworkAddressRange.of((String)"10.1.2.3");
        MatcherAssert.assertThat((Object)exclusion.isIncluded("10.1.2.3"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)exclusion.isIncluded("10.3.2.1"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void ipAddressRange() {
        NetworkAddressRange exclusion = NetworkAddressRange.of((String)"10.1.1.1-10.1.2.2");
        MatcherAssert.assertThat((Object)exclusion.isIncluded("10.1.1.1"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)exclusion.isIncluded("10.1.2.2"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)exclusion.isIncluded("10.1.1.254"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)exclusion.isIncluded("10.1.2.1"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)exclusion.isIncluded("10.3.2.1"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)exclusion.isIncluded("10.1.1.0"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)exclusion.isIncluded("10.1.2.3"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void exactDomainName() {
        NetworkAddressRange exclusion = NetworkAddressRange.of((String)"my.stuff.wiremock.org");
        MatcherAssert.assertThat((Object)exclusion.isIncluded("my.stuff.wiremock.org"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)exclusion.isIncluded("notmy.stuff.wiremock.org"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void domainNameWithWholeNameWildcard() {
        NetworkAddressRange exclusion = NetworkAddressRange.of((String)"*.stuff.wiremock.org");
        MatcherAssert.assertThat((Object)exclusion.isIncluded("my.stuff.wiremock.org"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)exclusion.isIncluded("alsomy.stuff.wiremock.org"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)exclusion.isIncluded("notmy.things.wiremock.org"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void domainNameWithPartialNameWildcard() {
        NetworkAddressRange exclusion = NetworkAddressRange.of((String)"my.*uff.wiremock.org");
        MatcherAssert.assertThat((Object)exclusion.isIncluded("my.stuff.wiremock.org"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)exclusion.isIncluded("my.fluff.wiremock.org"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)exclusion.isIncluded("notmy.stuff.wiremock.org"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void ipAddressResolvedFromDomainName() {
        NetworkAddressRange exclusion = NetworkAddressRange.of((String)"127.0.0.1");
        MatcherAssert.assertThat((Object)exclusion.isIncluded("localhost"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void ipRangeResolvedFromDomainName() {
        NetworkAddressRange exclusion = NetworkAddressRange.of((String)"127.0.0.1-127.0.0.255");
        MatcherAssert.assertThat((Object)exclusion.isIncluded("localhost"), (Matcher)Matchers.is((Object)true));
    }
}

