/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.filemaker.FilenameMaker;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FilenameMakerTest {
    private FilenameMaker filenameMaker;

    @BeforeEach
    public void init() {
        this.filenameMaker = new FilenameMaker();
    }

    @Test
    public void generatesNameFromStubNameWhenPresent() {
        StubMapping mapping = WireMock.get((String)"/named").withName("This is a NAMED stub").willReturn(WireMock.ok()).build();
        MatcherAssert.assertThat((Object)this.filenameMaker.filenameFor(mapping), (Matcher)Matchers.is((Object)("this-is-a-named-stub-" + mapping.getId() + ".json")));
    }

    @Test
    public void generatesNameFromStubUrlWhenNameNotPresent() {
        FilenameMaker makerWithOwnFormat = new FilenameMaker("{{{method}}}-{{{url}}}.json");
        StubMapping mapping = WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/named/123/things")).willReturn(WireMock.ok()).build();
        MatcherAssert.assertThat((Object)makerWithOwnFormat.filenameFor(mapping), (Matcher)Matchers.is((Object)"get-named123things.json"));
    }

    @Test
    public void generatesNameFromStubUrlPathWhenNameNotPresent() {
        FilenameMaker makerWithOwnFormat = new FilenameMaker("{{{method}}}-{{{url}}}.json");
        StubMapping mapping = WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/named/123/things")).willReturn(WireMock.ok()).build();
        MatcherAssert.assertThat((Object)makerWithOwnFormat.filenameFor(mapping), (Matcher)Matchers.is((Object)"get-named123things.json"));
    }

    @Test
    public void generatesNameFromStubUrlPathTemplateWhenNameNotPresent() {
        FilenameMaker makerWithOwnFormat = new FilenameMaker("{{{method}}}-{{{url}}}.json");
        StubMapping mapping = WireMock.get((UrlPattern)WireMock.urlPathTemplate((String)"/named/{id}/things")).willReturn(WireMock.ok()).build();
        MatcherAssert.assertThat((Object)makerWithOwnFormat.filenameFor(mapping), (Matcher)Matchers.is((Object)"get-namedidthings.json"));
    }

    @Test
    public void generatesNameFromStubUrlPatternWhenNameNotPresent() {
        FilenameMaker makerWithOwnFormat = new FilenameMaker("{{{method}}}-{{{url}}}.json");
        StubMapping mapping = WireMock.get((UrlPattern)WireMock.urlMatching((String)"/named/([0-9]*)/things")).willReturn(WireMock.ok()).build();
        MatcherAssert.assertThat((Object)makerWithOwnFormat.filenameFor(mapping), (Matcher)Matchers.is((Object)"get-named0-9things.json"));
    }

    @Test
    public void generatesNameWhenStubUrlIsAnyAndNameNotPresent() {
        StubMapping mapping = WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok()).build();
        FilenameMaker makerWithOwnFormat = new FilenameMaker("{{{id}}}.json");
        MatcherAssert.assertThat((Object)makerWithOwnFormat.filenameFor(mapping), (Matcher)Matchers.is((Object)(mapping.getId() + ".json")));
    }

    @Test
    public void sanitizesUrlWithCharactersSafeForFilenames() {
        String output = this.filenameMaker.sanitizeUrl("/hello/1/2/3__!/\u1eae\u010c\u0116--ace/\u00a5$$/$/and/\u00bf?");
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.is((Object)"hello_1_2_3___ace--ace___and"));
    }

    @Test
    void generatesSanitizedFilename() {
        String filename = this.filenameMaker.filenameFor(WireMock.get((String)"/hello/1/2/3__!/\u1eae\u010c\u0116--ace/\u00a5$$/$/and/\u00bf?").willReturn(WireMock.ok()).build());
        MatcherAssert.assertThat((Object)filename, (Matcher)Matchers.startsWith((String)"get-hello123__--aceand-"));
    }

    @Test
    public void truncatesWhenResultingNameOver200Chars() {
        String output = this.filenameMaker.sanitizeUrl("/hello/1/2/3__!/\u1eae\u010c\u0116--ace/\u00a5$$/$/andverylongstuffandverylongstuffandverylongstuffandverylongstuffandverylongstuffandverylongstuffandverylongstuffandverylongstuffandverylongstuffandverylongstuffandverylongstuffandverylongstuffandverylongstuff/\u00bf?");
        MatcherAssert.assertThat((Object)output.length(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    void includesStubNameWhenPresent() {
        StubMapping stub = (StubMapping)Json.read((String)"{\n    \"name\": \"This is a NAMED stub\",\n    \"persistent\": true,\n    \"request\": {\n        \"urlPath\": \"/one/two/three\",\n        \"method\": \"GET\"\n    },\n\n    \"response\": {\n        \"status\": 200\n    }\n}\n", StubMapping.class);
        String filename = this.filenameMaker.filenameFor(stub);
        MatcherAssert.assertThat((Object)filename, (Matcher)Matchers.is((Object)("this-is-a-named-stub-" + stub.getId() + ".json")));
    }

    @Test
    void handlesAnAllDefaultsStub() {
        StubMapping stubMapping = (StubMapping)Json.read((String)"{}", StubMapping.class);
        String filename = this.filenameMaker.filenameFor(stubMapping);
        MatcherAssert.assertThat((Object)filename, (Matcher)Matchers.startsWith((String)"any-always-"));
    }
}

