/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.DateTimeTruncation;
import java.time.ZonedDateTime;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class DateTimeTruncationTest {
    @Test
    public void firstSecondOfMinute() {
        ZonedDateTime input = ZonedDateTime.parse("2021-06-18T10:11:12Z");
        ZonedDateTime output = DateTimeTruncation.FIRST_SECOND_OF_MINUTE.truncate(input);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.is((Object)ZonedDateTime.parse("2021-06-18T10:11:00Z")));
    }

    @Test
    public void firstMinuteOfHour() {
        ZonedDateTime input = ZonedDateTime.parse("2021-06-18T10:11:12Z");
        ZonedDateTime output = DateTimeTruncation.FIRST_MINUTE_OF_HOUR.truncate(input);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.is((Object)ZonedDateTime.parse("2021-06-18T10:00:00Z")));
    }

    @Test
    public void firstHourOfDay() {
        ZonedDateTime input = ZonedDateTime.parse("2021-06-18T10:11:12Z");
        ZonedDateTime output = DateTimeTruncation.FIRST_HOUR_OF_DAY.truncate(input);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.is((Object)ZonedDateTime.parse("2021-06-18T00:00:00Z")));
    }

    @Test
    public void firstDayOfMonth() {
        ZonedDateTime input = ZonedDateTime.parse("2021-06-18T10:11:12Z");
        ZonedDateTime output = DateTimeTruncation.FIRST_DAY_OF_MONTH.truncate(input);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.is((Object)ZonedDateTime.parse("2021-06-01T00:00:00Z")));
    }

    @Test
    public void firstDayOfNextMonth() {
        ZonedDateTime input = ZonedDateTime.parse("2021-06-18T10:11:12Z");
        ZonedDateTime output = DateTimeTruncation.FIRST_DAY_OF_NEXT_MONTH.truncate(input);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.is((Object)ZonedDateTime.parse("2021-07-01T00:00:00Z")));
    }

    @Test
    public void lastDayOfMonth() {
        ZonedDateTime input = ZonedDateTime.parse("2021-06-18T10:11:12Z");
        ZonedDateTime output = DateTimeTruncation.LAST_DAY_OF_MONTH.truncate(input);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.is((Object)ZonedDateTime.parse("2021-06-30T00:00:00Z")));
    }

    @Test
    public void firstDayOfYear() {
        ZonedDateTime input = ZonedDateTime.parse("2021-06-18T10:11:12Z");
        ZonedDateTime output = DateTimeTruncation.FIRST_DAY_OF_YEAR.truncate(input);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.is((Object)ZonedDateTime.parse("2021-01-01T00:00:00Z")));
    }

    @Test
    public void firstDayOfNextYear() {
        ZonedDateTime input = ZonedDateTime.parse("2021-06-18T10:11:12Z");
        ZonedDateTime output = DateTimeTruncation.FIRST_DAY_OF_NEXT_YEAR.truncate(input);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.is((Object)ZonedDateTime.parse("2022-01-01T00:00:00Z")));
    }

    @Test
    public void lastDayOfYear() {
        ZonedDateTime input = ZonedDateTime.parse("2021-06-18T10:11:12Z");
        ZonedDateTime output = DateTimeTruncation.LAST_DAY_OF_YEAR.truncate(input);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.is((Object)ZonedDateTime.parse("2021-12-31T00:00:00Z")));
    }

    @Test
    public void parsesFromFriendlyString() {
        MatcherAssert.assertThat((Object)DateTimeTruncation.fromString((String)"last day of year"), (Matcher)Matchers.is((Object)DateTimeTruncation.LAST_DAY_OF_YEAR));
    }

    @Test
    public void toStringReturnsFriendlyString() {
        MatcherAssert.assertThat((Object)DateTimeTruncation.FIRST_DAY_OF_MONTH.toString(), (Matcher)Matchers.is((Object)"first day of month"));
    }
}

