/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.DateTimeParser;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class DateTimeParserTest {
    @Test
    public void parsesFromDateTimeFormatter() {
        DateTimeParser parser = DateTimeParser.forFormatter((DateTimeFormatter)DateTimeFormatter.ISO_DATE_TIME);
        MatcherAssert.assertThat((Object)parser.parseZonedDateTime("2021-06-23T11:12:13Z"), (Matcher)Matchers.is((Object)ZonedDateTime.parse("2021-06-23T11:12:13Z")));
        MatcherAssert.assertThat((Object)parser.parseLocalDateTime("2021-06-23T11:12:13"), (Matcher)Matchers.is((Object)LocalDateTime.parse("2021-06-23T11:12:13")));
    }

    @Test
    public void parsesZonedFromFormatString() {
        DateTimeParser parser = DateTimeParser.forFormat((String)"dd/MM/yyyy HH:mm:ss Z");
        MatcherAssert.assertThat((Object)parser.parseZonedDateTime("23/06/2021 11:22:33 +0000"), (Matcher)Matchers.is((Object)ZonedDateTime.parse("2021-06-23T11:22:33Z")));
    }

    @Test
    public void parsesLocalDateTimeFromFormatString() {
        DateTimeParser parser = DateTimeParser.forFormat((String)"dd/MM/yyyy HH:mm:ss");
        MatcherAssert.assertThat((Object)parser.parseLocalDateTime("23/06/2021 11:12:13"), (Matcher)Matchers.is((Object)LocalDateTime.parse("2021-06-23T11:12:13")));
    }

    @Test
    public void parsesLocalDateFromFormatString() {
        DateTimeParser parser = DateTimeParser.forFormat((String)"dd/MM/yyyy");
        MatcherAssert.assertThat((Object)parser.parseLocalDate("23/06/2021"), (Matcher)Matchers.is((Object)LocalDate.parse("2021-06-23")));
    }

    @Test
    public void parsesUnix() {
        DateTimeParser parser = DateTimeParser.forFormat((String)"unix");
        MatcherAssert.assertThat((Object)parser.parseZonedDateTime("1624447353"), (Matcher)Matchers.is((Object)ZonedDateTime.parse("2021-06-23T11:22:33Z")));
        MatcherAssert.assertThat((Object)parser.parseLocalDateTime("1624447353"), (Matcher)Matchers.is((Object)LocalDateTime.parse("2021-06-23T11:22:33")));
    }

    @Test
    public void parsesEpoch() {
        DateTimeParser parser = DateTimeParser.forFormat((String)"epoch");
        MatcherAssert.assertThat((Object)parser.parseZonedDateTime("1624447353000"), (Matcher)Matchers.is((Object)ZonedDateTime.parse("2021-06-23T11:22:33Z")));
        MatcherAssert.assertThat((Object)parser.parseLocalDateTime("1624447353000"), (Matcher)Matchers.is((Object)LocalDateTime.parse("2021-06-23T11:22:33")));
    }
}

