/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.github.tomakehurst.wiremock.common.DateTimeOffset;
import com.github.tomakehurst.wiremock.common.DateTimeUnit;
import java.text.DateFormat;
import java.time.ZonedDateTime;
import java.util.Date;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DateTimeOffsetTest {
    static final DateFormat ISO8601 = new ISO8601DateFormat();

    @Test
    public void parsesSecondsOffset() {
        DateTimeOffset offset = DateTimeOffset.fromString((String)"7 seconds");
        MatcherAssert.assertThat((Object)offset.getAmountUnit(), (Matcher)Matchers.is((Object)DateTimeUnit.SECONDS));
        MatcherAssert.assertThat((Object)offset.getAmount(), (Matcher)Matchers.is((Object)7));
    }

    @Test
    public void parsesMinutesOffset() {
        DateTimeOffset offset = DateTimeOffset.fromString((String)"78 minutes");
        MatcherAssert.assertThat((Object)offset.getAmountUnit(), (Matcher)Matchers.is((Object)DateTimeUnit.MINUTES));
        MatcherAssert.assertThat((Object)offset.getAmount(), (Matcher)Matchers.is((Object)78));
    }

    @Test
    public void parsesHoursOffset() {
        DateTimeOffset offset = DateTimeOffset.fromString((String)"-12 hours");
        MatcherAssert.assertThat((Object)offset.getAmountUnit(), (Matcher)Matchers.is((Object)DateTimeUnit.HOURS));
        MatcherAssert.assertThat((Object)offset.getAmount(), (Matcher)Matchers.is((Object)-12));
    }

    @Test
    public void parsesDaysOffset() {
        DateTimeOffset offset = DateTimeOffset.fromString((String)"1 days");
        MatcherAssert.assertThat((Object)offset.getAmountUnit(), (Matcher)Matchers.is((Object)DateTimeUnit.DAYS));
        MatcherAssert.assertThat((Object)offset.getAmount(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void parsesMonthsOffset() {
        DateTimeOffset offset = DateTimeOffset.fromString((String)"-12 months");
        MatcherAssert.assertThat((Object)offset.getAmountUnit(), (Matcher)Matchers.is((Object)DateTimeUnit.MONTHS));
        MatcherAssert.assertThat((Object)offset.getAmount(), (Matcher)Matchers.is((Object)-12));
    }

    @Test
    public void parsesYearsOffset() {
        DateTimeOffset offset = DateTimeOffset.fromString((String)"101 years");
        MatcherAssert.assertThat((Object)offset.getAmountUnit(), (Matcher)Matchers.is((Object)DateTimeUnit.YEARS));
        MatcherAssert.assertThat((Object)offset.getAmount(), (Matcher)Matchers.is((Object)101));
    }

    @Test
    public void parsesPositiveLongForm() {
        DateTimeOffset offset = DateTimeOffset.fromString((String)"now +101 years");
        MatcherAssert.assertThat((Object)offset.getAmountUnit(), (Matcher)Matchers.is((Object)DateTimeUnit.YEARS));
        MatcherAssert.assertThat((Object)offset.getAmount(), (Matcher)Matchers.is((Object)101));
    }

    @Test
    public void parsesNegativeLongForm() {
        DateTimeOffset offset = DateTimeOffset.fromString((String)"now -5 months");
        MatcherAssert.assertThat((Object)offset.getAmountUnit(), (Matcher)Matchers.is((Object)DateTimeUnit.MONTHS));
        MatcherAssert.assertThat((Object)offset.getAmount(), (Matcher)Matchers.is((Object)-5));
    }

    @Test
    public void returnsCorrectToString() {
        MatcherAssert.assertThat((Object)DateTimeOffset.fromString((String)"123 minutes").toString(), (Matcher)Matchers.is((Object)"123 minutes"));
        MatcherAssert.assertThat((Object)DateTimeOffset.fromString((String)"-72 hours").toString(), (Matcher)Matchers.is((Object)"-72 hours"));
    }

    @Test
    public void canBeConstructedFromParts() {
        MatcherAssert.assertThat((Object)new DateTimeOffset(67, DateTimeUnit.DAYS).toString(), (Matcher)Matchers.is((Object)"67 days"));
        MatcherAssert.assertThat((Object)new DateTimeOffset(-12, DateTimeUnit.SECONDS).toString(), (Matcher)Matchers.is((Object)"-12 seconds"));
    }

    @Test
    public void shiftsZonedDateTimes() {
        DateTimeOffset positiveDateOffset = new DateTimeOffset(10, DateTimeUnit.DAYS);
        MatcherAssert.assertThat((Object)positiveDateOffset.shift(ZonedDateTime.parse("2021-06-18T00:00:00Z")), (Matcher)Matchers.is((Object)ZonedDateTime.parse("2021-06-28T00:00:00Z")));
        DateTimeOffset negativeDateOffset = new DateTimeOffset(-4, DateTimeUnit.MONTHS);
        MatcherAssert.assertThat((Object)negativeDateOffset.shift(ZonedDateTime.parse("2021-06-18T00:00:00Z")), (Matcher)Matchers.is((Object)ZonedDateTime.parse("2021-02-18T00:00:00Z")));
    }

    @Test
    public void offsetsProvidedDateByConfiguredAmount() throws Exception {
        DateTimeOffset offset = DateTimeOffset.fromString((String)"3 days");
        Date startingDate = ISO8601.parse("2018-04-16T12:01:01Z");
        Date finalDate = offset.shift(startingDate);
        MatcherAssert.assertThat((Object)ISO8601.format(finalDate), (Matcher)Matchers.is((Object)"2018-04-19T12:01:01Z"));
    }

    @Test
    public void throwsExceptionWhenUnparseableStringProvided() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateTimeOffset.fromString((String)"101"));
    }

    @Test
    public void throwsExceptionWhenUnparseableUnitProvided() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateTimeOffset.fromString((String)"101 squillions"));
    }
}

