/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.archunit;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import com.github.tomakehurst.wiremock.standalone.WireMockServerRunner;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.core.importer.ImportOption;
import com.tngtech.archunit.junit.AnalyzeClasses;
import com.tngtech.archunit.junit.ArchIgnore;
import com.tngtech.archunit.junit.ArchTest;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.GivenMethodsConjunction;
import com.tngtech.archunit.library.freeze.FreezingArchRule;
import java.util.HashSet;
import java.util.function.Predicate;

@AnalyzeClasses(packagesOf={WireMockServer.class}, importOptions={ImportOption.DoNotIncludeArchives.class, ImportOption.DoNotIncludeJars.class, ImportOption.DoNotIncludeTests.class})
class UnusedCodeTest {
    private static ArchCondition<? super JavaClass> beReferencedClass = new ArchCondition<JavaClass>("be referenced", new Object[0]){

        public void check(JavaClass javaClass, ConditionEvents events) {
            HashSet accesses = new HashSet(javaClass.getAccessesToSelf());
            accesses.removeAll(javaClass.getAccessesFromSelf());
            if (accesses.isEmpty() && javaClass.getDirectDependenciesToSelf().isEmpty()) {
                events.add((ConditionEvent)new SimpleConditionEvent((Object)javaClass, false, String.format("%s is unreferenced in %s", javaClass.getDescription(), javaClass.getSourceCodeLocation())));
            }
        }
    };
    @ArchTest
    static ArchRule classesShouldNotBeUnused = ((ArchRule)ArchRuleDefinition.classes().that(DescribedPredicate.describe((String)"do not implement interface", clazz -> clazz.getAllRawInterfaces().isEmpty())).and(DescribedPredicate.describe((String)"do not extend class", clazz -> 1 == clazz.getAllRawSuperclasses().size())).and(DescribedPredicate.not((DescribedPredicate)JavaClass.Predicates.assignableTo(WireMockServerRunner.class))).should(beReferencedClass).as("should use all classes")).because("unused classes should be removed");
    private static ArchCondition<? super JavaMethod> beReferencedMethod = new ArchCondition<JavaMethod>("be referenced", new Object[0]){

        public void check(JavaMethod javaMethod, ConditionEvents events) {
            HashSet accesses = new HashSet(javaMethod.getAccessesToSelf());
            accesses.removeAll(javaMethod.getAccessesFromSelf());
            if (accesses.isEmpty()) {
                events.add((ConditionEvent)new SimpleConditionEvent((Object)javaMethod, false, String.format("%s is unreferenced in %s", javaMethod.getDescription(), javaMethod.getSourceCodeLocation())));
            }
        }
    };
    @ArchTest
    @ArchIgnore(reason="Disabled due to the potential for false positives in a public API; use to audit sporadically")
    static ArchRule methodsShouldNotBeUnused = FreezingArchRule.freeze((ArchRule)((ArchRule)((GivenMethodsConjunction)((GivenMethodsConjunction)((GivenMethodsConjunction)((GivenMethodsConjunction)((GivenMethodsConjunction)ArchRuleDefinition.methods().that(DescribedPredicate.describe((String)"are not declared in super type", input -> !input.getOwner().getAllRawSuperclasses().stream().flatMap(c -> c.getMethods().stream()).anyMatch(UnusedCodeTest.hasMatchingNameAndParameters(input)))).and(DescribedPredicate.describe((String)"are not declared in interface", input -> !input.getOwner().getAllRawInterfaces().stream().flatMap(i -> i.getMethods().stream()).anyMatch(UnusedCodeTest.hasMatchingNameAndParameters(input)))).and().doNotHaveName("main")).and().haveNameNotContaining("lambda")).and(DescribedPredicate.not((DescribedPredicate)JavaMember.Predicates.declaredIn((DescribedPredicate)JavaClass.Predicates.ENUMS.or(JavaClass.Predicates.ANNOTATIONS)))).and(DescribedPredicate.not((DescribedPredicate)JavaMember.Predicates.declaredIn((DescribedPredicate)DescribedPredicate.describe((String)"are not declared in Builder", input -> input.getName().endsWith("Builder"))))).and().areNotDeclaredIn(WireMock.class)).and().areNotDeclaredIn(WireMockConfiguration.class)).and().areNotDeclaredIn(WireMockExtension.class)).and(DescribedPredicate.not((DescribedPredicate)DescribedPredicate.describe((String)"are not getters", input -> input.getParameterTypes().isEmpty() && (input.getName().startsWith("get") || input.getName().startsWith("is"))))).and(DescribedPredicate.not((DescribedPredicate)DescribedPredicate.describe((String)"are not builders", input -> input.getParameterTypes().size() <= 1 && input.getOwner().tryGetField(input.getName()).isPresent()))).should(beReferencedMethod).as("should use all methods")).because("unused methods should be removed"));
    @ArchTest
    static ArchRule nonPublicMethodsShouldNotBeUnusedFrozen = ((ArchRule)((GivenMethodsConjunction)((GivenMethodsConjunction)ArchRuleDefinition.methods().that(DescribedPredicate.describe((String)"are not declared in super type", input -> !input.getOwner().getAllRawSuperclasses().stream().flatMap(c -> c.getMethods().stream()).anyMatch(UnusedCodeTest.hasMatchingNameAndParameters(input)))).and(DescribedPredicate.describe((String)"are not declared in interface", input -> !input.getOwner().getAllRawInterfaces().stream().flatMap(i -> i.getMethods().stream()).anyMatch(UnusedCodeTest.hasMatchingNameAndParameters(input)))).and().haveNameNotContaining("lambda")).and().areNotPublic()).should(beReferencedMethod).as("should use all non public methods")).because("unused methods should be removed");

    UnusedCodeTest() {
    }

    private static Predicate<JavaMethod> hasMatchingNameAndParameters(JavaMethod input) {
        return m -> m.getName().equals(input.getName()) && m.getRawParameterTypes().size() == input.getRawParameterTypes().size() && (m.getDescriptor().equals(input.getDescriptor()) || HasName.Utils.namesOf((Iterable)m.getRawParameterTypes()).containsAll(HasName.Utils.namesOf((Iterable)input.getRawParameterTypes())));
    }
}

