/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.InvalidInputException;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UrlPathTemplateMatchingTest
extends AcceptanceTestBase {
    @Test
    void matches_path_template_without_bound_variable() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathTemplate((String)"/v1/contacts/{contactId}")).willReturn(WireMock.ok()));
        MatcherAssert.assertThat((Object)testClient.get("/v1/contacts/12345", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)testClient.get("/v1/contacts/23456", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)testClient.get("/v2/contacts/23456", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    void matches_path_template_with_single_bound_variable() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathTemplate((String)"/v1/contacts/{contactId}/addresses/{addressId}")).withPathParam("contactId", WireMock.equalTo((String)"12345")).withPathParam("addressId", WireMock.equalTo((String)"99876")).willReturn(WireMock.ok()));
        MatcherAssert.assertThat((Object)testClient.get("/v1/contacts/12345/addresses/99876", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)testClient.get("/v1/contacts/12345/addresses/55555", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((Object)testClient.get("/v1/contacts/23456/addresses/99876", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((Object)testClient.get("/v1/contacts/23456/addresses/55555", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    void returns_non_match_without_error_when_request_url_path_does_not_match_template() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathTemplate((String)"/contacts/{contactId}/addresses/{addressId}")).withPathParam("contactId", WireMock.equalTo((String)"123")).willReturn(WireMock.ok()));
        WireMockResponse response = testClient.get("/contacts/123/addresssssses/1", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.containsString((String)"Request was not matched"));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    void static_dsl_throws_error_when_attempting_to_use_path_param_matchers_without_path_template() {
        Assertions.assertThrows(InvalidInputException.class, () -> WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/stuff")).withPathParam("wrong", WireMock.containing((String)"things")).willReturn(WireMock.ok())));
    }

    @Test
    void instance_dsl_throws_error_when_attempting_to_use_path_param_matchers_without_path_template() {
        Assertions.assertThrows(InvalidInputException.class, () -> wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/stuff")).withPathParam("wrong", WireMock.containing((String)"things")).willReturn(WireMock.ok())));
    }
}

