/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.jknack.handlebars.Helper;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.TemplateHelperProviderExtension;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import java.util.Map;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TemplateHelperExtensionTest {
    @RegisterExtension
    public WireMockExtension wm = WireMockExtension.newInstance().options((Options)WireMockConfiguration.wireMockConfig().dynamicPort().templatingEnabled(true).globalTemplating(true).extensions(new Extension[]{new TemplateHelperProviderExtension(){

        public String getName() {
            return "custom-helpers";
        }

        public Map<String, Helper<?>> provideTemplateHelpers() {
            Helper helper = (context, options) -> context.length();
            return Map.of("string-length", helper);
        }
    }})).build();
    WireMockTestClient client;

    @BeforeEach
    void init() {
        this.client = new WireMockTestClient(this.wm.getPort());
    }

    @Test
    void appliesHelpersFromProvider() {
        this.wm.stubFor(WireMock.post((String)"/things").willReturn(WireMock.ok((String)"{{{ string-length request.body }}}")));
        WireMockResponse response = this.client.post("/things", (HttpEntity)new StringEntity("fiver"), new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"5"));
    }
}

