/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.verification.diff.DiffEventData;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class SubServeEventsAcceptanceTest
extends AcceptanceTestBase {
    @Test
    void nonMatchDiffsAreSavedAsSubEvents() {
        wm.stubFor(WireMock.get((String)"/right").willReturn(WireMock.ok()));
        testClient.get("/wrong", new TestHttpHeader[0]);
        ServeEvent serveEvent = (ServeEvent)wm.getAllServeEvents().get(0);
        SubEvent subEvent = (SubEvent)serveEvent.getSubEvents().stream().findFirst().get();
        MatcherAssert.assertThat((Object)subEvent.getType(), (Matcher)Matchers.is((Object)"REQUEST_NOT_MATCHED"));
        MatcherAssert.assertThat((Object)subEvent.getTimeOffsetNanos(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        MatcherAssert.assertThat((Object)((DiffEventData)subEvent.getDataAs(DiffEventData.class)).getReport(), (Matcher)Matchers.containsString((String)"/wrong"));
    }

    @Test
    void errorsDuringMatchingAreCapturedInSubEvents() {
        wm.stubFor(WireMock.post((String)"/json").withRequestBody((ContentPattern)WireMock.equalToJson((String)"{ \"thing\": \"value\" }")).willReturn(WireMock.ok()));
        testClient.postJson("/json", "{ \"thing\": ", new TestHttpHeader[0]);
        ServeEvent serveEvent = (ServeEvent)wm.getAllServeEvents().get(0);
        SubEvent failedJsonParseWarning = serveEvent.getSubEvents().stream().filter(sub -> sub.getType().equals("JSON_ERROR")).findFirst().get();
        Errors.Error error = (Errors.Error)((Errors)failedJsonParseWarning.getDataAs(Errors.class)).getErrors().stream().findFirst().get();
        MatcherAssert.assertThat((Object)error.getDetail(), (Matcher)Matchers.containsString((String)"Unexpected end-of-input within/between Object entries"));
    }
}

