/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.admin.model.ListStubMappingsResult;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.DateTimeTruncation;
import com.github.tomakehurst.wiremock.common.DateTimeUnit;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.testsupport.MultipartBody;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.MalformedChunkCodingException;
import org.apache.hc.core5.http.NoHttpResponseException;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class StubbingAcceptanceTest
extends AcceptanceTestBase {
    @BeforeAll
    public static void setupServer() {
        StubbingAcceptanceTest.setupServerWithMappingsInFileRoot();
    }

    @Test
    public void mappingWithExactUrlAndMethodMatch() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/a/registered/resource")).willReturn(WireMock.aResponse().withStatus(401).withHeader("Content-Type", new String[]{"text/plain"}).withBody("Not allowed!")));
        WireMockResponse response = testClient.get("/a/registered/resource", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)401));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"Not allowed!"));
        MatcherAssert.assertThat((Object)response.firstHeader("Content-Type"), (Matcher)Matchers.is((Object)"text/plain"));
    }

    @Test
    public void mappingWithUrlContainingQueryParameters() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/search?name=John&postcode=N44LL")).willReturn(WireMock.aResponse().withHeader("Location", new String[]{"/nowhere"}).withStatus(302)));
        WireMockResponse response = testClient.get("/search?name=John&postcode=N44LL", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)302));
    }

    @Test
    public void mappingWithHeaderMatchers() {
        WireMock.stubFor((MappingBuilder)WireMock.put((UrlPattern)WireMock.urlEqualTo((String)"/some/url")).withHeader("One", WireMock.equalTo((String)"abcd1234")).withHeader("Two", WireMock.matching((String)"[a-z]{5}")).withHeader("Three", WireMock.notMatching((String)"[A-Z]+")).willReturn(WireMock.aResponse().withStatus(204)));
        WireMockResponse response = testClient.put("/some/url", TestHttpHeader.withHeader("One", "abcd1234"), TestHttpHeader.withHeader("Two", "thing"), TestHttpHeader.withHeader("Three", "something"));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)204));
    }

    @Test
    public void mappingWithCaseInsensitiveHeaderMatchers() {
        WireMock.stubFor((MappingBuilder)WireMock.put((UrlPattern)WireMock.urlEqualTo((String)"/case/insensitive")).withHeader("ONE", WireMock.equalTo((String)"abcd1234")).withHeader("two", WireMock.matching((String)"[a-z]{5}")).withHeader("Three", WireMock.notMatching((String)"[A-Z]+")).willReturn(WireMock.aResponse().withStatus(204)));
        WireMockResponse response = testClient.put("/case/insensitive", TestHttpHeader.withHeader("one", "abcd1234"), TestHttpHeader.withHeader("TWO", "thing"), TestHttpHeader.withHeader("tHrEe", "something"));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)204));
    }

    @Test
    public void doesNotMatchOnAbsentHeader() {
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/some/url")).withRequestBody((ContentPattern)WireMock.containing((String)"BODY")).withHeader("NoSuchHeader", WireMock.equalTo((String)"This better not be here")).willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)testClient.postWithBody("/some/url", "BODY", "text/plain", "utf-8").statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void matchesIfRequestContainsHeaderNotSpecified() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/some/extra/header")).withHeader("ExpectedHeader", WireMock.equalTo((String)"expected-value")).willReturn(WireMock.aResponse().withStatus(200)));
        WireMockResponse response = testClient.get("/some/extra/header", TestHttpHeader.withHeader("ExpectedHeader", "expected-value"), TestHttpHeader.withHeader("UnexpectedHeader", "unexpected-value"));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void matchesOnUrlPathAndQueryParameters() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/path-and-query/match")).withQueryParam("search", WireMock.containing((String)"WireMock")).withQueryParam("since", WireMock.equalTo((String)"2014-10-14")).willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)testClient.get("/path-and-query/match?since=2014-10-14&search=WireMock%20stubbing", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void matchesOnUrlPathAndMultipleQueryParameters() {
        HashMap<String, StringValuePattern> queryParameters = new HashMap<String, StringValuePattern>();
        queryParameters.put("search", WireMock.containing((String)"WireMock"));
        queryParameters.put("since", WireMock.equalTo((String)"2018-03-02"));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/path-and-query/match")).withQueryParams(queryParameters).willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)testClient.get("/path-and-query/match?since=2018-03-02&search=WireMock%20stubbing", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void doesNotMatchOnUrlPathWhenExtraPathElementsPresent() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/matching-path")).willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)testClient.get("/matching-path/extra", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void doesNotMatchOnUrlPathWhenPathShorter() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/matching-path")).willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)testClient.get("/matching", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void matchesOnUrlPathPatternAndQueryParameters() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathMatching((String)"/path(.*)/match")).withQueryParam("search", WireMock.containing((String)"WireMock")).withQueryParam("since", WireMock.equalTo((String)"2014-10-14")).willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)testClient.get("/path-and-query/match?since=2014-10-14&search=WireMock%20stubbing", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void matchesOnUrlPathPatternAndMultipleQueryParameters() {
        HashMap<String, StringValuePattern> queryParameters = new HashMap<String, StringValuePattern>();
        queryParameters.put("search", WireMock.containing((String)"WireMock"));
        queryParameters.put("since", WireMock.equalTo((String)"2018-03-02"));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathMatching((String)"/path(.*)/match")).withQueryParams(queryParameters).willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)testClient.get("/path-and-query/match?since=2018-03-02&search=WireMock%20stubbing", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void doesNotMatchOnUrlPathPatternWhenPathShorter() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathMatching((String)"/matching-path")).willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)testClient.get("/matching", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void doesNotMatchOnUrlPathPatternWhenExtraPathPresent() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathMatching((String)"/matching-path")).willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)testClient.get("/matching-path/extra", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void doesNotMatchIfSpecifiedQueryParameterNotInRequest() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/path-and-query/match")).withQueryParam("search", WireMock.containing((String)"WireMock")).willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)testClient.get("/path-and-query/match?wrongParam=wrongVal", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void doesNotMatchIfSpecifiedAbsentQueryParameterIsPresentInRequest() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/path-and-query/match")).withQueryParam("search", WireMock.absent()).willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)testClient.get("/path-and-query/match?search=presentwhoops", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void matchesIfSpecifiedAbsentQueryParameterIsAbsentFromRequest() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/path-and-query/match")).withQueryParam("search", WireMock.absent()).willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)testClient.get("/path-and-query/match?anotherparam=present", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void matchesOnQueryParametersNotContaining() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/query/match")).withQueryParam("search", WireMock.notContaining((String)"WireMock")).willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)testClient.get("/query/match?search=WireMock%20stubbing", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((Object)testClient.get("/query/match?search=Other%20stubbing", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void responseBodyLoadedFromFile() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/my/file")).willReturn(WireMock.aResponse().withStatus(200).withBodyFile("plain-example.txt")));
        WireMockResponse response = testClient.get("/my/file", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"Some example test from a file"));
    }

    @Test
    public void matchingOnRequestBodyWithTwoRegexes() {
        WireMock.stubFor((MappingBuilder)WireMock.put((UrlPattern)WireMock.urlEqualTo((String)"/match/this/body")).withRequestBody((ContentPattern)WireMock.matching((String)".*Blah.*")).withRequestBody((ContentPattern)WireMock.matching((String)".*@[0-9]{5}@.*")).willReturn(WireMock.aResponse().withStatus(200).withBodyFile("plain-example.txt")));
        WireMockResponse response = testClient.putWithBody("/match/this/body", "Blah...but not the rest", "text/plain", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        response = testClient.putWithBody("/match/this/body", "@12345@...but not the rest", "text/plain", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        response = testClient.putWithBody("/match/this/body", "BlahBlah@56565@Blah", "text/plain", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void matchingOnRequestBodyWithAContainsAndANegativeRegex() {
        WireMock.stubFor((MappingBuilder)WireMock.put((UrlPattern)WireMock.urlEqualTo((String)"/match/this/body/too")).withRequestBody((ContentPattern)WireMock.containing((String)"Blah")).withRequestBody((ContentPattern)WireMock.notMatching((String)".*[0-9]+.*")).willReturn(WireMock.aResponse().withStatus(200).withBodyFile("plain-example.txt")));
        WireMockResponse response = testClient.putWithBody("/match/this/body/too", "Blah12345", "text/plain", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        response = testClient.putWithBody("/match/this/body/too", "BlahBlahBlah", "text/plain", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void matchingOnRequestBodyWithNotContaining() {
        WireMock.stubFor((MappingBuilder)WireMock.put((UrlPattern)WireMock.urlEqualTo((String)"/match/this/body/too")).withRequestBody((ContentPattern)WireMock.notContaining((String)"OtherBody")).willReturn(WireMock.aResponse().withStatus(200).withBodyFile("plain-example.txt")));
        WireMockResponse response = testClient.putWithBody("/match/this/body/too", "BlahOtherBody12345", "text/plain", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        response = testClient.putWithBody("/match/this/body/too", "BlahBlahBlah", "text/plain", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void matchingOnRequestBodyWithEqualTo() {
        WireMock.stubFor((MappingBuilder)WireMock.put((UrlPattern)WireMock.urlEqualTo((String)"/match/this/body/too")).withRequestBody((ContentPattern)WireMock.equalTo((String)"BlahBlahBlah")).willReturn(WireMock.aResponse().withStatus(200).withBodyFile("plain-example.txt")));
        WireMockResponse response = testClient.putWithBody("/match/this/body/too", "Blah12345", "text/plain", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        response = testClient.putWithBody("/match/this/body/too", "BlahBlahBlah", "text/plain", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void matchingOnRequestBodyWithBinaryEqualTo() {
        byte[] requestBody = new byte[]{1, 2, 3};
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/match/binary").withRequestBody((ContentPattern)WireMock.binaryEqualTo((byte[])requestBody)).willReturn(WireMock.ok((String)"Matched binary")));
        WireMockResponse response = testClient.post("/match/binary", (HttpEntity)new ByteArrayEntity(new byte[]{9}, ContentType.APPLICATION_OCTET_STREAM), new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        response = testClient.post("/match/binary", (HttpEntity)new ByteArrayEntity(requestBody, ContentType.APPLICATION_OCTET_STREAM), new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void matchingOnRequestBodyWithAdvancedJsonPath() {
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/jsonpath/advanced").withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.counter", (StringValuePattern)WireMock.equalTo((String)"123"))).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.wrong", (StringValuePattern)WireMock.absent())).willReturn(WireMock.ok()));
        WireMockResponse response = testClient.postJson("/jsonpath/advanced", "{ \"counter\": 234 }", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        response = testClient.postJson("/jsonpath/advanced", "{ \"counter\": 123 }", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void matchingOnRequestBodyWithAdvancedXPath() {
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/xpath/advanced").withRequestBody((ContentPattern)WireMock.matchingXPath((String)"//counter/text()", (StringValuePattern)WireMock.equalTo((String)"123"))).willReturn(WireMock.ok()));
        WireMockResponse response = testClient.postXml("/xpath/advanced", "<counter>6666</counter>", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        response = testClient.postXml("/xpath/advanced", "<counter>123</counter>", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void highPriorityMappingMatchedFirst() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlMatching((String)"/priority/.*")).atPriority(Integer.valueOf(10)).willReturn(WireMock.aResponse().withStatus(500)));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/priority/resource")).atPriority(Integer.valueOf(2)).willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)testClient.get("/priority/resource", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void connectionResetByPeerFault() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/connection/reset")).willReturn(WireMock.aResponse().withFault(Fault.CONNECTION_RESET_BY_PEER)));
        RuntimeException runtimeException = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> testClient.get("/connection/reset", new TestHttpHeader[0]));
        MatcherAssert.assertThat((Object)runtimeException.getMessage(), (Matcher)Matchers.is((Object)"java.net.SocketException: Connection reset"));
    }

    @Test
    public void emptyResponseFault() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/empty/response")).willReturn(WireMock.aResponse().withFault(Fault.EMPTY_RESPONSE)));
        this.getAndAssertUnderlyingExceptionInstanceClass("/empty/response", NoHttpResponseException.class);
    }

    @Test
    public void malformedResponseChunkFault() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/malformed/response")).willReturn(WireMock.aResponse().withFault(Fault.MALFORMED_RESPONSE_CHUNK)));
        this.getAndAssertUnderlyingExceptionInstanceClass("/malformed/response", MalformedChunkCodingException.class);
    }

    @Test
    public void randomDataOnSocketFault() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/random/data")).willReturn(WireMock.aResponse().withFault(Fault.RANDOM_DATA_THEN_CLOSE)));
        this.getAndAssertUnderlyingExceptionInstanceClass("/random/data", NoHttpResponseException.class);
    }

    @Test
    public void matchingUrlsWithEscapeCharacters() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/%26%26The%20Lord%20of%20the%20Rings%26%26")).willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)testClient.get("/%26%26The%20Lord%20of%20the%20Rings%26%26", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void matchingUrlPathsWithEscapeCharacters() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/%26%26The%20Lord%20of%20the%20Rings%26%26")).willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)testClient.get("/%26%26The%20Lord%20of%20the%20Rings%26%26", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void default200ResponseWhenStatusCodeNotSpecified() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/default/two-hundred")).willReturn(WireMock.aResponse()));
        MatcherAssert.assertThat((Object)testClient.get("/default/two-hundred", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void returningBinaryBody() {
        byte[] bytes = new byte[]{65, 66, 67};
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/binary/content")).willReturn(WireMock.aResponse().withBody(bytes)));
        MatcherAssert.assertThat((Object)testClient.get("/binary/content", new TestHttpHeader[0]).binaryContent(), (Matcher)Matchers.is((Object)bytes));
    }

    @Test
    public void listingAllStubMappings() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/stub/one")).willReturn(WireMock.aResponse().withBody("One")));
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/stub/two")).willReturn(WireMock.aResponse().withBody("Two").withStatus(201)));
        ListStubMappingsResult listingResult = WireMock.listAllStubMappings();
        StubMapping mapping1 = (StubMapping)listingResult.getMappings().get(0);
        MatcherAssert.assertThat((Object)mapping1.getRequest().getMethod(), (Matcher)Matchers.is((Object)RequestMethod.POST));
        MatcherAssert.assertThat((Object)mapping1.getRequest().getUrl(), (Matcher)Matchers.is((Object)"/stub/two"));
        MatcherAssert.assertThat((Object)mapping1.getResponse().getBody(), (Matcher)Matchers.is((Object)"Two"));
        MatcherAssert.assertThat((Object)mapping1.getResponse().getStatus(), (Matcher)Matchers.is((Object)201));
        StubMapping mapping2 = (StubMapping)listingResult.getMappings().get(1);
        MatcherAssert.assertThat((Object)mapping2.getRequest().getMethod(), (Matcher)Matchers.is((Object)RequestMethod.GET));
        MatcherAssert.assertThat((Object)mapping2.getRequest().getUrl(), (Matcher)Matchers.is((Object)"/stub/one"));
        MatcherAssert.assertThat((Object)mapping2.getResponse().getBody(), (Matcher)Matchers.is((Object)"One"));
    }

    @Test
    public void stubbingPatch() {
        WireMock.stubFor((MappingBuilder)WireMock.patch((UrlPattern)WireMock.urlEqualTo((String)"/a/registered/resource")).withRequestBody((ContentPattern)WireMock.equalTo((String)"some body")).willReturn(WireMock.aResponse().withStatus(204)));
        WireMockResponse response = testClient.patchWithBody("/a/registered/resource", "some body", "text/plain", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)204));
    }

    @Test
    public void stubbingArbitraryMethod() {
        WireMock.stubFor((MappingBuilder)WireMock.request((String)"KILL", (UrlPattern)WireMock.urlEqualTo((String)"/some/url")).willReturn(WireMock.aResponse().withStatus(204)));
        WireMockResponse response = testClient.request("KILL", "/some/url", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)204));
    }

    @Test
    public void settingStatusMessage() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/status-message")).willReturn(WireMock.aResponse().withStatus(500).withStatusMessage("The bees! They're in my eyes!")));
        MatcherAssert.assertThat((Object)testClient.get("/status-message", new TestHttpHeader[0]).statusMessage(), (Matcher)Matchers.is((Object)"The bees! They're in my eyes!"));
    }

    @Test
    public void doesNotAttemptToMatchXmlBodyWhenStubMappingDoesNotHaveOne() {
        WireMock.stubFor((MappingBuilder)WireMock.options((UrlPattern)WireMock.urlEqualTo((String)"/no-body")).willReturn(WireMock.aResponse().withStatus(200)));
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/no-body")).withRequestBody((ContentPattern)WireMock.equalToXml((String)"<some-xml />")).willReturn(WireMock.aResponse().withStatus(201)));
        WireMockResponse response = testClient.options("/no-body", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void matchXmlBodyWhenTextNodeIsIgnored() {
        String url = "/ignore/my/xml";
        WireMock.stubFor((MappingBuilder)WireMock.post((String)url).withRequestBody((ContentPattern)WireMock.equalToXml((String)"<a>#{xmlunit.ignore}</a>", (boolean)true, (String)"#\\{", (String)"}")).willReturn(WireMock.ok()));
        MatcherAssert.assertThat((Object)testClient.postXml(url, "<a>123</a>", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void doesNotIgnoreXmlWhenPlaceholderMatchingIsFalse() {
        String url = "/do-not-ignore/my/xml";
        WireMock.stubFor((MappingBuilder)WireMock.post((String)url).withRequestBody((ContentPattern)WireMock.equalToXml((String)"<a>#{xmlunit.ignore}</a>", (boolean)false, (String)"#\\{", (String)"}")).willReturn(WireMock.ok()));
        MatcherAssert.assertThat((Object)testClient.postXml(url, "<a>123</a>", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void matchesQueryParamsUnencoded() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/query")).withQueryParam("param-one", WireMock.equalTo((String)"one two three ?")).willReturn(WireMock.aResponse().withStatus(200)));
        WireMockResponse response = testClient.get("/query?param-one=one%20two%20three%20%3F", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void matchesFormParamUnencoded() {
        WireMock.stubFor((MappingBuilder)WireMock.put((UrlPattern)WireMock.urlPathEqualTo((String)"/form")).withFormParam("key-one", WireMock.equalTo((String)"one two three ?")).willReturn(WireMock.aResponse().withStatus(200)));
        WireMockResponse response = testClient.putWithBody("/form", "key-one=one%20two%20three%20%3F", "application/x-www-form-urlencoded", TestHttpHeader.withHeader("Content-Type", "application/x-www-form-urlencoded"));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void matchesFormParamWithKeyInArrayStyle() {
        WireMock.stubFor((MappingBuilder)WireMock.put((UrlPattern)WireMock.urlPathEqualTo((String)"/form")).withFormParam("key[one]", WireMock.equalTo((String)"firstValue")).willReturn(WireMock.aResponse().withStatus(200)));
        WireMockResponse response = testClient.putWithBody("/form", "key[one]=firstValue", "application/x-www-form-urlencoded", TestHttpHeader.withHeader("Content-Type", "application/x-www-form-urlencoded"));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void copesWithEmptyRequestHeaderValueWhenMatchingOnEqualTo() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/empty-header")).withHeader("X-My-Header", WireMock.equalTo((String)"")).willReturn(WireMock.aResponse().withStatus(200)));
        WireMockResponse response = testClient.get("/empty-header", TestHttpHeader.withHeader("X-My-Header", ""));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void assignsAnIdAndReturnsNewlyCreatedStubMapping() {
        StubMapping stubMapping = WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.aResponse()));
        MatcherAssert.assertThat((Object)stubMapping.getId(), (Matcher)Matchers.notNullValue());
        StubMapping localStubMapping = wm.stubFor(WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.aResponse()));
        MatcherAssert.assertThat((Object)localStubMapping.getId(), (Matcher)Matchers.notNullValue());
    }

    @Test
    public void getsASingleStubMappingById() {
        UUID id = UUID.randomUUID();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.anyUrl()).withId(id).willReturn(WireMock.aResponse().withBody("identified!")));
        StubMapping fetchedMapping = WireMock.getSingleStubMapping((UUID)id);
        MatcherAssert.assertThat((Object)fetchedMapping.getResponse().getBody(), (Matcher)Matchers.is((Object)"identified!"));
    }

    @Test
    public void defaultsResponseWhenUnspecifiied() {
        WireMock.stubFor((MappingBuilder)WireMock.any((UrlPattern)WireMock.anyUrl()));
        MatcherAssert.assertThat((Object)testClient.get("/anything-is-matched", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void stubMappingsCanOptionallyBeNamed() {
        WireMock.stubFor((MappingBuilder)WireMock.any((UrlPattern)WireMock.urlPathEqualTo((String)"/things")).withName("Get all the things").willReturn(WireMock.aResponse().withBody("Named stub")));
        MatcherAssert.assertThat((Object)WireMock.listAllStubMappings().getMappings(), (Matcher)Matchers.hasItem(this.named("Get all the things")));
    }

    @Test
    public void matchingOnMultipartRequestBodyWithTwoRegexes() {
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/match/this/part")).withMultipartRequestBody(WireMock.aMultipart().withBody((ContentPattern)WireMock.matching((String)".*Blah.*"))).withMultipartRequestBody(WireMock.aMultipart().withBody((ContentPattern)WireMock.matching((String)".*@[0-9]{5}@.*"))).willReturn(WireMock.aResponse().withStatus(200).withBodyFile("plain-example.txt")));
        WireMockResponse response = testClient.postWithMultiparts("/match/this/part", Collections.singletonList(MultipartBody.part("part-1", "Blah...but not the rest", ContentType.TEXT_PLAIN)), new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        response = testClient.postWithMultiparts("/match/this/part", Collections.singletonList(MultipartBody.part("part-1", "@12345@...but not the rest", ContentType.TEXT_PLAIN)), new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        response = testClient.postWithMultiparts("/match/this/part", Collections.singletonList(MultipartBody.part("good-part", "BlahBlah@56565@Blah", ContentType.TEXT_PLAIN)), new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void matchingOnMultipartRequestBodyWithAContainsAndANegativeRegex() {
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/match/this/part/too")).withMultipartRequestBody(WireMock.aMultipart().withName("part-name").withBody((ContentPattern)WireMock.containing((String)"Blah")).withBody((ContentPattern)WireMock.notMatching((String)".*[0-9]+.*"))).willReturn(WireMock.aResponse().withStatus(200).withBodyFile("plain-example.txt")));
        WireMockResponse response = testClient.postWithMultiparts("/match/this/part/too", Collections.singletonList(MultipartBody.part("part-name", "Blah12345", ContentType.TEXT_PLAIN)), new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        response = testClient.postWithMultiparts("/match/this/part/too", Collections.singletonList(MultipartBody.part("part-name", "BlahBlahBlah", ContentType.TEXT_PLAIN)), new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void matchingOnMultipartRequestBodyWithNotContaining() {
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/match/this/part/too")).withMultipartRequestBody(WireMock.aMultipart().withHeader("Content-Type", WireMock.notContaining((String)"application/json")).withBody((ContentPattern)WireMock.notContaining((String)"OtherStuff"))).willReturn(WireMock.aResponse().withStatus(200).withBodyFile("plain-example.txt")));
        WireMockResponse response = testClient.postWithMultiparts("/match/this/part/too", Collections.singletonList(MultipartBody.part("part", "BlahOtherStuff12345", ContentType.TEXT_PLAIN)), new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        response = testClient.postWithMultiparts("/match/this/part/too", Collections.singletonList(MultipartBody.part("part", "BlahBlahBlah", ContentType.TEXT_PLAIN)), new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void matchingOnMultipartRequestBodyWithEqualTo() {
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/match/this/part/too")).withMultipartRequestBody(WireMock.aMultipart().withHeader("Content-Type", WireMock.containing((String)"text/plain")).withBody((ContentPattern)WireMock.equalTo((String)"BlahBlahBlah"))).willReturn(WireMock.aResponse().withStatus(200).withBodyFile("plain-example.txt")));
        WireMockResponse response = testClient.postWithMultiparts("/match/this/part/too", Collections.singletonList(MultipartBody.part("part", "Blah12345", ContentType.TEXT_PLAIN)), new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        response = testClient.postWithMultiparts("/match/this/part/too", Collections.singletonList(MultipartBody.part("part", "BlahBlahBlah", ContentType.TEXT_PLAIN)), new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void matchingOnMultipartRequestBodyWithBinaryEqualTo() {
        byte[] requestBody = new byte[]{1, 2, 3};
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/match/part/binary").withMultipartRequestBody(WireMock.aMultipart().withBody((ContentPattern)WireMock.binaryEqualTo((byte[])requestBody)).withName("file")).willReturn(WireMock.ok((String)"Matched binary")));
        WireMockResponse response = testClient.postWithMultiparts("/match/part/binary", Collections.singletonList(MultipartBody.part("file", new byte[]{9})), new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        response = testClient.postWithMultiparts("/match/part/binary", Collections.singletonList(MultipartBody.part("file", requestBody)), new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void matchingOnMultipartRequestBodyWithAdvancedJsonPath() {
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/jsonpath/advanced/part").withMultipartRequestBody(WireMock.aMultipart().withName("json").withHeader("Content-Type", WireMock.containing((String)"application/json")).withBody((ContentPattern)WireMock.matchingJsonPath((String)"$.counter", (StringValuePattern)WireMock.equalTo((String)"123")))).willReturn(WireMock.ok()));
        WireMockResponse response = testClient.postWithMultiparts("/jsonpath/advanced/part", Collections.singletonList(MultipartBody.part("json", "{ \"counter\": 234 }", ContentType.APPLICATION_JSON)), new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        response = testClient.postWithMultiparts("/jsonpath/advanced/part", Collections.singletonList(MultipartBody.part("json", "{ \"counter\": 123 }", ContentType.APPLICATION_JSON)), new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void matchingOnMultipartRequestBodyWithAdvancedXPath() {
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/xpath/advanced/part").withMultipartRequestBody(WireMock.aMultipart().withName("xml").withHeader("Content-Type", WireMock.containing((String)"application/xml")).withBody((ContentPattern)WireMock.matchingXPath((String)"//counter/text()", (StringValuePattern)WireMock.equalTo((String)"123")))).willReturn(WireMock.ok()));
        WireMockResponse response = testClient.postWithMultiparts("/xpath/advanced/part", Collections.singletonList(MultipartBody.part("xml", "<counter>6666</counter>", ContentType.APPLICATION_XML)), new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        response = testClient.postWithMultiparts("/xpath/advanced/part", Collections.singletonList(MultipartBody.part("xml", "<counter>123</counter>", ContentType.APPLICATION_XML)), new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void copesWithRequestCharactersThatReallyShouldBeEscapedWhenMatchingOnWholeUrlRegex() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlMatching((String)"/dodgy-chars.*")).willReturn(WireMock.ok()));
        String url = "http://localhost:" + wireMockServer.port() + "/dodgy-chars?filter={\"accountid\":\"1\"}";
        int code = this.getStatusCodeUsingJavaUrlConnection(url);
        MatcherAssert.assertThat((Object)code, (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void copesWithRequestCharactersThatReallyShouldBeEscapedWhenMatchingOnExactUrlPath() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/dodgy-chars")).willReturn(WireMock.ok()));
        String url = "http://localhost:" + wireMockServer.port() + "/dodgy-chars?filter={\"accountid\":\"1\"}";
        int code = this.getStatusCodeUsingJavaUrlConnection(url);
        MatcherAssert.assertThat((Object)code, (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void matchesQueryCharactersThatStriclyShouldBeEscapedInEitherForm() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/test")).withQueryParam("filter[id]", WireMock.equalTo((String)"1")).willReturn(WireMock.ok()));
        MatcherAssert.assertThat((Object)testClient.get("/test?filter[id]=1", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)testClient.get("/test?filter%5Bid%5D=1", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void matchesExactContentTypeEncodingSpecified() throws Exception {
        String contentType = "application/json; charset=UTF-8";
        String url = "/request-content-type-case";
        WireMock.stubFor((MappingBuilder)WireMock.post((String)url).withHeader("Content-Type", WireMock.equalTo((String)contentType)).willReturn(WireMock.ok()));
        WireMockResponse response = testClient.post(url, (HttpEntity)new StringEntity("{}"), TestHttpHeader.withHeader("Content-Type", contentType));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void returnsContentTypeHeaderEncodingInCorrectCase() {
        String contentType = "application/json; charset=UTF-8";
        String url = "/response-content-type-case";
        WireMock.stubFor((MappingBuilder)WireMock.get((String)url).willReturn(WireMock.ok((String)"{}").withHeader("Content-Type", new String[]{contentType})));
        MatcherAssert.assertThat((Object)testClient.get(url, new TestHttpHeader[0]).firstHeader("Content-Type"), (Matcher)Matchers.is((Object)contentType));
    }

    @Test
    public void matchesInRequestBodyOnLiteralZonedDate() {
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/date").withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.date", (StringValuePattern)WireMock.before((String)"2021-10-11T00:00:00Z"))).willReturn(WireMock.ok()));
        MatcherAssert.assertThat((Object)testClient.postJson("/date", "{\n  \"date\": \"2021-06-22T23:59:59Z\"\n}", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)testClient.postJson("/date", "{\n  \"date\": \"2121-06-22T23:59:59Z\"\n}", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void matchesQueryParameterOnLiteralZonedDate() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/match-query-parameter")).withQueryParam("date", (StringValuePattern)WireMock.before((String)"2021-10-11T00:00:00Z")).willReturn(WireMock.ok()));
        MatcherAssert.assertThat((Object)testClient.get("/match-query-parameter?date=2021-06-22T23%3A59%3A59Z", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)testClient.get("/match-query-parameter?date=2121-06-22T23%3A59%3A59Z", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((Object)testClient.get("/match-query-parameter", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void matchesOnNowOffsetDate() {
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/offset-date").withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.date", (StringValuePattern)WireMock.isNow().expectedOffset(1, DateTimeUnit.HOURS).truncateActual(DateTimeTruncation.FIRST_MINUTE_OF_HOUR).truncateExpected(DateTimeTruncation.FIRST_MINUTE_OF_HOUR))).willReturn(WireMock.ok()));
        String good = ZonedDateTime.now().truncatedTo(ChronoUnit.HOURS).plusHours(1L).toString();
        String bad = ZonedDateTime.now().truncatedTo(ChronoUnit.HOURS).plusHours(1L).minusMinutes(1L).toString();
        MatcherAssert.assertThat((Object)testClient.postJson("/offset-date", "{\n  \"date\": \"" + good + "\"\n}", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)testClient.postJson("/offset-date", "{\n  \"date\": \"" + bad + "\"\n}", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void matchesWithLogicalAnd() {
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/date").withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.date", (StringValuePattern)WireMock.after((String)"2020-05-01T00:00:00Z").and((StringValuePattern)WireMock.before((String)"2021-05-01T00:00:00Z")))).willReturn(WireMock.ok()));
        MatcherAssert.assertThat((Object)testClient.postJson("/date", "{\n  \"date\": \"2020-12-31T00:00:00Z\"\n}", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)testClient.postJson("/date", "{\n  \"date\": \"2011-12-31T00:00:00Z\"\n}", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void matchesQueryParametersWithLogicalOr() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/or")).withQueryParam("q", (StringValuePattern)WireMock.equalTo((String)"thingtofind").or(WireMock.absent())).willReturn(WireMock.ok()));
        MatcherAssert.assertThat((Object)testClient.get("/or", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)testClient.get("/or?q=thingtofind", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)testClient.get("/or?q=wrong", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @ParameterizedTest
    @MethodSource(value={"provideInputsForMultiValueQueryParamsForExactMatch"})
    public void matchesMultipleQueryParametersUsingExactMatch(String queryParams, int statusCode) {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/match")).withQueryParam("q", WireMock.havingExactly((String[])new String[]{"1", "2", "3"})).willReturn(WireMock.ok()));
        MatcherAssert.assertThat((Object)testClient.get("/match" + queryParams, new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)statusCode));
    }

    @Test
    public void matchesMultipleValuesForHeaderUsingExactMatch() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/match")).withHeader("q", WireMock.havingExactly((String[])new String[]{"1", "2", "3"})).willReturn(WireMock.ok()));
        MatcherAssert.assertThat((Object)testClient.get("/match", TestHttpHeader.withHeader("q", "1"), TestHttpHeader.withHeader("q", "2"), TestHttpHeader.withHeader("q", "3")).statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void matchesMultipleValuesForHeaderUsingIncludesMatch() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/match")).withHeader("q", WireMock.including((String[])new String[]{"1", "2", "3"})).willReturn(WireMock.ok()));
        MatcherAssert.assertThat((Object)testClient.get("/match", TestHttpHeader.withHeader("q", "1"), TestHttpHeader.withHeader("q", "2"), TestHttpHeader.withHeader("q", "3"), TestHttpHeader.withHeader("q", "4"), TestHttpHeader.withHeader("q", "5")).statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void matchesMultipleValuesForHeaderUsingIncludesMatchReturnsNotFound() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/match")).withHeader("q", WireMock.including((String[])new String[]{"1", "8", "3"})).willReturn(WireMock.ok()));
        MatcherAssert.assertThat((Object)testClient.get("/match", TestHttpHeader.withHeader("q", "1"), TestHttpHeader.withHeader("q", "2"), TestHttpHeader.withHeader("q", "3"), TestHttpHeader.withHeader("q", "4"), TestHttpHeader.withHeader("q", "5")).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void matchesMultipleValuesForHeaderUsingExactMatchReturnsNotFound() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/match")).withHeader("q", WireMock.havingExactly((String[])new String[]{"1", "2", "3"})).willReturn(WireMock.ok()));
        MatcherAssert.assertThat((Object)testClient.get("/match", TestHttpHeader.withHeader("q", "1"), TestHttpHeader.withHeader("q", "4"), TestHttpHeader.withHeader("q", "5"), TestHttpHeader.withHeader("q", "6"), TestHttpHeader.withHeader("q", "5")).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void matchesNoValuesForHeaders() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/match")).withHeader("q", WireMock.noValues()).willReturn(WireMock.ok()));
        MatcherAssert.assertThat((Object)testClient.get("/match", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @ParameterizedTest
    @MethodSource(value={"provideInputsForMultiValueQueryParamsForExactMatch"})
    public void matchesMultipleQueryParametersUsingExactMatchWithMultipleValuePatterns(String queryParams, int statusCode) {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/match")).withQueryParam("q", WireMock.havingExactly((StringValuePattern[])new StringValuePattern[]{WireMock.equalTo((String)"1"), WireMock.notContaining((String)"7"), WireMock.equalTo((String)"3")})).willReturn(WireMock.ok()));
        MatcherAssert.assertThat((Object)testClient.get("/match" + queryParams, new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)statusCode));
    }

    @ParameterizedTest
    @MethodSource(value={"provideInputsForMultiValueQueryParamsForIncludeMatch"})
    public void matchesMultipleQueryParametersUsingIncludeMatch(String queryParams, int statusCode) {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/match")).withQueryParam("q", WireMock.including((String[])new String[]{"1", "2", "3"})).willReturn(WireMock.ok()));
        MatcherAssert.assertThat((Object)testClient.get("/match" + queryParams, new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)statusCode));
    }

    public static Stream<Arguments> provideInputsForMultiValueQueryParamsForExactMatch() {
        return Stream.of(Arguments.of((Object[])new Object[]{"?q=1&q=2&q=3", 200}), Arguments.of((Object[])new Object[]{"?q=1&q=3&q=2", 200}), Arguments.of((Object[])new Object[]{"?q=2&q=3&q=1", 200}), Arguments.of((Object[])new Object[]{"?q=2&q=1&q=3", 200}), Arguments.of((Object[])new Object[]{"?q=3&q=1&q=2", 200}), Arguments.of((Object[])new Object[]{"?q=3&q=2&q=1", 200}), Arguments.of((Object[])new Object[]{"?q=3&q=1&q=2", 200}), Arguments.of((Object[])new Object[]{"", 404}), Arguments.of((Object[])new Object[]{"?q=wrong", 404}), Arguments.of((Object[])new Object[]{"?q=1&q=2&q=3&q=4", 404}), Arguments.of((Object[])new Object[]{"?q=1&q=4&q=5&q=6", 404}), Arguments.of((Object[])new Object[]{"?q=1&q=1&q=1&q=1", 404}));
    }

    public static Stream<Arguments> provideInputsForMultiValueQueryParamsForIncludeMatch() {
        return Stream.of(Arguments.of((Object[])new Object[]{"?q=1&q=2&q=3", 200}), Arguments.of((Object[])new Object[]{"?q=1&q=3&q=2", 200}), Arguments.of((Object[])new Object[]{"?q=2&q=3&q=1", 200}), Arguments.of((Object[])new Object[]{"?q=2&q=1&q=3", 200}), Arguments.of((Object[])new Object[]{"?q=3&q=1&q=2", 200}), Arguments.of((Object[])new Object[]{"?q=3&q=2&q=1", 200}), Arguments.of((Object[])new Object[]{"?q=3&q=1&q=2", 200}), Arguments.of((Object[])new Object[]{"?q=1&q=2&q=3&q=4", 200}), Arguments.of((Object[])new Object[]{"", 404}), Arguments.of((Object[])new Object[]{"?q=wrong", 404}), Arguments.of((Object[])new Object[]{"?q=1&q=4&q=5&q=6", 404}), Arguments.of((Object[])new Object[]{"?q=1&q=1&q=1&q=1", 404}));
    }

    @Test
    public void matchesHeadersWithLogicalOr() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/or")).withHeader("X-Maybe", (StringValuePattern)WireMock.equalTo((String)"one").or((StringValuePattern)WireMock.containing((String)"two").or(WireMock.matching((String)"thre{2}")).or(WireMock.absent()))).willReturn(WireMock.ok()));
        MatcherAssert.assertThat((Object)testClient.get("/or", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)testClient.get("/or", TestHttpHeader.withHeader("X-Maybe", "one")).statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)testClient.get("/or", TestHttpHeader.withHeader("X-Maybe", "two222")).statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)testClient.get("/or", TestHttpHeader.withHeader("X-Maybe", "three")).statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)testClient.get("/or", TestHttpHeader.withHeader("X-Maybe", "wrong")).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void jsonResponseWithStringValue() {
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/json-from-string").willReturn(WireMock.jsonResponse((String)"{ \"message\": \"Json From String\" }", (int)200)));
        WireMockResponse response = testClient.get("/json-from-string", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.firstHeader("Content-Type"), (Matcher)Matchers.is((Object)"application/json"));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.containsString((String)"\"Json From String\""));
    }

    @Test
    public void jsonResponseWithObjectValue() {
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/json-from-object").willReturn(WireMock.jsonResponse((Object)new MockResponse("Json From Object"), (int)200)));
        WireMockResponse response = testClient.get("/json-from-object", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.firstHeader("Content-Type"), (Matcher)Matchers.is((Object)"application/json"));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.containsString((String)"\"Json From Object\""));
    }

    @Test
    public void removesASingleStubMapping() {
        UUID id = UUID.randomUUID();
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/stub-to-remove").withId(id).willReturn(WireMock.aResponse()));
        MatcherAssert.assertThat((Object)testClient.get("/stub-to-remove", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
        StubMapping stub = wireMockServer.getSingleStubMapping(id);
        wireMockServer.removeStubMapping(stub);
        MatcherAssert.assertThat((Object)testClient.get("/stub-to-remove", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void removesASingleStubMappingById() {
        UUID id = UUID.randomUUID();
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/stub-to-remove-by-id").withId(id).willReturn(WireMock.aResponse()));
        MatcherAssert.assertThat((Object)testClient.get("/stub-to-remove-by-id", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
        wireMockServer.removeStubMapping(id);
        MatcherAssert.assertThat((Object)testClient.get("/stub-to-remove-by-id", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    void queryParamCanBeMatchedAsNotAbsent() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/search")).withQueryParam("q", WireMock.not((StringValuePattern)WireMock.absent())).willReturn(WireMock.ok()));
        MatcherAssert.assertThat((Object)testClient.get("/search?q=something", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)testClient.get("/search", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    private int getStatusCodeUsingJavaUrlConnection(String url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod("GET");
        connection.connect();
        int code = connection.getResponseCode();
        connection.disconnect();
        return code;
    }

    private Matcher<StubMapping> named(final String name) {
        return new TypeSafeMatcher<StubMapping>(){

            public void describeTo(Description description) {
                description.appendText("named " + name);
            }

            protected boolean matchesSafely(StubMapping item) {
                return name.equals(item.getName());
            }
        };
    }

    private void getAndAssertUnderlyingExceptionInstanceClass(String url, Class<?> expectedClass) {
        boolean thrown = false;
        try {
            WireMockResponse response = testClient.get(url, new TestHttpHeader[0]);
            response.content();
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(expectedClass));
            thrown = true;
        }
        Assertions.assertTrue((boolean)thrown, (String)"No exception was thrown");
    }

    public static class MockResponse {
        private final String message;

        public MockResponse(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

