/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.PostServeActionExtensionTest;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.admin.Router;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ConsoleNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.AdminApiExtension;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.ServeEventListener;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.javacrumbs.jsonunit.JsonMatchers;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public class ServeEventListenerExtensionTest {
    WireMockServer wm;
    WireMockTestClient client;

    void initWithOptions(Options options) {
        this.wm = new WireMockServer(options);
        this.wm.start();
        this.client = new WireMockTestClient(this.wm.port());
    }

    @AfterEach
    public void cleanup() {
        if (this.wm != null) {
            this.wm.stop();
        }
    }

    @Test
    void eventTriggeredBeforeMatching() throws Exception {
        final CompletableFuture completed = new CompletableFuture();
        this.initWithOptions((Options)WireMockConfiguration.options().dynamicPort().extensions(new Extension[]{new ServeEventListener(){

            public void beforeMatch(ServeEvent serveEvent, Parameters parameters) {
                MatcherAssert.assertThat((Object)serveEvent.getRequest().getUrl(), (Matcher)Matchers.is((Object)"/get-this"));
                MatcherAssert.assertThat((Object)serveEvent.getResponseDefinition(), (Matcher)Matchers.nullValue());
                MatcherAssert.assertThat((Object)serveEvent.getStubMapping(), (Matcher)Matchers.nullValue());
                MatcherAssert.assertThat((Object)serveEvent.getResponse(), (Matcher)Matchers.nullValue());
                completed.complete(null);
            }

            public String getName() {
                return "before-match";
            }
        }}));
        this.wm.stubFor(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok()));
        this.client.get("/get-this", new TestHttpHeader[0]);
        completed.get(2L, TimeUnit.SECONDS);
    }

    @Test
    void eventTriggeredAfterMatching() throws Exception {
        final CompletableFuture completed = new CompletableFuture();
        this.initWithOptions((Options)WireMockConfiguration.options().dynamicPort().extensions(new Extension[]{new ServeEventListener(){

            public void afterMatch(ServeEvent serveEvent, Parameters parameters) {
                MatcherAssert.assertThat((Object)serveEvent.getRequest().getUrl(), (Matcher)Matchers.is((Object)"/get-this"));
                MatcherAssert.assertThat((Object)serveEvent.getResponseDefinition(), (Matcher)Matchers.notNullValue());
                MatcherAssert.assertThat((Object)serveEvent.getStubMapping(), (Matcher)Matchers.notNullValue());
                MatcherAssert.assertThat((Object)serveEvent.getResponse(), (Matcher)Matchers.nullValue());
                completed.complete(null);
            }

            public String getName() {
                return "after-match";
            }
        }}));
        this.wm.stubFor(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok()));
        this.client.get("/get-this", new TestHttpHeader[0]);
        completed.get(2L, TimeUnit.SECONDS);
    }

    @Test
    void eventTriggeredAfterCompletion() throws Exception {
        final CompletableFuture completed = new CompletableFuture();
        this.initWithOptions((Options)WireMockConfiguration.options().dynamicPort().extensions(new Extension[]{new ServeEventListener(){

            public void afterComplete(ServeEvent serveEvent, Parameters parameters) {
                MatcherAssert.assertThat((Object)serveEvent.getRequest().getUrl(), (Matcher)Matchers.is((Object)"/get-this"));
                MatcherAssert.assertThat((Object)serveEvent.getResponseDefinition(), (Matcher)Matchers.notNullValue());
                MatcherAssert.assertThat((Object)serveEvent.getStubMapping(), (Matcher)Matchers.notNullValue());
                MatcherAssert.assertThat((Object)serveEvent.getResponse().getStatus(), (Matcher)Matchers.is((Object)200));
                completed.complete(null);
            }

            public String getName() {
                return "after-complete";
            }
        }}));
        this.wm.stubFor(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok()));
        this.client.get("/get-this", new TestHttpHeader[0]);
        completed.get(2L, TimeUnit.SECONDS);
    }

    @Test
    void eventTriggeredWhenAppliedToAStubMapping() {
        this.initWithOptions((Options)WireMockConfiguration.options().dynamicPort().extensions(new Extension[]{new NamedCounterAction()}));
        StubMapping stubMapping = this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/count-me")).withServeEventListener("count-request", (Object)PostServeActionExtensionTest.CounterNameParameter.counterNameParameter().withName("things")).willReturn(WireMock.aResponse()));
        this.client.get("/count-me", new TestHttpHeader[0]);
        this.client.get("/count-me", new TestHttpHeader[0]);
        this.client.get("/count-me", new TestHttpHeader[0]);
        this.client.get("/count-me", new TestHttpHeader[0]);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(this.getContent("/__admin/named-counter/things"), Matchers.is((Object)"4"));
        MatcherAssert.assertThat((Object)this.client.get("/__admin/mappings/" + stubMapping.getId(), new TestHttpHeader[0]).content(), (Matcher)JsonMatchers.jsonPartEquals((String)"serveEventListeners", (Object)"[\n    {\n      \"name\": \"count-request\",\n      \"parameters\": {\n        \"counterName\": \"things\"\n      }\n    }\n  ]"));
    }

    @Test
    void eventSelectedPerStubWithVaryingParameters() {
        final ArrayList messages = new ArrayList();
        this.initWithOptions((Options)WireMockConfiguration.options().dynamicPort().extensions(new Extension[]{new ServeEventListener(){

            public void onEvent(ServeEventListener.RequestPhase requestPhase, ServeEvent serveEvent, Parameters parameters) {
                messages.add(requestPhase.name() + ": " + parameters.getString("phase"));
            }

            public boolean applyGlobally() {
                return false;
            }

            public String getName() {
                return "request-phase-reporter";
            }
        }}));
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/report")).withServeEventListener(ServeEventListener.RequestPhase.AFTER_MATCH, "request-phase-reporter", (Object)Parameters.one((String)"phase", (Object)"after-match")).withServeEventListener(ServeEventListener.RequestPhase.AFTER_COMPLETE, "request-phase-reporter", (Object)Parameters.one((String)"phase", (Object)"after-complete")).willReturn(WireMock.aResponse()));
        this.client.get("/report", new TestHttpHeader[0]);
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).until(() -> messages, Matchers.hasItems((Object[])new String[]{"AFTER_MATCH: after-match", "AFTER_COMPLETE: after-complete"}));
    }

    @Test
    void globalOnEventListenerIsTriggeredInAllRequestPhases() {
        final ArrayList messages = new ArrayList();
        this.initWithOptions((Options)WireMockConfiguration.options().dynamicPort().extensions(new Extension[]{new ServeEventListener(){

            public void onEvent(ServeEventListener.RequestPhase requestPhase, ServeEvent serveEvent, Parameters parameters) {
                messages.add(requestPhase.name());
            }

            public boolean applyGlobally() {
                return true;
            }

            public String getName() {
                return "request-phase-reporter";
            }
        }}));
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/report")).willReturn(WireMock.aResponse()));
        this.client.get("/report", new TestHttpHeader[0]);
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).until(() -> messages, Matchers.hasItems((Object[])new String[]{"BEFORE_MATCH", "AFTER_MATCH", "AFTER_COMPLETE"}));
    }

    @Test
    void continuesWithNoEffectIfANonExistentActionIsReferenced() {
        this.initWithOptions((Options)WireMockConfiguration.options().dynamicPort());
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/as-normal")).withServeEventListener("does-not-exist", (Object)PostServeActionExtensionTest.CounterNameParameter.counterNameParameter().withName("things")).willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)this.client.get("/as-normal", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    void providesServeEventWithResponseFieldPopulated() {
        final AtomicInteger finalStatus = new AtomicInteger();
        this.initWithOptions((Options)WireMockConfiguration.options().dynamicPort().extensions(new Extension[]{new ServeEventListener(){

            public String getName() {
                return "response-field-test";
            }

            public boolean applyGlobally() {
                return true;
            }

            public void afterComplete(ServeEvent serveEvent, Parameters parameters) {
                if (serveEvent.getResponse() != null) {
                    finalStatus.set(serveEvent.getResponse().getStatus());
                }
            }
        }}));
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/response-status")).willReturn(WireMock.aResponse().withStatus(418)));
        this.client.get("/response-status", new TestHttpHeader[0]);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(this.getValue(finalStatus), Matchers.is((Object)418));
    }

    @Test
    public void multipleActionsOfTheSameNameCanBeSpecifiedAsAJsonArray() {
        this.initWithOptions((Options)WireMockConfiguration.options().dynamicPort().notifier((Notifier)new ConsoleNotifier(true)).extensions(new Extension[]{new NamedCounterAction()}));
        WireMockResponse response = this.client.postJson("/__admin/mappings", "{\n  \"request\": {\n    \"urlPath\": \"/count-me\",\n    \"method\": \"GET\"\n  },\n  \"response\": {\n    \"status\": 200\n  },\n  \"serveEventListeners\": [\n    {\n      \"name\": \"count-request\",\n      \"parameters\": {\n        \"counterName\": \"one\"  \n      }\n    },\n    {\n      \"name\": \"count-request\",\n      \"parameters\": {\n        \"counterName\": \"two\"\n      }\n    }\n  ]\n}", new TestHttpHeader[0]);
        MatcherAssert.assertThat((String)response.content(), (Object)response.statusCode(), (Matcher)Matchers.is((Object)201));
        this.client.get("/count-me", new TestHttpHeader[0]);
        this.client.get("/count-me", new TestHttpHeader[0]);
        this.client.get("/count-me", new TestHttpHeader[0]);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(this.getContent("/__admin/named-counter/one"), Matchers.is((Object)"3"));
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(this.getContent("/__admin/named-counter/two"), Matchers.is((Object)"3"));
    }

    @Test
    void multipleActionsOfTheSameNameCanBeSpecifiedViaTheDSL() {
        this.initWithOptions((Options)WireMockConfiguration.options().dynamicPort().notifier((Notifier)new ConsoleNotifier(true)).extensions(new Extension[]{new NamedCounterAction()}));
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/count-me")).willReturn(WireMock.ok()).withServeEventListener("count-request", (Object)PostServeActionExtensionTest.CounterNameParameter.counterNameParameter().withName("one")).withServeEventListener("count-request", (Object)PostServeActionExtensionTest.CounterNameParameter.counterNameParameter().withName("two")));
        this.client.get("/count-me", new TestHttpHeader[0]);
        this.client.get("/count-me", new TestHttpHeader[0]);
        this.client.get("/count-me", new TestHttpHeader[0]);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(this.getContent("/__admin/named-counter/one"), Matchers.is((Object)"3"));
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(this.getContent("/__admin/named-counter/two"), Matchers.is((Object)"3"));
    }

    private Callable<Integer> getValue(AtomicInteger value) {
        return value::get;
    }

    private Callable<String> getContent(String url) {
        return () -> this.client.get(url, new TestHttpHeader[0]).content();
    }

    public static class CounterNameParameter {
        public String counterName;

        public CounterNameParameter(@JsonProperty(value="counterName") String counterName) {
            this.counterName = counterName;
        }

        public CounterNameParameter() {
        }

        public static CounterNameParameter counterNameParameter() {
            return new CounterNameParameter();
        }

        public CounterNameParameter withName(String name) {
            this.counterName = name;
            return this;
        }
    }

    public static class NamedCounterAction
    implements ServeEventListener,
    AdminApiExtension {
        private final ConcurrentHashMap<String, Integer> counters = new ConcurrentHashMap();

        public String getName() {
            return "count-request";
        }

        public boolean applyGlobally() {
            return false;
        }

        public void contributeAdminApiRoutes(Router router) {
            router.add(RequestMethod.GET, "/named-counter/{name}", (admin, serveEvent, pathParams) -> {
                String name = (String)pathParams.get((Object)"name");
                Integer count = (Integer)MoreObjects.firstNonNull((Object)this.counters.get(name), (Object)0);
                return ResponseDefinitionBuilder.responseDefinition().withStatus(200).withBody(String.valueOf(count)).build();
            });
        }

        public void afterComplete(ServeEvent serveEvent, Parameters parameters) {
            Integer newValue;
            Integer oldValue;
            CounterNameParameter counterNameParam = (CounterNameParameter)parameters.as(CounterNameParameter.class);
            String counterName = counterNameParam.counterName;
            this.counters.putIfAbsent(counterName, 0);
            while (!this.counters.replace(counterName, oldValue = this.counters.get(counterName), newValue = Integer.valueOf(oldValue + 1))) {
            }
        }
    }
}

