/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.http.ThreadPoolFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class QueuedThreadPoolAcceptanceTest
extends AcceptanceTestBase {
    @BeforeAll
    public static void setupServer() {
        QueuedThreadPoolAcceptanceTest.setupServer(new WireMockConfiguration().threadPoolFactory((ThreadPoolFactory)new InstrumentedThreadPoolFactory()));
    }

    @Test
    public void serverUseCustomInstrumentedQueuedThreadPool() {
        MatcherAssert.assertThat((Object)InstrumentedQueuedThreadPool.flag, (Matcher)Matchers.is((Object)true));
    }

    public static class InstrumentedThreadPoolFactory
    implements ThreadPoolFactory {
        public ThreadPool buildThreadPool(Options options) {
            return new InstrumentedQueuedThreadPool(options.containerThreads());
        }
    }

    public static class InstrumentedQueuedThreadPool
    extends QueuedThreadPool {
        public static boolean flag = false;

        public InstrumentedQueuedThreadPool(int maxThreads) {
            this(maxThreads, 8);
        }

        public InstrumentedQueuedThreadPool(int maxThreads, int minThreads) {
            this(maxThreads, minThreads, 60000);
        }

        public InstrumentedQueuedThreadPool(int maxThreads, int minThreads, int idleTimeout) {
            super(maxThreads, minThreads, idleTimeout, null);
        }

        protected void doStart() throws Exception {
            super.doStart();
            flag = true;
        }
    }
}

