/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.NetworkAddressRules;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.entity.GzipCompressingEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class ProxyAcceptanceTest {
    private String targetServiceBaseUrl;
    WireMockServer targetService;
    WireMock target;
    WireMockServer proxyingService;
    WireMock proxy;
    WireMockTestClient testClient;

    void init(WireMockConfiguration proxyingServiceOptions) {
        this.targetService = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().dynamicHttpsPort().bindAddress("127.0.0.1").stubCorsEnabled(true));
        this.targetService.start();
        this.target = WireMock.create().host("localhost").port(this.targetService.port()).build();
        this.targetServiceBaseUrl = "http://localhost:" + this.targetService.port();
        proxyingServiceOptions.dynamicPort().bindAddress("127.0.0.1");
        this.proxyingService = new WireMockServer((Options)proxyingServiceOptions);
        this.proxyingService.start();
        this.proxy = WireMock.create().port(this.proxyingService.port()).build();
        this.testClient = new WireMockTestClient(this.proxyingService.port());
        WireMock.configureFor((int)this.targetService.port());
    }

    void initWithDefaultConfig() {
        this.init(WireMockConfiguration.wireMockConfig());
    }

    @AfterEach
    public void stop() {
        this.targetService.stop();
        this.proxyingService.stop();
    }

    @Test
    public void successfullyGetsResponseFromOtherServiceViaProxy() {
        this.initWithDefaultConfig();
        this.target.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/proxied/resource?param=value")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/plain"}).withBody("Proxied content")));
        this.proxy.register(WireMock.any((UrlPattern)WireMock.urlEqualTo((String)"/proxied/resource?param=value")).atPriority(Integer.valueOf(10)).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        WireMockResponse response = this.testClient.get("/proxied/resource?param=value", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"Proxied content"));
        MatcherAssert.assertThat((Object)response.firstHeader("Content-Type"), (Matcher)Matchers.is((Object)"text/plain"));
    }

    @Test
    public void successfullyGetsResponseFromOtherServiceViaProxyWhenInjectingAddtionalRequestHeaders() {
        this.initWithDefaultConfig();
        this.proxy.register(WireMock.any((UrlPattern)WireMock.urlEqualTo((String)"/additional/headers")).atPriority(Integer.valueOf(10)).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl).withAdditionalRequestHeader("a", "b").withAdditionalRequestHeader("c", "d")));
        this.testClient.get("/additional/headers", new TestHttpHeader[0]);
        this.target.verifyThat(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/additional/headers")).withHeader("a", WireMock.equalTo((String)"b")).withHeader("c", WireMock.equalTo((String)"d")));
    }

    @Test
    public void successfullyGetsResponseFromOtherServiceViaProxyInjectingHeadersOverridingSentHeaders() {
        this.initWithDefaultConfig();
        this.target.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/proxied/resource?param=value")).withHeader("a", WireMock.equalTo((String)"b")).willReturn(WireMock.aResponse().withStatus(200).withBody("Proxied content")));
        this.proxy.register(WireMock.any((UrlPattern)WireMock.urlEqualTo((String)"/proxied/resource?param=value")).atPriority(Integer.valueOf(10)).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl).withAdditionalRequestHeader("a", "b")));
        WireMockResponse response = this.testClient.get("/proxied/resource?param=value", TestHttpHeader.withHeader("a", "doh"));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"Proxied content"));
    }

    @Test
    public void successfullyPostsResponseToOtherServiceViaProxy() {
        this.initWithDefaultConfig();
        this.target.register(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/proxied/resource")).willReturn(WireMock.aResponse().withStatus(204)));
        this.proxy.register(WireMock.any((UrlPattern)WireMock.urlEqualTo((String)"/proxied/resource")).atPriority(Integer.valueOf(10)).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        WireMockResponse response = this.testClient.postWithBody("/proxied/resource", "Post content", "text/plain", "utf-8");
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)204));
        this.target.verifyThat(WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/proxied/resource")).withRequestBody((ContentPattern)WireMock.matching((String)"Post content")));
    }

    @Test
    public void successfullyGetsResponseFromOtherServiceViaProxyWithEscapeCharsInUrl() {
        this.initWithDefaultConfig();
        this.target.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/%26%26The%20Lord%20of%20the%20Rings%26%26")).willReturn(WireMock.aResponse().withStatus(200)));
        this.proxy.register(WireMock.any((UrlPattern)WireMock.urlEqualTo((String)"/%26%26The%20Lord%20of%20the%20Rings%26%26")).atPriority(Integer.valueOf(10)).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        WireMockResponse response = this.testClient.get("/%26%26The%20Lord%20of%20the%20Rings%26%26", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void successfullyGetsResponseBinaryResponses() throws IOException {
        this.initWithDefaultConfig();
        byte[] bytes = new byte[]{16, 73, 110, -73, 70, -26, 82, -107, -107, 66};
        HttpServer server = HttpServer.create(new InetSocketAddress(0), 0);
        server.createContext("/binary", exchange -> {
            InputStream request = exchange.getRequestBody();
            byte[] buffy = new byte[10];
            request.read(buffy);
            if (Arrays.equals(buffy, bytes)) {
                exchange.sendResponseHeaders(200, bytes.length);
                OutputStream out = exchange.getResponseBody();
                out.write(bytes);
                out.close();
            } else {
                exchange.sendResponseHeaders(500, 0L);
                exchange.close();
            }
        });
        server.start();
        this.proxy.register(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/binary")).willReturn(WireMock.aResponse().proxiedFrom("http://localhost:" + server.getAddress().getPort()).withBody(bytes)));
        WireMockResponse post = this.testClient.post("/binary", (HttpEntity)new ByteArrayEntity(bytes, ContentType.DEFAULT_BINARY), new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)post.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)post.binaryContent(), (Matcher)Matchers.equalTo((Object)bytes));
    }

    @Test
    public void sendsContentLengthHeaderInRequestWhenPostingIfPresentInOriginalRequest() {
        this.initWithDefaultConfig();
        this.target.register(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/with/length")).willReturn(WireMock.aResponse().withStatus(201)));
        this.proxy.register(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/with/length")).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        this.testClient.postWithBody("/with/length", "TEST", "application/x-www-form-urlencoded", "utf-8");
        this.target.verifyThat(WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/with/length")).withHeader("Content-Length", WireMock.equalTo((String)"4")));
    }

    @Test
    public void returnsContentLengthHeaderFromTargetResponseIfPresentAndChunkedEncodingEnabled() throws Exception {
        this.init(WireMockConfiguration.wireMockConfig().useChunkedTransferEncoding(Options.ChunkedEncodingPolicy.ALWAYS));
        String path = "/response/length";
        this.target.register(WireMock.head((UrlPattern)WireMock.urlPathEqualTo((String)path)).willReturn(WireMock.ok().withHeader("Content-Length", new String[]{"4"})));
        this.proxy.register(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        CloseableHttpClient httpClient = HttpClientFactory.createClient();
        HttpHead request = new HttpHead(this.proxyingService.baseUrl() + path);
        try (CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)request);){
            MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getFirstHeader("Content-Length").getValue(), (Matcher)Matchers.is((Object)"4"));
        }
    }

    @Test
    public void returnsContentLengthHeaderFromTargetResponseIfPresentAndChunkedEncodingDisabled() throws Exception {
        this.init(WireMockConfiguration.wireMockConfig().useChunkedTransferEncoding(Options.ChunkedEncodingPolicy.NEVER));
        String path = "/response/length";
        this.target.register(WireMock.head((UrlPattern)WireMock.urlPathEqualTo((String)path)).willReturn(WireMock.ok().withHeader("Content-Length", new String[]{"4"})));
        this.proxy.register(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        CloseableHttpClient httpClient = HttpClientFactory.createClient();
        HttpHead request = new HttpHead(this.proxyingService.baseUrl() + path);
        try (CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)request);){
            MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getFirstHeader("Content-Length").getValue(), (Matcher)Matchers.is((Object)"4"));
        }
    }

    @Test
    public void sendsTransferEncodingChunkedWhenPostingIfPresentInOriginalRequest() {
        this.initWithDefaultConfig();
        this.target.register(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/chunked")).willReturn(WireMock.aResponse().withStatus(201)));
        this.proxy.register(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/chunked")).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        this.testClient.postWithChunkedBody("/chunked", "TEST".getBytes());
        this.target.verifyThat(WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/chunked")).withHeader("Transfer-Encoding", WireMock.equalTo((String)"chunked")));
    }

    @Test
    public void preservesHostHeaderWhenSpecified() {
        this.init(WireMockConfiguration.wireMockConfig().preserveHostHeader(true));
        this.target.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/preserve-host-header")).willReturn(WireMock.aResponse().withStatus(200)));
        this.proxy.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/preserve-host-header")).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        this.testClient.get("/preserve-host-header", TestHttpHeader.withHeader("Host", "my.host"));
        this.proxy.verifyThat(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/preserve-host-header")).withHeader("Host", WireMock.equalTo((String)"my.host")));
        this.target.verifyThat(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/preserve-host-header")).withHeader("Host", WireMock.equalTo((String)"my.host")));
    }

    @Test
    public void usesProxyUrlBasedHostHeaderWhenPreserveHostHeaderNotSpecified() {
        this.init(WireMockConfiguration.wireMockConfig().preserveHostHeader(false));
        this.target.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/host-header")).willReturn(WireMock.aResponse().withStatus(200)));
        this.proxy.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/host-header")).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        this.testClient.get("/host-header", TestHttpHeader.withHeader("Host", "my.host"));
        this.proxy.verifyThat(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/host-header")).withHeader("Host", WireMock.equalTo((String)"my.host")));
        this.target.verifyThat(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/host-header")).withHeader("Host", WireMock.equalTo((String)("localhost:" + this.targetService.port()))));
    }

    @Test
    public void proxiesPatchRequestsWithBody() {
        this.initWithDefaultConfig();
        this.target.register(WireMock.patch((UrlPattern)WireMock.urlEqualTo((String)"/patch")).willReturn(WireMock.aResponse().withStatus(200)));
        this.proxy.register(WireMock.patch((UrlPattern)WireMock.urlEqualTo((String)"/patch")).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        this.testClient.patchWithBody("/patch", "Patch body", "text/plain", "utf-8");
        this.target.verifyThat(WireMock.patchRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/patch")).withRequestBody((ContentPattern)WireMock.equalTo((String)"Patch body")));
    }

    @Test
    public void addsSpecifiedHeadersToResponse() {
        this.initWithDefaultConfig();
        this.target.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/extra/headers")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/plain"}).withBody("Proxied content")));
        this.proxy.register(WireMock.any((UrlPattern)WireMock.urlEqualTo((String)"/extra/headers")).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().withHeader("X-Additional-Header", new String[]{"Yep"}).proxiedFrom(this.targetServiceBaseUrl)));
        WireMockResponse response = this.testClient.get("/extra/headers", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.firstHeader("Content-Type"), (Matcher)Matchers.is((Object)"text/plain"));
        MatcherAssert.assertThat((Object)response.firstHeader("X-Additional-Header"), (Matcher)Matchers.is((Object)"Yep"));
    }

    @Test
    public void doesNotDuplicateCookieHeaders() {
        this.initWithDefaultConfig();
        this.target.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/duplicate/cookies")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Set-Cookie", new String[]{"session=1234"})));
        this.proxy.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/duplicate/cookies")).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        this.testClient.get("/duplicate/cookies", new TestHttpHeader[0]);
        this.testClient.get("/duplicate/cookies", TestHttpHeader.withHeader("Cookie", "session=1234"));
        LoggedRequest lastRequest = (LoggedRequest)Iterables.getLast((Iterable)this.target.find(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/duplicate/cookies"))));
        MatcherAssert.assertThat((Object)lastRequest.getHeaders().getHeader("Cookie").values().size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void doesNotDuplicateConnectionHeader() {
        this.initWithDefaultConfig();
        this.register200StubOnProxyAndTarget("/duplicate/connection-header");
        this.testClient.get("/duplicate/connection-header", new TestHttpHeader[0]);
        LoggedRequest lastRequest = (LoggedRequest)Iterables.getLast((Iterable)this.target.find(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/duplicate/connection-header"))));
        MatcherAssert.assertThat((Object)lastRequest.getHeaders().getHeader("Connection").values().size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void acceptsSelfSignedSslCertFromProxyTarget() {
        this.initWithDefaultConfig();
        this.register200StubOnProxyAndTarget("/ssl-cert");
        MatcherAssert.assertThat((Object)this.testClient.get("/ssl-cert", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void canProxyViaAForwardProxy() {
        WireMockServer forwardProxy = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().enableBrowserProxying(true));
        forwardProxy.start();
        this.init(WireMockConfiguration.wireMockConfig().proxyVia(new ProxySettings("localhost", forwardProxy.port())));
        this.register200StubOnProxyAndTarget("/proxy-via");
        MatcherAssert.assertThat((Object)this.testClient.get("/proxy-via", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void doesNotAddAcceptEncodingHeaderToProxyRequest() {
        this.initWithDefaultConfig();
        this.register200StubOnProxyAndTarget("/no-accept-encoding-header");
        this.testClient.get("/no-accept-encoding-header", new TestHttpHeader[0]);
        LoggedRequest lastRequest = (LoggedRequest)Iterables.getLast((Iterable)this.target.find(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/no-accept-encoding-header"))));
        Assertions.assertFalse((boolean)lastRequest.getHeaders().getHeader("Accept-Encoding").isPresent(), (String)"Accept-Encoding header should not be present");
    }

    @Test
    public void passesMultipleValuesOfTheSameHeaderToTheTarget() {
        this.initWithDefaultConfig();
        this.register200StubOnProxyAndTarget("/multi-value-header");
        this.testClient.get("/multi-value-header", TestHttpHeader.withHeader("Accept", "accept1"), TestHttpHeader.withHeader("Accept", "accept2"));
        LoggedRequest lastRequest = (LoggedRequest)Iterables.getLast((Iterable)this.target.find(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/multi-value-header"))));
        MatcherAssert.assertThat((Object)lastRequest.header("Accept").values(), (Matcher)Matchers.hasItems((Object[])new String[]{"accept1", "accept2"}));
    }

    @Test
    public void maintainsGZippedRequest() {
        this.initWithDefaultConfig();
        this.target.register(WireMock.post((String)"/gzipped").willReturn(WireMock.aResponse().withStatus(201)));
        this.proxy.register(WireMock.post((String)"/gzipped").willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        GzipCompressingEntity gzippedBody = new GzipCompressingEntity((HttpEntity)new StringEntity("gzipped body", ContentType.TEXT_PLAIN));
        this.testClient.post("/gzipped", (HttpEntity)gzippedBody, new TestHttpHeader[0]);
        this.target.verifyThat(WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/gzipped")).withHeader("Content-Encoding", WireMock.containing((String)"gzip")).withRequestBody((ContentPattern)WireMock.equalTo((String)"gzipped body")));
    }

    @Test
    public void contextPathsWithoutTrailingSlashesArePreserved() {
        this.initWithDefaultConfig();
        this.target.register(WireMock.get((String)"/example").willReturn(WireMock.ok()));
        this.proxy.register(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        WireMockResponse response = this.testClient.getViaProxy("http://localhost:" + this.proxyingService.port() + "/example");
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        this.target.verifyThat(1, WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/example")));
        this.target.verifyThat(0, WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/example/")));
    }

    @Test
    public void contextPathsWithTrailingSlashesArePreserved() {
        this.initWithDefaultConfig();
        this.target.register(WireMock.get((String)"/example/").willReturn(WireMock.ok()));
        this.proxy.register(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        WireMockResponse response = this.testClient.getViaProxy("http://localhost:" + this.proxyingService.port() + "/example/");
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        this.target.verifyThat(1, WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/example/")));
        this.target.verifyThat(0, WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/example")));
    }

    @Test
    public void clientLibrariesTendToAddTheTrailingSlashWhenTheContextPathIsEmpty() {
        this.initWithDefaultConfig();
        this.target.register(WireMock.get((String)"/").willReturn(WireMock.ok()));
        this.proxy.register(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        WireMockResponse responseToRequestWithoutSlash = this.testClient.getViaProxy("http://localhost:" + this.proxyingService.port());
        MatcherAssert.assertThat((Object)responseToRequestWithoutSlash.statusCode(), (Matcher)Matchers.is((Object)200));
        WireMockResponse responseToRequestWithSlash = this.testClient.getViaProxy("http://localhost:" + this.proxyingService.port() + "/");
        MatcherAssert.assertThat((Object)responseToRequestWithSlash.statusCode(), (Matcher)Matchers.is((Object)200));
        this.target.verifyThat(2, WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/")));
        this.target.verifyThat(0, WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"")));
    }

    @Test
    public void fixedDelaysAreAddedToProxiedResponses() {
        this.initWithDefaultConfig();
        this.target.register(WireMock.get((String)"/delayed").willReturn(WireMock.ok()));
        this.proxy.register(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl).withFixedDelay(Integer.valueOf(300))));
        Stopwatch stopwatch = Stopwatch.createStarted();
        WireMockResponse response = this.testClient.getViaProxy("http://localhost:" + this.proxyingService.port() + "/delayed");
        stopwatch.stop();
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)stopwatch.elapsed(TimeUnit.MILLISECONDS), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(300L)));
    }

    @Test
    public void chunkedDribbleDelayIsAddedToProxiedResponse() {
        this.initWithDefaultConfig();
        this.target.register(WireMock.get((String)"/chunk-delayed").willReturn(WireMock.ok()));
        this.proxy.register(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl).withChunkedDribbleDelay(10, 300)));
        Stopwatch stopwatch = Stopwatch.createStarted();
        WireMockResponse response = this.testClient.getViaProxy("http://localhost:" + this.proxyingService.port() + "/chunk-delayed");
        stopwatch.stop();
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)stopwatch.elapsed(TimeUnit.MILLISECONDS), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(300L)));
    }

    @Test
    public void removesPrefixFromProxyRequestWhenMatching() {
        this.initWithDefaultConfig();
        this.proxy.register(WireMock.get((String)"/other/service/doc/123").willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl + "/approot").withProxyUrlPrefixToRemove("/other/service")));
        this.target.register(WireMock.get((String)"/approot/doc/123").willReturn(WireMock.ok()));
        WireMockResponse response = this.testClient.get("/other/service/doc/123", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void removesPrefixFromProxyRequestWhenResponseTransformersAreUsed() {
        this.init(WireMockConfiguration.wireMockConfig().templatingEnabled(true).globalTemplating(true));
        this.proxy.register(WireMock.get((String)"/other/service/doc/123").willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl + "/approot").withProxyUrlPrefixToRemove("/other/service")));
        this.target.register(WireMock.get((String)"/approot/doc/123").willReturn(WireMock.ok()));
        WireMockResponse response = this.testClient.get("/other/service/doc/123", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @ParameterizedTest
    @ValueSource(strings={"GET", "HEAD", "POST", "PUT", "PATCH", "DELETE", "BLAH"})
    void proxiesRequestBodyForAnyMethod(String method) {
        this.initWithDefaultConfig();
        this.target.register(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok()));
        this.proxy.register(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        this.testClient.request(method, "/somewhere", "Proxied content", new TestHttpHeader[0]);
        List requests = this.target.find(WireMock.anyRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/somewhere")));
        MatcherAssert.assertThat((Object)requests.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((LoggedRequest)requests.get(0)).getMethod().getName(), (Matcher)Matchers.is((Object)method));
        MatcherAssert.assertThat((Object)((LoggedRequest)requests.get(0)).getBodyAsString(), (Matcher)Matchers.is((Object)"Proxied content"));
    }

    @Test
    void preventsProxyingToExcludedIpAddress() {
        this.init(WireMockConfiguration.wireMockConfig().limitProxyTargets(NetworkAddressRules.builder().deny("10.1.2.3").deny("192.168.10.1-192.168.11.254").build()));
        this.proxy.register(WireMock.proxyAllTo((String)"https://10.1.2.3"));
        WireMockResponse response = this.testClient.get("/", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)500));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"The target proxy address is denied in WireMock's configuration."));
        this.proxy.register(WireMock.proxyAllTo((String)"https://192.168.10.255"));
        MatcherAssert.assertThat((Object)this.testClient.get("/", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)500));
    }

    @Test
    void preventsProxyingToExcludedHostnames() {
        this.init(WireMockConfiguration.wireMockConfig().limitProxyTargets(NetworkAddressRules.builder().deny("*.wiremock.org").build()));
        this.proxy.register(WireMock.proxyAllTo((String)"http://noway.wiremock.org"));
        MatcherAssert.assertThat((Object)this.testClient.get("/", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"The target proxy address is denied in WireMock's configuration."));
    }

    @Test
    void preventsProxyingToNonIncludedHostnames() {
        this.init(WireMockConfiguration.wireMockConfig().limitProxyTargets(NetworkAddressRules.builder().allow("wiremock.org").build()));
        this.proxy.register(WireMock.proxyAllTo((String)"http://wiremock.io"));
        MatcherAssert.assertThat((Object)this.testClient.get("/", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"The target proxy address is denied in WireMock's configuration."));
    }

    @Test
    void preventsProxyingToIpResolvedFromHostname() {
        this.init(WireMockConfiguration.wireMockConfig().limitProxyTargets(NetworkAddressRules.builder().deny("127.0.0.1").build()));
        this.proxy.register(WireMock.proxyAllTo((String)"http://localhost"));
        MatcherAssert.assertThat((Object)this.testClient.get("/", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"The target proxy address is denied in WireMock's configuration."));
    }

    @Test
    void proxyRequestWillNotTimeoutIfProxyResponseIsFastEnough() {
        this.init(WireMockConfiguration.wireMockConfig().proxyTimeout(1000));
        this.target.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/proxied/resource?param=value")).willReturn(WireMock.aResponse().withFixedDelay(Integer.valueOf(500)).withStatus(200).withHeader("Content-Type", new String[]{"text/plain"}).withBody("Proxied content")));
        this.proxy.register(WireMock.any((UrlPattern)WireMock.urlEqualTo((String)"/proxied/resource?param=value")).atPriority(Integer.valueOf(10)).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        WireMockResponse response = this.testClient.get("/proxied/resource?param=value", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"Proxied content"));
        MatcherAssert.assertThat((Object)response.firstHeader("Content-Type"), (Matcher)Matchers.is((Object)"text/plain"));
    }

    @Test
    void proxyRequestWillTimeoutIfProxyResponseIsTooSlow() {
        this.init(WireMockConfiguration.wireMockConfig().proxyTimeout(1000));
        this.target.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/proxied/resource?param=value")).willReturn(WireMock.aResponse().withFixedDelay(Integer.valueOf(1500)).withStatus(200).withHeader("Content-Type", new String[]{"text/plain"}).withBody("Proxied content")));
        this.proxy.register(WireMock.any((UrlPattern)WireMock.urlEqualTo((String)"/proxied/resource?param=value")).atPriority(Integer.valueOf(10)).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
        WireMockResponse response = this.testClient.get("/proxied/resource?param=value", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.startsWith((String)"Network failure trying to make a proxied request from WireMock"));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)500));
    }

    private void register200StubOnProxyAndTarget(String url) {
        this.target.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)url)).willReturn(WireMock.aResponse().withStatus(200)));
        this.proxy.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)url)).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.targetServiceBaseUrl)));
    }
}

