/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Gzip;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.requestfilter.RequestFilterAction;
import com.github.tomakehurst.wiremock.extension.requestfilter.RequestWrapper;
import com.github.tomakehurst.wiremock.extension.requestfilter.StubRequestFilter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.testsupport.TestFiles;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import com.github.tomakehurst.wiremock.verification.notmatched.NotMatchedRenderer;
import java.util.Collections;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public class NotMatchedPageAcceptanceTest {
    WireMockServer wm;
    WireMockTestClient testClient;

    @AfterEach
    public void stop() {
        this.wm.stop();
    }

    @Test
    public void rendersAPlainTextDiffWhenStubNotMatchedAndANearMissIsAvailable() {
        this.configure();
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/thing").withName("The post stub with a really long name that ought to wrap and let us see exactly how that looks when it is done").withHeader("X-My-Header", WireMock.containing((String)"correct value")).withHeader("Accept", WireMock.matching((String)"text/plain.*")).withRequestBody((ContentPattern)WireMock.equalToJson((String)"{                              \n    \"thing\": {               \n        \"stuff\": [1, 2, 3]   \n    }                          \n}")).willReturn(WireMock.ok()));
        WireMockResponse response = this.testClient.postJson("/thin", "{                        \n    \"thing\": {           \n        \"nothing\": {}    \n    }                      \n}", TestHttpHeader.withHeader("X-My-Header", "wrong value"), TestHttpHeader.withHeader("Accept", "text/plain"));
        MatcherAssert.assertThat((Object)response.content(), WireMatchers.equalsMultiLine(TestFiles.file("not-found-diff-sample_ascii.txt")));
    }

    @Test
    public void adjustsWidthWhenConsoleWidthHeaderSpecified() {
        this.configure();
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/thing").withName("The post stub with a really long name that ought to wrap and let us see exactly how that looks when it is done").withHeader("X-My-Header", WireMock.containing((String)"correct value")).withHeader("Accept", WireMock.matching((String)"text/plain.*")).withRequestBody((ContentPattern)WireMock.equalToJson((String)"{                              \n    \"thing\": {               \n        \"stuff\": [1, 2, 3]   \n    }                          \n}")).willReturn(WireMock.ok()));
        WireMockResponse response = this.testClient.postJson("/thin", "{                        \n    \"thing\": {           \n        \"nothing\": {}    \n    }                      \n}", TestHttpHeader.withHeader("X-My-Header", "wrong value"), TestHttpHeader.withHeader("Accept", "text/plain"), TestHttpHeader.withHeader("X-WireMock-Console-Width", "69"));
        System.out.println(response.content());
        MatcherAssert.assertThat((Object)response.content(), WireMatchers.equalsMultiLine(TestFiles.file("not-found-diff-sample_ascii-narrow.txt")));
    }

    @Test
    public void rendersAPlainTextDiffWhenRequestIsOnlyUrlAndMethod() {
        this.configure();
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/another-url").withRequestBody((ContentPattern)WireMock.absent()).willReturn(WireMock.ok()));
        WireMockResponse response = this.testClient.get("/gettable", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void showsADefaultMessageWhenNoStubsWerePresent() {
        this.configure();
        WireMockResponse response = this.testClient.get("/no-stubs-to-match", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((Object)response.firstHeader("Content-Type"), (Matcher)Matchers.startsWith((String)"text/plain"));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"No response could be served as there are no stub mappings in this WireMock instance."));
    }

    @Test
    public void supportsCustomNoMatchRenderer() {
        this.configure(WireMockConfiguration.wireMockConfig().notMatchedRendererFactory(extensions -> new NotMatchedRenderer(){

            protected ResponseDefinition render(Admin admin, ServeEvent serveEvent) {
                return ResponseDefinitionBuilder.responseDefinition().withStatus(403).withBody("No you don't!").build();
            }
        }));
        WireMockResponse response = this.testClient.get("/should-not-match", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)403));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"No you don't!"));
    }

    @Test
    public void returns404AndDiffReportWhenPlusSymbolInQuery() {
        this.configure();
        WireMockResponse response = this.testClient.get("/some/api/records?sort=updated+asc&filter_updated_gt=2019-01-02", new TestHttpHeader[0]);
        System.err.println(response.content());
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.containsString((String)"No response could be served"));
    }

    @Test
    public void indicatesWhenWrongScenarioStateIsTheReasonForNonMatch() {
        this.configure();
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/thing").inScenario("thing states").whenScenarioStateIs("first").willReturn(WireMock.ok((String)"Done!")));
        WireMockResponse response = this.testClient.postJson("/thing", "{}", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.content(), WireMatchers.equalsMultiLine(TestFiles.file("not-found-diff-sample_scenario-state.txt")));
    }

    @Test
    public void showsDescriptiveDiffLineForLogicalOrWithAbsent() {
        this.configure();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/or")).withHeader("X-Maybe", (StringValuePattern)WireMock.equalTo((String)"one").or(WireMock.absent())).willReturn(WireMock.ok()));
        WireMockResponse response = this.testClient.get("/or", TestHttpHeader.withHeader("X-Maybe", "wrong"));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((Object)response.content(), WireMatchers.equalsMultiLine(TestFiles.file("not-found-diff-sample-logical-or.txt")));
    }

    @Test
    public void requestValuesTransformedByRequestFilterAreShownInDiff() {
        this.configure(WireMockConfiguration.wireMockConfig().extensions(new Extension[]{new StubRequestFilter(){

            public RequestFilterAction filter(Request request) {
                Request wrappedRequest = RequestWrapper.create().transformHeader("X-My-Header", source -> Collections.singletonList("modified value")).wrap(request);
                return RequestFilterAction.continueWith((Request)wrappedRequest);
            }

            public String getName() {
                return "thing-changer-filter";
            }
        }}));
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/filter").withHeader("X-My-Header", WireMock.equalTo((String)"original value")).willReturn(WireMock.ok()));
        WireMockResponse response = this.testClient.get("/filter", TestHttpHeader.withHeader("X-My-Header", "original value"));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.containsString((String)"| X-My-Header: modified value"));
    }

    @Test
    public void showsNotFoundDiffMessageForNonStandardHttpMethods() {
        this.configure();
        WireMock.stubFor((MappingBuilder)WireMock.request((String)"PAAARP", (UrlPattern)WireMock.urlPathEqualTo((String)"/pip")).willReturn(WireMock.ok()));
        WireMockResponse response = this.testClient.request("PAAARP", "/pop", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.containsString((String)"Request was not matched"));
    }

    @Test
    public void showsNotFoundDiffMessageWhenRequestBodyIsGZipped() {
        this.configure();
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlPathEqualTo((String)"/gzip")).withHeader("Content-Encoding", WireMock.equalToIgnoreCase((String)"gzip")).withRequestBody((ContentPattern)WireMock.equalToJson((String)"{\"id\":\"ok\"}")).willReturn(WireMock.ok()));
        ByteArrayEntity entity = new ByteArrayEntity(Gzip.gzip((String)"{\"id\":\"wrong\"}"), ContentType.DEFAULT_BINARY);
        WireMockResponse response = this.testClient.post("/gzip", (HttpEntity)entity, TestHttpHeader.withHeader("Content-Encoding", "gzip"));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.containsString((String)"Request was not matched"));
    }

    private void configure() {
        this.configure(WireMockConfiguration.wireMockConfig().dynamicPort());
    }

    private void configure(WireMockConfiguration options) {
        options.dynamicPort().withRootDirectory("src/test/resources/empty");
        this.wm = new WireMockServer((Options)options);
        this.wm.start();
        this.testClient = new WireMockTestClient(this.wm.port());
        WireMock.configureFor((int)this.wm.port());
    }
}

