/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.client.VerificationException;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.TestNotifier;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import com.github.tomakehurst.wiremock.verification.diff.JUnitStyleDiffRenderer;
import ignored.ManyUnmatchedRequestsTest;
import ignored.SingleUnmatchedRequestTest;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;

public class NearMissesRuleAcceptanceTest {

    @Nested
    class CustomMatcherWithNearMissesTest {
        @RegisterExtension
        public WireMockExtension wmeWithCustomMatcher = WireMockExtension.newInstance().options((Options)WireMockConfiguration.options().dynamicPort().withRootDirectory("src/main/resources/empty").extensions(new Extension[]{new RequestMatcherExtension(){

            public MatchResult match(Request request, Parameters parameters) {
                return MatchResult.partialMatch((double)0.5);
            }

            public String getName() {
                return "always-match";
            }
        }})).build();
        WireMockTestClient client;

        CustomMatcherWithNearMissesTest() {
        }

        @BeforeEach
        public void init() {
            this.client = new WireMockTestClient(this.wmeWithCustomMatcher.getPort());
        }

        @Test
        public void successfullyCalculatesNearMissesWhenACustomMatcherIsRegistered() {
            this.wmeWithCustomMatcher.stubFor(WireMock.requestMatching((String)"always-match").willReturn(WireMock.aResponse()));
            this.client.get("/", new TestHttpHeader[0]);
            MatcherAssert.assertThat((Object)this.wmeWithCustomMatcher.findNearMissesForAllUnmatchedRequests().size(), (Matcher)Matchers.is((Object)1));
        }
    }

    @Nested
    class NearMissesRuleTest {
        private TestNotifier testNotifier = new TestNotifier();
        @RegisterExtension
        public WireMockExtension wm = WireMockExtension.newInstance().options((Options)WireMockConfiguration.options().dynamicPort().notifier((Notifier)this.testNotifier).withRootDirectory("src/main/resources/empty")).build();
        WireMockTestClient client;

        NearMissesRuleTest() {
        }

        @BeforeEach
        public void init() {
            this.client = new WireMockTestClient(this.wm.getPort());
            this.testNotifier.reset();
        }

        @Test
        public void logsUnmatchedRequestsAtErrorWithNearMisses() throws Exception {
            this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/near-miss")).willReturn(WireMock.aResponse().withStatus(200)));
            this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/miss")).willReturn(WireMock.aResponse().withStatus(200)));
            this.client.post("/a-near-mis", (HttpEntity)new StringEntity(""), new TestHttpHeader[0]);
            MatcherAssert.assertThat(this.testNotifier.getErrorMessages(), (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"Request was not matched"), (Matcher)Matchers.containsString((String)"/a-near-mis"), (Matcher)Matchers.containsString((String)"/near-miss"), (Matcher)Matchers.containsString((String)"HTTP method does not match"), (Matcher)Matchers.containsString((String)"URL does not match"))));
        }

        @Test
        public void throwsVerificationExceptionIfSomeRequestsWentUnmatched() {
            String message = this.runTestAndGetMessage(ManyUnmatchedRequestsTest.class);
            MatcherAssert.assertThat((Object)message, (Matcher)Matchers.containsString((String)"2 requests were unmatched by any stub mapping"));
            MatcherAssert.assertThat((Object)message, (Matcher)Matchers.containsString((String)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"GET\n/hit\n", (Object)"GET\n/near-misssss\n")));
            MatcherAssert.assertThat((Object)message, (Matcher)Matchers.containsString((String)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"GET\n/hit\n", (Object)"GET\n/a-near-mis\n")));
        }

        @Test
        public void throwsVerificationExceptionIfASingleRequestWentUnmatched() {
            String message = this.runTestAndGetMessage(SingleUnmatchedRequestTest.class);
            MatcherAssert.assertThat((Object)message, (Matcher)Matchers.containsString((String)"A request was unmatched by any stub mapping. Closest stub mapping was:"));
            MatcherAssert.assertThat((Object)message, (Matcher)Matchers.containsString((String)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"GET\n/hit\n", (Object)"GET\n/near-misssss\n")));
        }

        @Test
        public void shouldFindNearMatch() {
            Throwable exception = Assertions.assertThrows(VerificationException.class, () -> {
                this.client.get("/123", new TestHttpHeader[0]);
                this.wm.verify(WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/")));
            });
            Assertions.assertTrue((boolean)exception.getMessage().contains("No requests exactly matched. Most similar request was:"));
        }

        private String runTestAndGetMessage(Class<?> testClass) {
            final AtomicReference<String> message = new AtomicReference<String>("");
            LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass(testClass)}).build();
            Launcher launcher = LauncherFactory.create();
            launcher.registerTestExecutionListeners(new TestExecutionListener[]{new TestExecutionListener(){

                public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
                    testExecutionResult.getThrowable().map(Throwable::getMessage).ifPresent(message::set);
                }
            }});
            launcher.execute(request, new TestExecutionListener[0]);
            return message.get();
        }
    }
}

