/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.MockRequest;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.NearMiss;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class NearMissesAcceptanceTest
extends AcceptanceTestBase {
    @Test
    public void nearMisses() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/mypath")).withHeader("My-Header", WireMock.equalTo((String)"matched")).willReturn(WireMock.aResponse().withStatus(200)));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/otherpath")).withHeader("My-Header", WireMock.equalTo((String)"otherheaderval")).willReturn(WireMock.aResponse().withStatus(200)));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/yet/another/path")).withHeader("X-Alt-Header", WireMock.equalTo((String)"matchonthis")).willReturn(WireMock.aResponse().withStatus(200)));
        testClient.get("/otherpath", TestHttpHeader.withHeader("My-Header", "notmatched"));
        List nearMisses = WireMock.findNearMissesForAllUnmatched();
        MatcherAssert.assertThat((Object)((NearMiss)nearMisses.get(0)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/otherpath"));
        MatcherAssert.assertThat((Object)((NearMiss)nearMisses.get(1)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/otherpath"));
        MatcherAssert.assertThat((Object)((NearMiss)nearMisses.get(2)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/otherpath"));
        MatcherAssert.assertThat((Object)((NearMiss)nearMisses.get(0)).getStubMapping().getRequest().getUrl(), (Matcher)Matchers.is((Object)"/otherpath"));
        MatcherAssert.assertThat((Object)((NearMiss)nearMisses.get(1)).getStubMapping().getRequest().getUrl(), (Matcher)Matchers.is((Object)"/yet/another/path"));
        MatcherAssert.assertThat((Object)((NearMiss)nearMisses.get(2)).getStubMapping().getRequest().getUrl(), (Matcher)Matchers.is((Object)"/mypath"));
    }

    @Test
    public void returnsAllUnmatchedRequests() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/mypath")).withHeader("My-Header", WireMock.equalTo((String)"matched")).willReturn(WireMock.aResponse().withStatus(200)));
        testClient.get("/unmatched/path", new TestHttpHeader[0]);
        List unmatched = WireMock.findUnmatchedRequests();
        MatcherAssert.assertThat((Object)unmatched.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((LoggedRequest)unmatched.get(0)).getUrl(), (Matcher)Matchers.is((Object)"/unmatched/path"));
    }

    @Test
    public void returnsStubMappingNearMissesForARequest() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/mypath")).withHeader("My-Header", WireMock.equalTo((String)"matched")).willReturn(WireMock.aResponse().withStatus(200)));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/otherpath")).withHeader("My-Header", WireMock.equalTo((String)"otherheaderval")).willReturn(WireMock.aResponse().withStatus(200)));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/yet/another/path")).withHeader("X-Alt-Header", WireMock.equalTo((String)"matchonthis")).willReturn(WireMock.aResponse().withStatus(200)));
        List nearMisses = WireMock.findNearMissesFor((LoggedRequest)LoggedRequest.createFrom((Request)MockRequest.mockRequest().url("/otherpath").header("My-Header", "notmatched")));
        MatcherAssert.assertThat((Object)((NearMiss)nearMisses.get(0)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/otherpath"));
        MatcherAssert.assertThat((Object)((NearMiss)nearMisses.get(1)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/otherpath"));
        MatcherAssert.assertThat((Object)((NearMiss)nearMisses.get(2)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/otherpath"));
        MatcherAssert.assertThat((Object)((NearMiss)nearMisses.get(0)).getStubMapping().getRequest().getUrl(), (Matcher)Matchers.is((Object)"/otherpath"));
        MatcherAssert.assertThat((Object)((NearMiss)nearMisses.get(1)).getStubMapping().getRequest().getUrl(), (Matcher)Matchers.is((Object)"/yet/another/path"));
        MatcherAssert.assertThat((Object)((NearMiss)nearMisses.get(2)).getStubMapping().getRequest().getUrl(), (Matcher)Matchers.is((Object)"/mypath"));
    }

    @Test
    public void returnsRequestNearMissesForARequestPattern() {
        testClient.get("/actual11", new TestHttpHeader[0]);
        testClient.get("/actual42", new TestHttpHeader[0]);
        List nearMisses = WireMock.findNearMissesFor((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/actual4")).withRequestBody((ContentPattern)WireMock.containing((String)"thing")));
        MatcherAssert.assertThat((Object)nearMisses.size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)((NearMiss)nearMisses.get(0)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/actual42"));
        MatcherAssert.assertThat((Object)((NearMiss)nearMisses.get(1)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/actual11"));
    }
}

